/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.$generator$.$AnnotationMirrors;
import org.immutables.value.internal.$guava$.base.$Function;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.meta.$NullabilityAnnotationInfo;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$UnshadeJackson;

final class $Annotations {
    private static final String PREFIX_JAVA_LANG = "java.lang.";
    private static final String PREFIX_IMMUTABLES = "org.immutables.";
    private static final String PREFIX_JACKSON = $UnshadeJackson.qualify("");
    private static final String PREFIX_JACKSON_IGNORE_PROPERTIES = $UnshadeJackson.qualify("annotation.JsonIgnoreProperties");
    static final String JACKSON_PROPERTY = $UnshadeJackson.qualify("annotation.JsonProperty");
    static final String JACKSON_ANY_GETTER = $UnshadeJackson.qualify("annotation.JsonAnyGetter");
    static final String JACKSON_VALUE = $UnshadeJackson.qualify("annotation.JsonValue");
    static final String JAVAX_NULLABLE = "javax.annotation.Nullable";
    static final String JAVAX_CHECK_FOR_NULL = "javax.annotation.CheckForNull";
    static final String JAKARTA_NULLABLE = "jakarta.annotation.Nullable";
    static final String JAKARTA_CHECK_FOR_NULL = "jakarta.annotation.CheckForNull";

    private $Annotations() {
    }

    static List<CharSequence> getAnnotationLines(Element element, Set<String> includeAnnotations, boolean includeJacksonAnnotations, ElementType elementType, $Function<String, String> importsResolver, @Nullable $NullabilityAnnotationInfo nullability) {
        return $Annotations.getAnnotationLines(element, includeAnnotations, false, includeJacksonAnnotations, elementType, importsResolver, nullability);
    }

    static List<CharSequence> getAnnotationLines(Element element, Set<String> includeAnnotations, boolean includeAllAnnotations, boolean includeJacksonAnnotations, ElementType elementType, $Function<String, String> importsResolver, @Nullable $NullabilityAnnotationInfo nullability) {
        ArrayList<CharSequence> lines = $Lists.newArrayList();
        HashSet<String> seenAnnotations = new HashSet<String>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!$Annotations.annotationTypeMatches(element, annotationElement, includeAnnotations, includeAllAnnotations, includeJacksonAnnotations, seenAnnotations, lines, importsResolver, elementType, nullability) || !$Annotations.annotationMatchesTarget(annotationElement, elementType)) continue;
            lines.add($AnnotationMirrors.toCharSequence(annotationMirror, importsResolver));
        }
        return lines;
    }

    private static boolean annotationTypeMatches(Element element, TypeElement annotationElement, Set<String> includeAnnotations, boolean includeAllAnnotations, boolean includeJacksonAnnotations, Set<String> seenAnnotations, List<CharSequence> lines, $Function<String, String> importsResolver, ElementType elementType, @Nullable $NullabilityAnnotationInfo nullability) {
        String qualifiedName = annotationElement.getQualifiedName().toString();
        if (seenAnnotations.contains(qualifiedName) || qualifiedName.startsWith(PREFIX_IMMUTABLES) || qualifiedName.startsWith(PREFIX_JAVA_LANG)) {
            return false;
        }
        seenAnnotations.add(qualifiedName);
        if ((includeJacksonAnnotations || includeAnnotations.size() == 1 && $Annotations.hasJacksonPackagePrefix($Iterables.getOnlyElement(includeAnnotations))) && $Proto.isAnnotatedWith(annotationElement, $Proto.JACKSON_ANNOTATIONS_INSIDE)) {
            for (AnnotationMirror annotationMirror : annotationElement.getAnnotationMirrors()) {
                TypeElement metaAnnotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                String qname = metaAnnotationElement.getQualifiedName().toString();
                if (seenAnnotations.contains(qname)) continue;
                seenAnnotations.add(qname);
                if (qname.equals($Proto.JACKSON_ANNOTATIONS_INSIDE) || qname.startsWith(PREFIX_IMMUTABLES) || qname.startsWith(PREFIX_JAVA_LANG) || qname.equals(JACKSON_ANY_GETTER) && !includeAnnotations.contains(JACKSON_ANY_GETTER) || qname.equals(JACKSON_VALUE) && !includeAnnotations.contains(JACKSON_VALUE) || !$Annotations.annotationMatchesTarget(metaAnnotationElement, elementType)) continue;
                lines.add($AnnotationMirrors.toCharSequence(annotationMirror, importsResolver));
            }
            return includeAllAnnotations;
        }
        if (nullability != null && annotationElement.getQualifiedName().contentEquals(nullability.qualifiedName())) {
            return false;
        }
        if (includeAllAnnotations) {
            return true;
        }
        if (qualifiedName.equals(PREFIX_JACKSON_IGNORE_PROPERTIES)) {
            return true;
        }
        if (includeJacksonAnnotations) {
            if (element.getKind() != ElementKind.METHOD && (qualifiedName.equals($Proto.JACKSON_DESERIALIZE) || qualifiedName.equals($Proto.JACKSON_SERIALIZE))) {
                return false;
            }
            if (qualifiedName.equals(JACKSON_ANY_GETTER)) {
                return false;
            }
            if (qualifiedName.equals(JACKSON_VALUE)) {
                return false;
            }
            if ($Annotations.hasJacksonPackagePrefix(qualifiedName)) {
                return true;
            }
        }
        if (includeAnnotations.contains(qualifiedName)) {
            return true;
        }
        if (includeJacksonAnnotations || !includeAnnotations.isEmpty()) {
            for (AnnotationMirror annotationMirror : annotationElement.getAnnotationMirrors()) {
                HashSet<String> throwawaySeenForParent;
                TypeElement parentElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (!$Annotations.annotationTypeMatches(element, parentElement, includeAnnotations, false, includeJacksonAnnotations, throwawaySeenForParent = new HashSet<String>(seenAnnotations), lines, importsResolver, elementType, nullability)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean annotationMatchesTarget(Element annotationElement, ElementType elementType) {
        Target target = annotationElement.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType t : target.value()) {
                if (t != elementType) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static boolean hasJacksonPackagePrefix(String qualifiedName) {
        return qualifiedName.startsWith(PREFIX_JACKSON);
    }
}

