/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation.provider;

import java.io.IOException;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DataValidationProvider {
    private static final Logger LOGGER = Logger.getLogger(DataValidationProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public static ValidateElement parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        String dataType = parser.getAttributeValue("", "datatype");
        ValidateElement dataValidation = null;
        ValidateElement.ListRange listRange = null;
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "open": {
                            dataValidation = new ValidateElement.OpenValidateElement(dataType);
                            break block0;
                        }
                        case "basic": {
                            dataValidation = new ValidateElement.BasicValidateElement(dataType);
                            break block0;
                        }
                        case "range": {
                            dataValidation = new ValidateElement.RangeValidateElement(dataType, parser.getAttributeValue("", "min"), parser.getAttributeValue("", "max"));
                            break block0;
                        }
                        case "regex": {
                            dataValidation = new ValidateElement.RegexValidateElement(dataType, parser.nextText());
                            break block0;
                        }
                        case "list-range": {
                            Long min = ParserUtils.getLongAttribute((XmlPullParser)parser, (String)"min");
                            Long max = ParserUtils.getLongAttribute((XmlPullParser)parser, (String)"max");
                            if (min != null || max != null) {
                                listRange = new ValidateElement.ListRange(min, max);
                                break block0;
                            }
                            LOGGER.fine("Ignoring list-range element without min or max attribute");
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    if (dataValidation == null) {
                        dataValidation = new ValidateElement.BasicValidateElement(dataType);
                    }
                    dataValidation.setListRange(listRange);
                    return dataValidation;
                }
            }
        }
    }
}

