/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JiveBeanInfo
implements BeanInfo {
    private static final Logger Log = LoggerFactory.getLogger(JiveBeanInfo.class);
    private ResourceBundle bundle;

    public JiveBeanInfo() {
        Locale currentLocale = JiveGlobals.getLocale();
        try {
            this.bundle = ResourceBundle.getBundle("bean_" + this.getName(), currentLocale);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract String[] getPropertyNames();

    public abstract Class getBeanClass();

    public abstract String getName();

    @Override
    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor descriptor = new BeanDescriptor(this.getBeanClass());
        try {
            String shortDescription;
            String displayName = this.bundle.getString("displayName");
            if (displayName != null) {
                descriptor.setDisplayName(displayName);
            }
            if ((shortDescription = this.bundle.getString("shortDescription")) != null) {
                descriptor.setShortDescription(shortDescription);
            }
            Enumeration<String> enumeration = this.bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                String value = this.bundle.getString(key);
                if (value == null) continue;
                descriptor.setValue(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return descriptor;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        Class beanClass = this.getBeanClass();
        String[] properties = this.getPropertyNames();
        PropertyDescriptor[] descriptors = new PropertyDescriptor[properties.length];
        try {
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor newDescriptor = new PropertyDescriptor(properties[i], beanClass);
                if (this.bundle != null) {
                    newDescriptor.setDisplayName(this.bundle.getString(properties[i] + ".displayName"));
                    newDescriptor.setShortDescription(this.bundle.getString(properties[i] + ".shortDescription"));
                }
                descriptors[i] = newDescriptor;
            }
            return descriptors;
        }
        catch (IntrospectionException ie) {
            Log.error(ie.getMessage(), (Throwable)ie);
            throw new Error(ie.toString());
        }
    }

    @Override
    public int getDefaultPropertyIndex() {
        return -1;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return null;
    }

    @Override
    public int getDefaultEventIndex() {
        return -1;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return null;
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return null;
    }

    @Override
    public Image getIcon(int iconKind) {
        return null;
    }
}

