/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaSpecVersion
implements Comparable<JavaSpecVersion> {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)");
    private final int major;
    private final int minor;

    public JavaSpecVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public JavaSpecVersion(CharSequence source) {
        if (source != null) {
            Matcher matcher = PATTERN.matcher(source);
            if (matcher.matches()) {
                this.major = Integer.parseInt(matcher.group(1));
                this.minor = Integer.parseInt(matcher.group(2));
            } else {
                this.minor = 0;
                this.major = 0;
            }
        } else {
            this.minor = 0;
            this.major = 0;
        }
    }

    public String getVersionString() {
        return this.major + "." + this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean isNewerThan(JavaSpecVersion otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    @Override
    public int compareTo(JavaSpecVersion that) {
        if (that == null) {
            return 1;
        }
        int result = Integer.compare(this.getMajor(), that.getMajor());
        if (result == 0) {
            result = Integer.compare(this.getMinor(), that.getMinor());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaSpecVersion)) {
            return false;
        }
        JavaSpecVersion other = (JavaSpecVersion)o;
        return Objects.equals(this.major, other.major) && Objects.equals(this.minor, other.minor);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    public String toString() {
        return this.getVersionString();
    }
}

