/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.websocket;

import org.dom4j.Element;
import org.jivesoftware.openfire.SessionPacketRouter;
import org.jivesoftware.openfire.multiplex.UnknownStanzaException;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.util.JiveGlobals;

public class StreamManagementPacketRouter
extends SessionPacketRouter {
    public static final String SM_UNSOLICITED_ACK_FREQUENCY = "stream.management.unsolicitedAckFrequency";
    private int unsolicitedAckFrequency = JiveGlobals.getIntProperty("stream.management.unsolicitedAckFrequency", 0);

    public StreamManagementPacketRouter(LocalClientSession session) {
        super(session);
    }

    @Override
    public void route(Element wrappedElement) throws UnknownStanzaException {
        if ("urn:xmpp:sm:3".equals(wrappedElement.getNamespace().getStringValue())) {
            this.session.getStreamManager().process(wrappedElement);
        } else {
            super.route(wrappedElement);
            if (this.isUnsolicitedAckExpected()) {
                this.session.getStreamManager().sendServerAcknowledgement();
            }
        }
    }

    private boolean isUnsolicitedAckExpected() {
        if (!this.session.getStreamManager().isEnabled()) {
            return false;
        }
        return this.unsolicitedAckFrequency > 0 && this.session.getNumClientPackets() % (long)this.unsolicitedAckFrequency == 0L;
    }

    static {
        JiveGlobals.migrateProperty(SM_UNSOLICITED_ACK_FREQUENCY);
    }
}

