/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNameProvider;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.xmpp.packet.JID;

public class UserNameManager {
    private static XMPPServer server = XMPPServer.getInstance();
    private static Map<String, UserNameProvider> providersByDomain = new ConcurrentHashMap<String, UserNameProvider>();

    private UserNameManager() {
    }

    public static void addUserNameProvider(String domain, UserNameProvider provider) {
        providersByDomain.put(domain, provider);
    }

    public static void removeUserNameProvider(String domain) {
        providersByDomain.remove(domain);
    }

    public static String getUserName(JID entity) throws UserNotFoundException {
        return UserNameManager.getUserName(entity, entity.toString());
    }

    public static String getUserName(JID entity, String defaultName) throws UserNotFoundException {
        if (server.isLocal(entity)) {
            User localUser = UserManager.getInstance().getUser(entity.getNode());
            return !localUser.isNameVisible() || "".equals(localUser.getName()) ? entity.getNode() : localUser.getName();
        }
        UserNameProvider provider = providersByDomain.get(entity.getDomain());
        if (provider != null) {
            return provider.getUserName(entity);
        }
        return defaultName;
    }
}

