/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserMultiProvider
implements UserProvider {
    private static final Logger Log = LoggerFactory.getLogger(UserMultiProvider.class);

    public static UserProvider instantiate(String propertyName) {
        String className = JiveGlobals.getProperty(propertyName);
        if (className == null) {
            Log.debug("Property '{}' is undefined. Skipping.", (Object)propertyName);
            return null;
        }
        Log.debug("About to to instantiate an UserProvider '{}' based on the value of property '{}'.", (Object)className, (Object)propertyName);
        try {
            Class c = ClassUtils.forName(className);
            UserProvider provider = (UserProvider)c.newInstance();
            Log.debug("Instantiated UserProvider '{}'", (Object)className);
            return provider;
        }
        catch (Exception e) {
            Log.error("Unable to load UserProvider '{}'. Users in this provider will be disabled.", (Object)className, (Object)e);
            return null;
        }
    }

    abstract Collection<UserProvider> getUserProviders();

    abstract UserProvider getUserProvider(String var1);

    @Override
    public int getUserCount() {
        int total = 0;
        for (UserProvider provider : this.getUserProviders()) {
            total += provider.getUserCount();
        }
        return total;
    }

    @Override
    public Collection<User> getUsers() {
        ArrayList<User> result = new ArrayList<User>();
        for (UserProvider provider : this.getUserProviders()) {
            result.addAll(provider.getUsers());
        }
        return result;
    }

    @Override
    public Collection<String> getUsernames() {
        ArrayList<String> result = new ArrayList<String>();
        for (UserProvider provider : this.getUserProviders()) {
            result.addAll(provider.getUsernames());
        }
        return result;
    }

    @Override
    public Collection<User> getUsers(int startIndex, int numResults) {
        ArrayList<User> userList = new ArrayList<User>();
        int totalUserCount = 0;
        for (UserProvider provider : this.getUserProviders()) {
            int providerStartIndex = Math.max(startIndex - totalUserCount, 0);
            if (startIndex >= (totalUserCount += provider.getUserCount())) continue;
            int providerResultMax = numResults - userList.size();
            userList.addAll(provider.getUsers(providerStartIndex, providerResultMax));
            if (userList.size() < numResults) continue;
            break;
        }
        return userList;
    }

    @Override
    public Collection<User> findUsers(Set<String> fields, String query) throws UnsupportedOperationException {
        ArrayList<User> userList = new ArrayList<User>();
        int supportSearch = this.getUserProviders().size();
        for (UserProvider provider : this.getUserProviders()) {
            try {
                HashSet<String> supportedFields = new HashSet<String>(fields);
                supportedFields.retainAll(provider.getSearchFields());
                userList.addAll(provider.findUsers(supportedFields, query));
            }
            catch (UnsupportedOperationException uoe) {
                Log.warn("UserProvider.findUsers is not supported by this UserProvider: {}. Its users are not returned as part of search queries.", (Object)provider.getClass().getName());
                --supportSearch;
            }
        }
        if (supportSearch == 0) {
            throw new UnsupportedOperationException("None of the backing providers support this operation.");
        }
        return userList;
    }

    @Override
    public Collection<User> findUsers(Set<String> fields, String query, int startIndex, int numResults) throws UnsupportedOperationException {
        ArrayList<User> userList = new ArrayList<User>();
        int supportSearch = this.getUserProviders().size();
        int totalMatchedUserCount = 0;
        for (UserProvider provider : this.getUserProviders()) {
            try {
                HashSet<String> supportedFields = new HashSet<String>(fields);
                supportedFields.retainAll(provider.getSearchFields());
                Collection<User> providerResults = provider.findUsers(fields, query);
                if (startIndex >= (totalMatchedUserCount += providerResults.size())) continue;
                int providerStartIndex = Math.max(0, startIndex - totalMatchedUserCount);
                int providerResultMax = numResults - userList.size();
                List<Object> providerList = providerResults instanceof List ? (List<Object>)providerResults : new ArrayList<User>(providerResults);
                userList.addAll(providerList.subList(providerStartIndex, providerResultMax));
                if (userList.size() < numResults) continue;
                break;
            }
            catch (UnsupportedOperationException uoe) {
                Log.warn("UserProvider.findUsers is not supported by this UserProvider: " + provider.getClass().getName());
                --supportSearch;
            }
        }
        if (supportSearch == 0) {
            throw new UnsupportedOperationException("None of the backing providers support this operation.");
        }
        return userList;
    }

    @Override
    public Set<String> getSearchFields() throws UnsupportedOperationException {
        int supportSearch = this.getUserProviders().size();
        HashSet<String> result = new HashSet<String>();
        for (UserProvider provider : this.getUserProviders()) {
            try {
                result.addAll(provider.getSearchFields());
            }
            catch (UnsupportedOperationException uoe) {
                Log.warn("getSearchFields is not supported by this UserProvider: " + provider.getClass().getName());
                --supportSearch;
            }
        }
        if (supportSearch == 0) {
            throw new UnsupportedOperationException("None of the backing providers support this operation.");
        }
        return result;
    }

    @Override
    public boolean isReadOnly() {
        for (UserProvider provider : this.getUserProviders()) {
            if (provider.isReadOnly()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNameRequired() {
        for (UserProvider provider : this.getUserProviders()) {
            if (provider.isNameRequired()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmailRequired() {
        for (UserProvider provider : this.getUserProviders()) {
            if (provider.isEmailRequired()) continue;
            return false;
        }
        return true;
    }
}

