/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.XMPPServerListener;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.handler.PresenceUpdateHandler;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.jivesoftware.openfire.privacy.PrivacyListManager;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class PresenceManagerImpl
extends BasicModule
implements PresenceManager,
UserEventListener,
XMPPServerListener {
    private static final Logger Log = LoggerFactory.getLogger(PresenceManagerImpl.class);
    private static final String LOAD_OFFLINE_PRESENCE = "SELECT offlinePresence, offlineDate FROM ofPresence WHERE username=?";
    private static final String INSERT_OFFLINE_PRESENCE = "INSERT INTO ofPresence(username, offlinePresence, offlineDate) VALUES(?,?,?)";
    private static final String DELETE_OFFLINE_PRESENCE = "DELETE FROM ofPresence WHERE username=?";
    private static final String NULL_STRING = "NULL";
    private static final long NULL_LONG = -1L;
    private RoutingTable routingTable;
    private SessionManager sessionManager;
    private UserManager userManager;
    private RosterManager rosterManager;
    private XMPPServer server;
    private PacketDeliverer deliverer;
    private PresenceUpdateHandler presenceUpdateHandler;
    private InternalComponentManager componentManager;
    private Cache<String, Long> lastActivityCache;
    private Cache<String, String> offlinePresenceCache;

    public PresenceManagerImpl() {
        super("Presence manager");
    }

    @Override
    public boolean isAvailable(User user) {
        return this.sessionManager.getActiveSessionCount(user.getUsername()) > 0;
    }

    @Override
    public Presence getPresence(User user) {
        if (user == null) {
            return null;
        }
        Presence presence = null;
        for (ClientSession session : this.sessionManager.getSessions(user.getUsername())) {
            int o2;
            if (presence == null) {
                presence = session.getPresence();
                continue;
            }
            int o1 = presence.getShow() != null ? presence.getShow().ordinal() : -1;
            if (o1 <= (o2 = session.getPresence().getShow() != null ? session.getPresence().getShow().ordinal() : -1)) continue;
            presence = session.getPresence();
        }
        return presence;
    }

    @Override
    public Collection<Presence> getPresences(String username) {
        if (username == null) {
            return null;
        }
        ArrayList<Presence> presences = new ArrayList<Presence>();
        for (ClientSession session : this.sessionManager.getSessions(username)) {
            presences.add(session.getPresence());
        }
        return Collections.unmodifiableCollection(presences);
    }

    @Override
    public String getLastPresenceStatus(User user) {
        String username = user.getUsername();
        String presenceStatus = null;
        String presenceXML = (String)this.offlinePresenceCache.get(username);
        if (presenceXML == null) {
            this.loadOfflinePresence(username);
        }
        if ((presenceXML = (String)this.offlinePresenceCache.get(username)) != null) {
            if (presenceXML.equals(NULL_STRING)) {
                return null;
            }
            try {
                Document element = DocumentHelper.parseText((String)presenceXML);
                presenceStatus = element.getRootElement().elementTextTrim("status");
            }
            catch (DocumentException e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
        }
        return presenceStatus;
    }

    @Override
    public long getLastActivity(User user) {
        String username = user.getUsername();
        long lastActivity = -1L;
        Long offlineDate = (Long)this.lastActivityCache.get(username);
        if (offlineDate == null) {
            this.loadOfflinePresence(username);
        }
        if ((offlineDate = (Long)this.lastActivityCache.get(username)) != null) {
            if (offlineDate == -1L) {
                return -1L;
            }
            try {
                lastActivity = System.currentTimeMillis() - offlineDate;
            }
            catch (NumberFormatException e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
        }
        return lastActivity;
    }

    @Override
    public void userAvailable(Presence presence) {
        if (presence.getTo() == null && this.server.isLocal(presence.getFrom())) {
            String username = presence.getFrom().getNode();
            if (username == null || !this.userManager.isRegisteredUser(username)) {
                return;
            }
            if (this.sessionManager.getSessionCount(username) > 1) {
                return;
            }
            this.deleteOfflinePresenceFromDB(username);
            this.offlinePresenceCache.remove(username);
            this.lastActivityCache.remove(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOfflinePresenceFromDB(String username) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_OFFLINE_PRESENCE);
            pstmt.setString(1, username);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public void userUnavailable(Presence presence) {
        if (presence.getTo() == null && this.server.isLocal(presence.getFrom())) {
            boolean addedToCache;
            String username = presence.getFrom().getNode();
            if (username == null || !this.userManager.isRegisteredUser(username)) {
                return;
            }
            if (this.sessionManager.getActiveSessionCount(username) > 0) {
                return;
            }
            String offlinePresence = null;
            if (!presence.getElement().elements().isEmpty()) {
                offlinePresence = presence.toXML();
            }
            Date offlinePresenceDate = new Date();
            if (offlinePresence == null) {
                addedToCache = !NULL_STRING.equals(this.offlinePresenceCache.put(username, NULL_STRING));
            } else {
                boolean bl = addedToCache = !offlinePresence.equals(this.offlinePresenceCache.put(username, offlinePresence));
            }
            if (!addedToCache) {
                return;
            }
            this.lastActivityCache.put(username, offlinePresenceDate.getTime());
            this.writeToDatabase(username, offlinePresence, offlinePresenceDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDatabase(String username, String offlinePresence, Date offlinePresenceDate) {
        this.deleteOfflinePresenceFromDB(username);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_OFFLINE_PRESENCE);
            pstmt.setString(1, username);
            if (offlinePresence != null) {
                DbConnectionManager.setLargeTextField(pstmt, 2, offlinePresence);
            } else {
                pstmt.setNull(2, 12);
            }
            pstmt.setString(3, StringUtils.dateToMillis(offlinePresenceDate));
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                Log.error("Error storing offline presence of user: " + username, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public void handleProbe(Presence packet) throws UnauthorizedException {
        String username = packet.getTo().getNode();
        try {
            Roster roster = this.rosterManager.getRoster(username);
            RosterItem item = roster.getRosterItem(packet.getFrom());
            if (item.getSubStatus() == RosterItem.SUB_FROM || item.getSubStatus() == RosterItem.SUB_BOTH) {
                this.probePresence(packet.getFrom(), packet.getTo());
            } else {
                PacketError.Condition error = PacketError.Condition.not_authorized;
                if (item.getSubStatus() == RosterItem.SUB_NONE && item.getRecvStatus() != RosterItem.RECV_SUBSCRIBE || item.getSubStatus() == RosterItem.SUB_TO && item.getRecvStatus() != RosterItem.RECV_SUBSCRIBE) {
                    error = PacketError.Condition.forbidden;
                }
                Presence presenceToSend = new Presence();
                presenceToSend.setError(error);
                presenceToSend.setTo(packet.getFrom());
                presenceToSend.setFrom(packet.getTo());
                this.deliverer.deliver((Packet)presenceToSend);
            }
        }
        catch (UserNotFoundException e) {
            Presence presenceToSend = new Presence();
            presenceToSend.setError(PacketError.Condition.forbidden);
            presenceToSend.setTo(packet.getFrom());
            presenceToSend.setFrom(packet.getTo());
            this.deliverer.deliver((Packet)presenceToSend);
        }
    }

    @Override
    public boolean canProbePresence(JID prober, String probee) throws UserNotFoundException {
        if (probee.equals(prober.getNode()) && XMPPServer.getInstance().isLocal(prober)) {
            return true;
        }
        RosterItem item = this.rosterManager.getRoster(probee).getRosterItem(prober);
        return item.getSubStatus() == RosterItem.SUB_FROM || item.getSubStatus() == RosterItem.SUB_BOTH;
    }

    @Override
    public void probePresence(JID prober, JID probee) {
        block19: {
            try {
                if (this.server.isLocal(probee)) {
                    ArrayList<JID> proberFullJIDs = new ArrayList<JID>();
                    if (prober.getResource() == null && this.server.isLocal(prober)) {
                        for (ClientSession session : this.sessionManager.getSessions(prober.getNode())) {
                            proberFullJIDs.add(session.getAddress());
                        }
                    } else {
                        proberFullJIDs.add(prober);
                    }
                    Collection<ClientSession> sessions = this.sessionManager.getSessions(probee.getNode());
                    if (sessions.isEmpty()) {
                        String presenceXML = (String)this.offlinePresenceCache.get(probee.getNode());
                        if (presenceXML == null) {
                            this.loadOfflinePresence(probee.getNode());
                        }
                        if ((presenceXML = (String)this.offlinePresenceCache.get(probee.getNode())) == null || NULL_STRING.equals(presenceXML)) break block19;
                        try {
                            Document element = DocumentHelper.parseText((String)presenceXML);
                            Presence presencePacket = new Presence(element.getRootElement());
                            presencePacket.setFrom(probee.toBareJID());
                            PrivacyList list = PrivacyListManager.getInstance().getDefaultPrivacyList(probee.getNode());
                            for (JID receipient : proberFullJIDs) {
                                presencePacket.setTo(receipient);
                                if (list != null && list.shouldBlockPacket((Packet)presencePacket)) continue;
                                this.deliverer.deliver((Packet)presencePacket);
                            }
                            break block19;
                        }
                        catch (Exception e) {
                            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                            break block19;
                        }
                    }
                    for (ClientSession session : sessions) {
                        Presence presencePacket = session.getPresence().createCopy();
                        presencePacket.setFrom(session.getAddress());
                        PrivacyList list = session.getActiveList();
                        list = list == null ? session.getDefaultList() : list;
                        for (JID receipient : proberFullJIDs) {
                            presencePacket.setTo(receipient);
                            if (list != null && list.shouldBlockPacket((Packet)presencePacket)) continue;
                            try {
                                this.deliverer.deliver((Packet)presencePacket);
                            }
                            catch (Exception e) {
                                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                            }
                        }
                    }
                    break block19;
                }
                if (this.routingTable.hasComponentRoute(probee)) {
                    Presence presence = new Presence();
                    presence.setType(Presence.Type.probe);
                    presence.setFrom(prober);
                    presence.setTo(probee);
                    this.routingTable.routePacket(probee, (Packet)presence, true);
                } else if (this.server.isRemote(probee)) {
                    Presence probePresence = new Presence();
                    probePresence.setType(Presence.Type.probe);
                    probePresence.setFrom(prober);
                    probePresence.setTo(probee.toBareJID());
                    this.deliverer.deliver((Packet)probePresence);
                } else {
                    this.componentManager.addPresenceRequest(prober, probee);
                }
            }
            catch (Exception e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
        }
    }

    @Override
    public void sendUnavailableFromSessions(JID recipientJID, JID userJID) {
        if (XMPPServer.getInstance().isLocal(userJID) && this.userManager.isRegisteredUser(userJID.getNode())) {
            for (ClientSession session : this.sessionManager.getSessions(userJID.getNode())) {
                if (this.presenceUpdateHandler.hasDirectPresence(session.getAddress(), recipientJID)) continue;
                Presence presencePacket = new Presence();
                presencePacket.setType(Presence.Type.unavailable);
                presencePacket.setFrom(session.getAddress());
                ArrayList<JID> recipientFullJIDs = new ArrayList<JID>();
                if (this.server.isLocal(recipientJID)) {
                    for (ClientSession targetSession : this.sessionManager.getSessions(recipientJID.getNode())) {
                        recipientFullJIDs.add(targetSession.getAddress());
                    }
                } else {
                    recipientFullJIDs.add(recipientJID);
                }
                for (JID jid : recipientFullJIDs) {
                    presencePacket.setTo(jid);
                    try {
                        this.deliverer.deliver((Packet)presencePacket);
                    }
                    catch (Exception e) {
                        Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void userCreated(User user, Map<String, Object> params) {
    }

    @Override
    public void userDeleting(User user, Map<String, Object> params) {
        this.deleteOfflinePresenceFromDB(user.getUsername());
    }

    @Override
    public void userModified(User user, Map<String, Object> params) {
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.server = server;
        this.offlinePresenceCache = CacheFactory.createCache("Offline Presence Cache");
        this.lastActivityCache = CacheFactory.createCache("Last Activity Cache");
        this.deliverer = server.getPacketDeliverer();
        this.sessionManager = server.getSessionManager();
        this.userManager = server.getUserManager();
        this.presenceUpdateHandler = server.getPresenceUpdateHandler();
        this.rosterManager = server.getRosterManager();
        this.routingTable = server.getRoutingTable();
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        this.componentManager = InternalComponentManager.getInstance();
        UserEventDispatcher.addListener(this);
    }

    @Override
    public void stop() {
        this.offlinePresenceCache.clear();
        this.lastActivityCache.clear();
        UserEventDispatcher.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOfflinePresence(String username) {
        Lock lock;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block6: {
            con = null;
            pstmt = null;
            rs = null;
            lock = CacheFactory.getLock(username, this.offlinePresenceCache);
            try {
                lock.lock();
                if (this.offlinePresenceCache.containsKey(username) && this.lastActivityCache.containsKey(username)) break block6;
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_OFFLINE_PRESENCE);
                pstmt.setString(1, username);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String offlinePresence = DbConnectionManager.getLargeTextField(rs, 1);
                    if (rs.wasNull()) {
                        offlinePresence = NULL_STRING;
                    }
                    long offlineDate = Long.parseLong(rs.getString(2).trim());
                    this.offlinePresenceCache.put(username, offlinePresence);
                    this.lastActivityCache.put(username, offlineDate);
                    break block6;
                }
                this.offlinePresenceCache.put(username, NULL_STRING);
                this.lastActivityCache.put(username, -1L);
            }
            catch (SQLException sqle) {
                try {
                    Log.error(sqle.getMessage(), (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    lock.unlock();
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
                lock.unlock();
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        lock.unlock();
    }

    @Override
    public void serverStarted() {
    }

    @Override
    public void serverStopping() {
        for (ClientSession session : XMPPServer.getInstance().getSessionManager().getSessions()) {
            if (session.isAnonymousUser()) continue;
            try {
                this.writeToDatabase(session.getUsername(), null, new Date());
            }
            catch (UserNotFoundException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

