/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Set;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.keystore.CertificateStoreConfiguration;
import org.jivesoftware.openfire.keystore.CertificateStoreManager;
import org.jivesoftware.openfire.keystore.IdentityStore;
import org.jivesoftware.openfire.keystore.TrustStore;
import org.jivesoftware.openfire.spi.ConnectionType;

public class ConnectionConfiguration {
    private final boolean enabled;
    private final ConnectionType type;
    private final int maxThreadPoolSize;
    private final int maxBufferSize;
    private final Connection.ClientAuth clientAuth;
    private final InetAddress bindAddress;
    private final int port;
    private final Connection.TLSPolicy tlsPolicy;
    private final CertificateStoreConfiguration identityStoreConfiguration;
    private final CertificateStoreConfiguration trustStoreConfiguration;
    private final boolean acceptSelfSignedCertificates;
    private final boolean verifyCertificateValidity;
    private final Set<String> encryptionProtocols;
    private final Set<String> encryptionCipherSuites;
    private final Connection.CompressionPolicy compressionPolicy;
    private final IdentityStore identityStore;
    private final TrustStore trustStore;

    public ConnectionConfiguration(ConnectionType type, boolean enabled, int maxThreadPoolSize, int maxBufferSize, Connection.ClientAuth clientAuth, InetAddress bindAddress, int port, Connection.TLSPolicy tlsPolicy, CertificateStoreConfiguration identityStoreConfiguration, CertificateStoreConfiguration trustStoreConfiguration, boolean acceptSelfSignedCertificates, boolean verifyCertificateValidity, Set<String> encryptionProtocols, Set<String> encryptionCipherSuites, Connection.CompressionPolicy compressionPolicy) {
        if (maxThreadPoolSize <= 0) {
            throw new IllegalArgumentException("Argument 'maxThreadPoolSize' must be equal to or greater than one.");
        }
        if (clientAuth == null) {
            throw new IllegalArgumentException("Argument 'clientAuth' cannot be null.");
        }
        this.enabled = enabled;
        this.tlsPolicy = tlsPolicy;
        this.type = type;
        this.maxThreadPoolSize = maxThreadPoolSize;
        this.maxBufferSize = maxBufferSize;
        this.clientAuth = clientAuth;
        this.bindAddress = bindAddress;
        this.port = port;
        this.identityStoreConfiguration = identityStoreConfiguration;
        this.trustStoreConfiguration = trustStoreConfiguration;
        this.acceptSelfSignedCertificates = acceptSelfSignedCertificates;
        this.verifyCertificateValidity = verifyCertificateValidity;
        this.encryptionProtocols = Collections.unmodifiableSet(encryptionProtocols);
        this.encryptionCipherSuites = Collections.unmodifiableSet(encryptionCipherSuites);
        this.compressionPolicy = compressionPolicy;
        CertificateStoreManager certificateStoreManager = XMPPServer.getInstance().getCertificateStoreManager();
        this.identityStore = certificateStoreManager.getIdentityStore(type);
        this.trustStore = certificateStoreManager.getTrustStore(type);
    }

    public Connection.TLSPolicy getTlsPolicy() {
        return this.tlsPolicy;
    }

    public Connection.CompressionPolicy getCompressionPolicy() {
        return this.compressionPolicy;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public Connection.ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public CertificateStoreConfiguration getIdentityStoreConfiguration() {
        return this.identityStoreConfiguration;
    }

    public CertificateStoreConfiguration getTrustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public boolean isAcceptSelfSignedCertificates() {
        return this.acceptSelfSignedCertificates;
    }

    public boolean isVerifyCertificateValidity() {
        return this.verifyCertificateValidity;
    }

    public Set<String> getEncryptionProtocols() {
        return this.encryptionProtocols;
    }

    public Set<String> getEncryptionCipherSuites() {
        return this.encryptionCipherSuites;
    }

    public IdentityStore getIdentityStore() {
        return this.identityStore;
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

