/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.session;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.net.SocketConnection;
import org.jivesoftware.openfire.server.ServerDialback;
import org.jivesoftware.openfire.session.IncomingServerSession;
import org.jivesoftware.openfire.session.LocalServerSession;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.CertificateManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class LocalIncomingServerSession
extends LocalServerSession
implements IncomingServerSession {
    private static final Logger Log = LoggerFactory.getLogger(LocalIncomingServerSession.class);
    private Set<String> validatedDomains = new HashSet<String>();
    private String localDomain = null;
    private String fromDomain = null;

    public static LocalIncomingServerSession createSession(String serverName, XMPPPacketReader reader, SocketConnection connection) throws XmlPullParserException, IOException {
        int[] nArray;
        MXParser xpp = reader.getXPPParser();
        String version = xpp.getAttributeValue("", "version");
        String fromDomain = xpp.getAttributeValue("", "from");
        String toDomain = xpp.getAttributeValue("", "to");
        if (version != null) {
            nArray = LocalIncomingServerSession.decodeVersion(version);
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 0;
        }
        int[] serverVersion = nArray;
        if (toDomain == null) {
            toDomain = serverName;
        }
        try {
            StreamID streamID = SessionManager.getInstance().nextStreamID();
            LocalIncomingServerSession session = SessionManager.getInstance().createIncomingServerSession(connection, streamID, fromDomain);
            StringBuilder openingStream = new StringBuilder();
            openingStream.append("<stream:stream");
            openingStream.append(" xmlns:db=\"jabber:server:dialback\"");
            openingStream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
            openingStream.append(" xmlns=\"jabber:server\"");
            openingStream.append(" from=\"").append(toDomain).append("\"");
            if (fromDomain != null) {
                openingStream.append(" to=\"").append(fromDomain).append("\"");
            }
            openingStream.append(" id=\"").append(streamID).append("\"");
            if (serverVersion[0] >= 1) {
                openingStream.append(" version=\"1.0\">");
            } else {
                openingStream.append('>');
            }
            connection.deliverRawText(openingStream.toString());
            if (serverVersion[0] >= 1) {
                Connection.TLSPolicy tlsPolicy = connection.getTlsPolicy();
                boolean hasCertificates = false;
                try {
                    hasCertificates = XMPPServer.getInstance().getCertificateStoreManager().getIdentityStore(ConnectionType.SOCKET_S2S).getStore().size() > 0;
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                if (Connection.TLSPolicy.required == tlsPolicy && !hasCertificates) {
                    Log.error("Server session rejected. TLS is required but no certificates were created.");
                    return null;
                }
                connection.setTlsPolicy(hasCertificates ? tlsPolicy : Connection.TLSPolicy.disabled);
            }
            connection.setCompressionPolicy(connection.getConfiguration().getCompressionPolicy());
            StringBuilder sb = new StringBuilder();
            if (serverVersion[0] >= 1) {
                sb.append("<stream:features>");
                if (JiveGlobals.getBooleanProperty("xmpp.server.tls.enabled", true)) {
                    sb.append("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\">");
                    if (!ServerDialback.isEnabled()) {
                        sb.append("<required/>");
                    }
                    sb.append("</starttls>");
                }
                sb.append(SASLAuthentication.getSASLMechanisms(session));
                if (ServerDialback.isEnabled()) {
                    sb.append("<dialback xmlns=\"urn:xmpp:features:dialback\"><errors/></dialback>");
                }
                sb.append("</stream:features>");
            }
            connection.deliverRawText(sb.toString());
            session.setLocalDomain(serverName);
            return session;
        }
        catch (Exception e) {
            Log.error("Error establishing connection from remote server:" + connection, (Throwable)e);
            connection.close();
            return null;
        }
    }

    public LocalIncomingServerSession(String serverName, Connection connection, StreamID streamID, String fromDomain) {
        super(serverName, connection, streamID);
        this.fromDomain = fromDomain;
    }

    public String getDefaultIdentity() {
        return this.fromDomain;
    }

    @Override
    boolean canProcess(Packet packet) {
        return true;
    }

    @Override
    void deliver(Packet packet) throws UnauthorizedException {
    }

    public boolean validateSubsequentDomain(Element dbResult) {
        ServerDialback method = new ServerDialback(this.getConnection(), this.getServerName());
        if (method.validateRemoteDomain(dbResult, this.getStreamID())) {
            this.addValidatedDomain(dbResult.attributeValue("from"));
            return true;
        }
        return false;
    }

    public boolean isValidDomain(String domain) {
        for (String validatedDomain : this.getValidatedDomains()) {
            if (!domain.equals(validatedDomain)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getValidatedDomains() {
        return Collections.unmodifiableCollection(this.validatedDomains);
    }

    public void addValidatedDomain(String domain) {
        if (this.validatedDomains.add(domain)) {
            if (this.validatedDomains.size() < 2) {
                this.setAddress(new JID(null, domain, null));
            }
            SessionManager.getInstance().registerIncomingServerSession(domain, this);
        }
    }

    public void removeValidatedDomain(String domain) {
        this.validatedDomains.remove(domain);
        SessionManager.getInstance().unregisterIncomingServerSession(domain, this);
    }

    @Override
    public String getLocalDomain() {
        return this.localDomain;
    }

    public void setLocalDomain(String domain) {
        this.localDomain = domain;
    }

    public void verifyReceivedKey(Element doc) {
        ServerDialback.verifyReceivedKey(doc, this.getConnection());
    }

    @Override
    public String getAvailableStreamFeatures() {
        Certificate[] chain;
        boolean usingSelfSigned;
        StringBuilder sb = new StringBuilder();
        if (this.conn.getCompressionPolicy() != Connection.CompressionPolicy.disabled && !this.conn.isCompressed()) {
            sb.append("<compression xmlns=\"http://jabber.org/features/compress\"><method>zlib</method></compression>");
        }
        if ((usingSelfSigned = (chain = this.conn.getLocalCertificates()) == null || chain.length == 0 ? true : CertificateManager.isSelfSignedCertificate((X509Certificate)chain[0])) && ServerDialback.isEnabledForSelfSigned() && this.validatedDomains.isEmpty()) {
            sb.append("<dialback xmlns=\"urn:xmpp:features:dialback\"><errors/></dialback>");
        }
        return sb.toString();
    }

    public void tlsAuth() {
        this.usingServerDialback = false;
    }
}

