/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.security;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.database.SequenceManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.security.EventNotFoundException;
import org.jivesoftware.openfire.security.SecurityAuditEvent;
import org.jivesoftware.openfire.security.SecurityAuditProvider;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityAuditProvider
implements SecurityAuditProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultSecurityAuditProvider.class);
    private static final String LOG_ENTRY = "INSERT INTO ofSecurityAuditLog(msgID,username,entryStamp,summary,node,details) VALUES(?,?,?,?,?,?)";
    private static final String GET_EVENTS = "SELECT msgID,username,entryStamp,summary,node,details FROM ofSecurityAuditLog";
    private static final String GET_EVENT = "SELECT msgID,username,entryStamp,summary,node,details FROM ofSecurityAuditLog WHERE msgID=?";
    private static final String GET_EVENT_COUNT = "SELECT COUNT(msgID) FROM ofSecurityAuditLog";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logEvent(String username, String summary, String details) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            long msgID = SequenceManager.nextID(25);
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOG_ENTRY);
            pstmt.setLong(1, msgID);
            pstmt.setString(2, username);
            pstmt.setLong(3, new Date().getTime());
            pstmt.setString(4, StringUtils.abbreviate(summary, 250));
            pstmt.setString(5, XMPPServer.getInstance().getServerInfo().getHostname());
            pstmt.setString(6, details);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.warn("Error trying to insert a new row in ofSecurityAuditLog: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SecurityAuditEvent> getEvents(String username, Integer skipEvents, Integer numEvents, Date startTime, Date endTime) {
        ArrayList<SecurityAuditEvent> events = new ArrayList<SecurityAuditEvent>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = GET_EVENTS;
        boolean addedOne = false;
        if (username != null) {
            sql = sql + " WHERE username = ?";
            addedOne = true;
        }
        if (startTime != null) {
            sql = !addedOne ? sql + " WHERE" : sql + " AND";
            sql = sql + " entryStamp >= ?";
            addedOne = true;
        }
        if (endTime != null) {
            sql = !addedOne ? sql + " WHERE" : sql + " AND";
            sql = sql + " entryStamp <= ?";
        }
        sql = sql + " ORDER BY entryStamp DESC";
        try {
            con = DbConnectionManager.getConnection();
            pstmt = DbConnectionManager.createScrollablePreparedStatement(con, sql);
            int i = 1;
            if (username != null) {
                pstmt.setString(i, username);
                ++i;
            }
            if (startTime != null) {
                pstmt.setLong(i, startTime.getTime());
                ++i;
            }
            if (endTime != null) {
                pstmt.setLong(i, endTime.getTime());
            }
            rs = pstmt.executeQuery();
            if (skipEvents != null) {
                DbConnectionManager.scrollResultSet(rs, skipEvents);
            }
            if (numEvents != null) {
                DbConnectionManager.setFetchSize(rs, (int)numEvents);
            }
            for (int count = 0; rs.next() && count < numEvents; ++count) {
                SecurityAuditEvent event = new SecurityAuditEvent();
                event.setMsgID(rs.getLong(1));
                event.setUsername(rs.getString(2));
                event.setEventStamp(new Date(rs.getLong(3)));
                event.setSummary(rs.getString(4));
                event.setNode(rs.getString(5));
                event.setDetails(rs.getString(6));
                events.add(event);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return events;
    }

    @Override
    public SecurityAuditEvent getEvent(Integer msgID) throws EventNotFoundException {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        SecurityAuditEvent event = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_EVENT);
            pstmt.setLong(1, msgID.intValue());
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new EventNotFoundException();
            }
            event = new SecurityAuditEvent();
            event.setMsgID(rs.getLong(1));
            event.setUsername(rs.getString(2));
            event.setEventStamp(new Date(rs.getLong(3)));
            event.setSummary(rs.getString(4));
            event.setNode(rs.getString(5));
            event.setDetails(rs.getString(6));
        }
        catch (Exception e) {
            try {
                throw new EventNotFoundException();
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getEventCount() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Integer cnt = 0;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_EVENT_COUNT);
            rs = pstmt.executeQuery();
            cnt = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                Log.error("Error while looking up number of security audit events: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return cnt;
    }

    @Override
    public boolean isWriteOnly() {
        return false;
    }

    @Override
    public String getAuditURL() {
        return null;
    }

    @Override
    public boolean blockUserEvents() {
        return false;
    }

    @Override
    public boolean blockGroupEvents() {
        return false;
    }
}

