/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.models;

import java.util.Collection;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public class RosterAccess
extends AccessModel {
    private static final Logger Log = LoggerFactory.getLogger(RosterAccess.class);

    RosterAccess() {
    }

    @Override
    public boolean canSubscribe(Node node, JID owner, JID subscriber) {
        if (node.isAdmin(owner)) {
            return true;
        }
        for (JID nodeOwner : node.getOwners()) {
            if (!nodeOwner.equals((Object)owner)) continue;
            return true;
        }
        XMPPServer server = XMPPServer.getInstance();
        if (server.isLocal(owner)) {
            GroupManager gMgr = GroupManager.getInstance();
            Collection<String> nodeGroups = node.getRosterGroupsAllowed();
            for (String groupName : nodeGroups) {
                try {
                    Group group = gMgr.getGroup(groupName);
                    if (!server.getRosterManager().isGroupVisible(group, owner)) continue;
                    return true;
                }
                catch (GroupNotFoundException groupNotFoundException) {
                }
            }
        } else {
            Log.warn("Node with access model Roster has a remote user as subscriber: " + node.getNodeID());
        }
        return false;
    }

    @Override
    public boolean canAccessItems(Node node, JID owner, JID subscriber) {
        return this.canSubscribe(node, owner, subscriber);
    }

    @Override
    public String getName() {
        return "roster";
    }

    @Override
    public PacketError.Condition getSubsriptionError() {
        return PacketError.Condition.not_authorized;
    }

    @Override
    public Element getSubsriptionErrorDetail() {
        return DocumentHelper.createElement((QName)QName.get((String)"not-in-roster-group", (String)"http://jabber.org/protocol/pubsub#errors"));
    }

    @Override
    public boolean isAuthorizationRequired() {
        return false;
    }
}

