/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;

public abstract class NodeChangeTask
implements ClusterTask<Void> {
    private String nodeId;
    private transient Node node;

    public NodeChangeTask() {
    }

    public NodeChangeTask(String nodeIdent) {
        this.nodeId = nodeIdent;
    }

    public NodeChangeTask(Node node) {
        this.node = node;
        this.nodeId = node.getNodeID();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.nodeId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = ExternalizableUtil.getInstance().readSafeUTF(in);
    }

    public Node getNode() {
        if (this.node == null) {
            this.node = XMPPServer.getInstance().getPubSubModule().getNode(this.nodeId);
        }
        return this.node;
    }

    public String getNodeId() {
        return this.nodeId;
    }
}

