/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.DefaultNodeConfiguration;
import org.jivesoftware.openfire.pubsub.LeafNode;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeAffiliate;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.openfire.pubsub.PublishedItem;
import org.jivesoftware.openfire.pubsub.cluster.FlushTask;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.jivesoftware.openfire.pubsub.models.PublisherModel;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LinkedList;
import org.jivesoftware.util.LinkedListNode;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.TaskEngine;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class PubSubPersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(PubSubPersistenceManager.class);
    private static final String PERSISTENT_NODES = "SELECT serviceID, nodeID, maxItems FROM ofPubsubNode WHERE leaf=1 AND persistItems=1 AND maxItems > 0";
    private static final String PURGE_FOR_SIZE = "DELETE FROM ofPubsubItem LEFT JOIN (SELECT id FROM ofPubsubItem WHERE serviceID=? AND nodeID=? ORDER BY creationDate DESC LIMIT ?) AS noDelete ON ofPubsubItem.id = noDelete.id WHERE noDelete.id IS NULL AND ofPubsubItem.serviceID = ? AND nodeID = ?";
    private static final String PURGE_FOR_SIZE_MYSQL = "DELETE ofPubsubItem FROM ofPubsubItem LEFT JOIN (SELECT id FROM ofPubsubItem WHERE serviceID=? AND nodeID=? ORDER BY creationDate DESC LIMIT ?) AS noDelete ON ofPubsubItem.id = noDelete.id WHERE noDelete.id IS NULL AND ofPubsubItem.serviceID = ? AND nodeID = ?";
    private static final String PURGE_FOR_SIZE_POSTGRESQL = "DELETE from ofPubsubItem where id in (select ofPubsubItem.id FROM ofPubsubItem LEFT JOIN (SELECT id FROM ofPubsubItem WHERE serviceID=? AND nodeID=? ORDER BY creationDate DESC LIMIT ?) AS noDelete ON ofPubsubItem.id = noDelete.id WHERE noDelete.id IS NULL AND ofPubsubItem.serviceID = ? AND nodeID = ?)";
    private static final String PURGE_FOR_SIZE_HSQLDB = "DELETE FROM ofPubsubItem WHERE serviceID=? AND nodeID=? AND id NOT IN (SELECT id FROM ofPubsubItem WHERE serviceID=? AND nodeID=? ORDER BY creationDate DESC LIMIT ?)";
    private static final String LOAD_NODES = "SELECT nodeID, leaf, creationDate, modificationDate, parent, deliverPayloads, maxPayloadSize, persistItems, maxItems, notifyConfigChanges, notifyDelete, notifyRetract, presenceBased, sendItemSubscribe, publisherModel, subscriptionEnabled, configSubscription, accessModel, payloadType, bodyXSLT, dataformXSLT, creator, description, language, name, replyPolicy, associationPolicy, maxLeafNodes FROM ofPubsubNode WHERE serviceID=?";
    private static final String LOAD_NODE = "SELECT nodeID, leaf, creationDate, modificationDate, parent, deliverPayloads, maxPayloadSize, persistItems, maxItems, notifyConfigChanges, notifyDelete, notifyRetract, presenceBased, sendItemSubscribe, publisherModel, subscriptionEnabled, configSubscription, accessModel, payloadType, bodyXSLT, dataformXSLT, creator, description, language, name, replyPolicy, associationPolicy, maxLeafNodes FROM ofPubsubNode WHERE serviceID=? AND nodeID=?";
    private static final String UPDATE_NODE = "UPDATE ofPubsubNode SET modificationDate=?, parent=?, deliverPayloads=?, maxPayloadSize=?, persistItems=?, maxItems=?, notifyConfigChanges=?, notifyDelete=?, notifyRetract=?, presenceBased=?, sendItemSubscribe=?, publisherModel=?, subscriptionEnabled=?, configSubscription=?, accessModel=?, payloadType=?, bodyXSLT=?, dataformXSLT=?, description=?, language=?, name=?, replyPolicy=?, associationPolicy=?, maxLeafNodes=? WHERE serviceID=? AND nodeID=?";
    private static final String ADD_NODE = "INSERT INTO ofPubsubNode (serviceID, nodeID, leaf, creationDate, modificationDate, parent, deliverPayloads, maxPayloadSize, persistItems, maxItems, notifyConfigChanges, notifyDelete, notifyRetract, presenceBased, sendItemSubscribe, publisherModel, subscriptionEnabled, configSubscription, accessModel, payloadType, bodyXSLT, dataformXSLT, creator, description, language, name, replyPolicy, associationPolicy, maxLeafNodes) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_NODE = "DELETE FROM ofPubsubNode WHERE serviceID=? AND nodeID=?";
    private static final String LOAD_NODES_JIDS = "SELECT nodeID, jid, associationType FROM ofPubsubNodeJIDs WHERE serviceID=?";
    private static final String LOAD_NODE_JIDS = "SELECT nodeID, jid, associationType FROM ofPubsubNodeJIDs WHERE serviceID=? AND nodeID=?";
    private static final String ADD_NODE_JIDS = "INSERT INTO ofPubsubNodeJIDs (serviceID, nodeID, jid, associationType) VALUES (?,?,?,?)";
    private static final String DELETE_NODE_JIDS = "DELETE FROM ofPubsubNodeJIDs WHERE serviceID=? AND nodeID=?";
    private static final String LOAD_NODES_GROUPS = "SELECT nodeID, rosterGroup FROM ofPubsubNodeGroups WHERE serviceID=?";
    private static final String LOAD_NODE_GROUPS = "SELECT nodeID, rosterGroup FROM ofPubsubNodeGroups WHERE serviceID=? AND nodeID=?";
    private static final String ADD_NODE_GROUPS = "INSERT INTO ofPubsubNodeGroups (serviceID, nodeID, rosterGroup) VALUES (?,?,?)";
    private static final String DELETE_NODE_GROUPS = "DELETE FROM ofPubsubNodeGroups WHERE serviceID=? AND nodeID=?";
    private static final String LOAD_AFFILIATIONS = "SELECT nodeID,jid,affiliation FROM ofPubsubAffiliation WHERE serviceID=? ORDER BY nodeID";
    private static final String LOAD_NODE_AFFILIATIONS = "SELECT nodeID,jid,affiliation FROM ofPubsubAffiliation WHERE serviceID=? AND nodeID=?";
    private static final String ADD_AFFILIATION = "INSERT INTO ofPubsubAffiliation (serviceID,nodeID,jid,affiliation) VALUES (?,?,?,?)";
    private static final String UPDATE_AFFILIATION = "UPDATE ofPubsubAffiliation SET affiliation=? WHERE serviceID=? AND nodeID=? AND jid=?";
    private static final String DELETE_AFFILIATION = "DELETE FROM ofPubsubAffiliation WHERE serviceID=? AND nodeID=? AND jid=?";
    private static final String DELETE_AFFILIATIONS = "DELETE FROM ofPubsubAffiliation WHERE serviceID=? AND nodeID=?";
    private static final String LOAD_SUBSCRIPTIONS_BASE = "SELECT nodeID, id, jid, owner, state, deliver, digest, digest_frequency, expire, includeBody, showValues, subscriptionType, subscriptionDepth, keyword FROM ofPubsubSubscription WHERE serviceID=? ";
    private static final String LOAD_NODE_SUBSCRIPTION = "SELECT nodeID, id, jid, owner, state, deliver, digest, digest_frequency, expire, includeBody, showValues, subscriptionType, subscriptionDepth, keyword FROM ofPubsubSubscription WHERE serviceID=? AND nodeID=? AND id=?";
    private static final String LOAD_NODE_SUBSCRIPTIONS = "SELECT nodeID, id, jid, owner, state, deliver, digest, digest_frequency, expire, includeBody, showValues, subscriptionType, subscriptionDepth, keyword FROM ofPubsubSubscription WHERE serviceID=? AND nodeID=?";
    private static final String LOAD_SUBSCRIPTIONS = "SELECT nodeID, id, jid, owner, state, deliver, digest, digest_frequency, expire, includeBody, showValues, subscriptionType, subscriptionDepth, keyword FROM ofPubsubSubscription WHERE serviceID=? ORDER BY nodeID";
    private static final String ADD_SUBSCRIPTION = "INSERT INTO ofPubsubSubscription (serviceID, nodeID, id, jid, owner, state, deliver, digest, digest_frequency, expire, includeBody, showValues, subscriptionType, subscriptionDepth, keyword) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_SUBSCRIPTION = "UPDATE ofPubsubSubscription SET owner=?, state=?, deliver=?, digest=?, digest_frequency=?, expire=?, includeBody=?, showValues=?, subscriptionType=?, subscriptionDepth=?, keyword=? WHERE serviceID=? AND nodeID=? AND id=?";
    private static final String DELETE_SUBSCRIPTION = "DELETE FROM ofPubsubSubscription WHERE serviceID=? AND nodeID=? AND id=?";
    private static final String DELETE_SUBSCRIPTIONS = "DELETE FROM ofPubsubSubscription WHERE serviceID=? AND nodeID=?";
    private static final String LOAD_ITEMS = "SELECT id,jid,creationDate,payload FROM ofPubsubItem WHERE serviceID=? AND nodeID=? ORDER BY creationDate DESC";
    private static final String LOAD_ITEM = "SELECT jid,creationDate,payload FROM ofPubsubItem WHERE serviceID=? AND nodeID=? AND id=?";
    private static final String LOAD_LAST_ITEM = "SELECT id,jid,creationDate,payload FROM ofPubsubItem WHERE serviceID=? AND nodeID=? ORDER BY creationDate DESC";
    private static final String ADD_ITEM = "INSERT INTO ofPubsubItem (serviceID,nodeID,id,jid,creationDate,payload) VALUES (?,?,?,?,?,?)";
    private static final String DELETE_ITEM = "DELETE FROM ofPubsubItem WHERE serviceID=? AND nodeID=? AND id=?";
    private static final String DELETE_ITEMS = "DELETE FROM ofPubsubItem WHERE serviceID=? AND nodeID=?";
    private static final String LOAD_DEFAULT_CONF = "SELECT deliverPayloads, maxPayloadSize, persistItems, maxItems, notifyConfigChanges, notifyDelete, notifyRetract, presenceBased, sendItemSubscribe, publisherModel, subscriptionEnabled, accessModel, language, replyPolicy, associationPolicy, maxLeafNodes FROM ofPubsubDefaultConf WHERE serviceID=? AND leaf=?";
    private static final String UPDATE_DEFAULT_CONF = "UPDATE ofPubsubDefaultConf SET deliverPayloads=?, maxPayloadSize=?, persistItems=?, maxItems=?, notifyConfigChanges=?, notifyDelete=?, notifyRetract=?, presenceBased=?, sendItemSubscribe=?, publisherModel=?, subscriptionEnabled=?, accessModel=?, language=?, replyPolicy=?, associationPolicy=?, maxLeafNodes=? WHERE serviceID=? AND leaf=?";
    private static final String ADD_DEFAULT_CONF = "INSERT INTO ofPubsubDefaultConf (serviceID, leaf, deliverPayloads, maxPayloadSize, persistItems, maxItems, notifyConfigChanges, notifyDelete, notifyRetract, presenceBased, sendItemSubscribe, publisherModel, subscriptionEnabled, accessModel, language, replyPolicy, associationPolicy, maxLeafNodes) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static Random prng = new Random();
    private static long flushTimerDelay = Math.max(20000, JiveGlobals.getIntProperty("xmpp.pubsub.flush.timer", 120) * 1000);
    private static long purgeTimerDelay = Math.max(60000, JiveGlobals.getIntProperty("xmpp.pubsub.purge.timer", 300) * 1000);
    private static final int MAX_ITEMS_FLUSH = JiveGlobals.getIntProperty("xmpp.pubsub.flush.max", 1000);
    private static final int MAX_ROWS_FETCH = JiveGlobals.getIntProperty("xmpp.pubsub.fetch.max", 2000);
    private static final int MAX_ITEM_RETRY = JiveGlobals.getIntProperty("xmpp.pubsub.item.retry", 1);
    private static LinkedList<RetryWrapper> itemsToAdd = new LinkedList();
    private static LinkedList<PublishedItem> itemsToDelete = new LinkedList();
    private static final HashMap<String, LinkedListNode<RetryWrapper>> itemsPending = new HashMap();
    private static final String ITEM_CACHE = "Published Items";
    private static final Cache<String, PublishedItem> itemCache = CacheFactory.createCache("Published Items");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNode(Node node) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = DbConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(ADD_NODE);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.setInt(3, node.isCollectionNode() ? 0 : 1);
            pstmt.setString(4, StringUtils.dateToMillis(node.getCreationDate()));
            pstmt.setString(5, StringUtils.dateToMillis(node.getModificationDate()));
            pstmt.setString(6, node.getParent() != null ? PubSubPersistenceManager.encodeNodeID(node.getParent().getNodeID()) : null);
            pstmt.setInt(7, node.isPayloadDelivered() ? 1 : 0);
            if (!node.isCollectionNode()) {
                pstmt.setInt(8, ((LeafNode)node).getMaxPayloadSize());
                pstmt.setInt(9, ((LeafNode)node).isPersistPublishedItems() ? 1 : 0);
                pstmt.setInt(10, ((LeafNode)node).getMaxPublishedItems());
            } else {
                pstmt.setInt(8, 0);
                pstmt.setInt(9, 0);
                pstmt.setInt(10, 0);
            }
            pstmt.setInt(11, node.isNotifiedOfConfigChanges() ? 1 : 0);
            pstmt.setInt(12, node.isNotifiedOfDelete() ? 1 : 0);
            pstmt.setInt(13, node.isNotifiedOfRetract() ? 1 : 0);
            pstmt.setInt(14, node.isPresenceBasedDelivery() ? 1 : 0);
            pstmt.setInt(15, node.isSendItemSubscribe() ? 1 : 0);
            pstmt.setString(16, node.getPublisherModel().getName());
            pstmt.setInt(17, node.isSubscriptionEnabled() ? 1 : 0);
            pstmt.setInt(18, node.isSubscriptionConfigurationRequired() ? 1 : 0);
            pstmt.setString(19, node.getAccessModel().getName());
            pstmt.setString(20, node.getPayloadType());
            pstmt.setString(21, node.getBodyXSLT());
            pstmt.setString(22, node.getDataformXSLT());
            pstmt.setString(23, node.getCreator().toString());
            pstmt.setString(24, node.getDescription());
            pstmt.setString(25, node.getLanguage());
            pstmt.setString(26, node.getName());
            if (node.getReplyPolicy() != null) {
                pstmt.setString(27, node.getReplyPolicy().name());
            } else {
                pstmt.setString(27, null);
            }
            if (node.isCollectionNode()) {
                pstmt.setString(28, ((CollectionNode)node).getAssociationPolicy().name());
                pstmt.setInt(29, ((CollectionNode)node).getMaxLeafNodes());
            } else {
                pstmt.setString(28, null);
                pstmt.setInt(29, 0);
            }
            pstmt.executeUpdate();
            PubSubPersistenceManager.saveAssociatedElements(con, node);
        }
        catch (SQLException sqle) {
            try {
                log.error(sqle.getMessage(), (Throwable)sqle);
                abortTransaction = true;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                throw throwable;
            }
            DbConnectionManager.closeStatement(pstmt);
            DbConnectionManager.closeTransactionConnection(con, abortTransaction);
        }
        DbConnectionManager.closeStatement(pstmt);
        DbConnectionManager.closeTransactionConnection(con, abortTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateNode(Node node) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = DbConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(UPDATE_NODE);
            pstmt.setString(1, StringUtils.dateToMillis(node.getModificationDate()));
            pstmt.setString(2, node.getParent() != null ? PubSubPersistenceManager.encodeNodeID(node.getParent().getNodeID()) : null);
            pstmt.setInt(3, node.isPayloadDelivered() ? 1 : 0);
            if (!node.isCollectionNode()) {
                pstmt.setInt(4, ((LeafNode)node).getMaxPayloadSize());
                pstmt.setInt(5, ((LeafNode)node).isPersistPublishedItems() ? 1 : 0);
                pstmt.setInt(6, ((LeafNode)node).getMaxPublishedItems());
            } else {
                pstmt.setInt(4, 0);
                pstmt.setInt(5, 0);
                pstmt.setInt(6, 0);
            }
            pstmt.setInt(7, node.isNotifiedOfConfigChanges() ? 1 : 0);
            pstmt.setInt(8, node.isNotifiedOfDelete() ? 1 : 0);
            pstmt.setInt(9, node.isNotifiedOfRetract() ? 1 : 0);
            pstmt.setInt(10, node.isPresenceBasedDelivery() ? 1 : 0);
            pstmt.setInt(11, node.isSendItemSubscribe() ? 1 : 0);
            pstmt.setString(12, node.getPublisherModel().getName());
            pstmt.setInt(13, node.isSubscriptionEnabled() ? 1 : 0);
            pstmt.setInt(14, node.isSubscriptionConfigurationRequired() ? 1 : 0);
            pstmt.setString(15, node.getAccessModel().getName());
            pstmt.setString(16, node.getPayloadType());
            pstmt.setString(17, node.getBodyXSLT());
            pstmt.setString(18, node.getDataformXSLT());
            pstmt.setString(19, node.getDescription());
            pstmt.setString(20, node.getLanguage());
            pstmt.setString(21, node.getName());
            if (node.getReplyPolicy() != null) {
                pstmt.setString(22, node.getReplyPolicy().name());
            } else {
                pstmt.setString(22, null);
            }
            if (node.isCollectionNode()) {
                pstmt.setString(23, ((CollectionNode)node).getAssociationPolicy().name());
                pstmt.setInt(24, ((CollectionNode)node).getMaxLeafNodes());
            } else {
                pstmt.setString(23, null);
                pstmt.setInt(24, 0);
            }
            pstmt.setString(25, node.getService().getServiceID());
            pstmt.setString(26, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_NODE_JIDS);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_NODE_GROUPS);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.executeUpdate();
            PubSubPersistenceManager.saveAssociatedElements(con, node);
        }
        catch (SQLException sqle) {
            try {
                log.error(sqle.getMessage(), (Throwable)sqle);
                abortTransaction = true;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                throw throwable;
            }
            DbConnectionManager.closeStatement(pstmt);
            DbConnectionManager.closeTransactionConnection(con, abortTransaction);
        }
        DbConnectionManager.closeStatement(pstmt);
        DbConnectionManager.closeTransactionConnection(con, abortTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveAssociatedElements(Connection con, Node node) throws SQLException {
        PreparedStatement pstmt = con.prepareStatement(ADD_NODE_JIDS);
        try {
            for (JID jid : node.getContacts()) {
                pstmt.setString(1, node.getService().getServiceID());
                pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                pstmt.setString(3, jid.toString());
                pstmt.setString(4, "contacts");
                pstmt.executeUpdate();
            }
            for (JID jid : node.getReplyRooms()) {
                pstmt.setString(1, node.getService().getServiceID());
                pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                pstmt.setString(3, jid.toString());
                pstmt.setString(4, "replyRooms");
                pstmt.executeUpdate();
            }
            for (JID jid : node.getReplyTo()) {
                pstmt.setString(1, node.getService().getServiceID());
                pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                pstmt.setString(3, jid.toString());
                pstmt.setString(4, "replyTo");
                pstmt.executeUpdate();
            }
            if (node.isCollectionNode()) {
                for (JID jid : ((CollectionNode)node).getAssociationTrusted()) {
                    pstmt.setString(1, node.getService().getServiceID());
                    pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                    pstmt.setString(3, jid.toString());
                    pstmt.setString(4, "associationTrusted");
                    pstmt.executeUpdate();
                }
            }
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(ADD_NODE_GROUPS);
            for (String groupName : node.getRosterGroupsAllowed()) {
                pstmt.setString(1, node.getService().getServiceID());
                pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                pstmt.setString(3, groupName);
                pstmt.executeUpdate();
            }
        }
        finally {
            DbConnectionManager.closeStatement(pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeNode(Node node) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = DbConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(DELETE_NODE);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_NODE_JIDS);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_NODE_GROUPS);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            if (node instanceof LeafNode) {
                PubSubPersistenceManager.purgeNode((LeafNode)node, con);
            }
            pstmt = con.prepareStatement(DELETE_AFFILIATIONS);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.executeUpdate();
            DbConnectionManager.fastcloseStmt(pstmt);
            pstmt = con.prepareStatement(DELETE_SUBSCRIPTIONS);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.error(sqle.getMessage(), (Throwable)sqle);
                abortTransaction = true;
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeStatement(pstmt);
                DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                throw throwable;
            }
            DbConnectionManager.closeStatement(pstmt);
            DbConnectionManager.closeTransactionConnection(con, abortTransaction);
        }
        DbConnectionManager.closeStatement(pstmt);
        DbConnectionManager.closeTransactionConnection(con, abortTransaction);
        return !abortTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNodes(PubSubService service) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_NODES);
            pstmt.setString(1, service.getServiceID());
            rs = pstmt.executeQuery();
            HashMap<String, String> parentMappings = new HashMap<String, String>();
            while (rs.next()) {
                PubSubPersistenceManager.loadNode(service, nodes, parentMappings, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            if (nodes.size() == 0) {
                log.info("No nodes found in pubsub");
                DbConnectionManager.closeConnection(rs, pstmt, con);
                return;
            }
            for (Map.Entry entry : parentMappings.entrySet()) {
                Node child = (Node)nodes.get(entry.getKey());
                CollectionNode parent = (CollectionNode)nodes.get(entry.getValue());
                if (parent == null) {
                    log.error("Could not find parent node " + (String)entry.getValue() + " for node " + (String)entry.getKey());
                    continue;
                }
                child.changeParent(parent);
            }
            pstmt = con.prepareStatement(LOAD_NODES_JIDS);
            pstmt.setString(1, service.getServiceID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PubSubPersistenceManager.loadAssociatedJIDs(nodes, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            pstmt = con.prepareStatement(LOAD_NODES_GROUPS);
            pstmt.setString(1, service.getServiceID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PubSubPersistenceManager.loadAssociatedGroups(nodes, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            pstmt = con.prepareStatement(LOAD_AFFILIATIONS);
            pstmt.setString(1, service.getServiceID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PubSubPersistenceManager.loadAffiliations(nodes, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            pstmt = con.prepareStatement(LOAD_SUBSCRIPTIONS);
            pstmt.setString(1, service.getServiceID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PubSubPersistenceManager.loadSubscriptions(service, nodes, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        for (Node node : nodes.values()) {
            node.setSavedToDB(true);
            service.addNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNode(PubSubService service, String nodeId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_NODE);
            pstmt.setString(1, service.getServiceID());
            pstmt.setString(2, nodeId);
            rs = pstmt.executeQuery();
            HashMap<String, String> parentMapping = new HashMap<String, String>();
            if (rs.next()) {
                PubSubPersistenceManager.loadNode(service, nodes, parentMapping, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            String parentId = (String)parentMapping.get(nodeId);
            if (parentId != null) {
                CollectionNode parent = (CollectionNode)service.getNode(parentId);
                if (parent == null) {
                    log.error("Could not find parent node " + parentId + " for node " + nodeId);
                } else {
                    ((Node)nodes.get(nodeId)).changeParent(parent);
                }
            }
            pstmt = con.prepareStatement(LOAD_NODE_JIDS);
            pstmt.setString(1, service.getServiceID());
            pstmt.setString(2, nodeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PubSubPersistenceManager.loadAssociatedJIDs(nodes, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            pstmt = con.prepareStatement(LOAD_NODE_GROUPS);
            pstmt.setString(1, service.getServiceID());
            pstmt.setString(2, nodeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PubSubPersistenceManager.loadAssociatedGroups(nodes, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            pstmt = con.prepareStatement(LOAD_NODE_AFFILIATIONS);
            pstmt.setString(1, service.getServiceID());
            pstmt.setString(2, nodeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PubSubPersistenceManager.loadAffiliations(nodes, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            pstmt = con.prepareStatement(LOAD_NODE_SUBSCRIPTIONS);
            pstmt.setString(1, service.getServiceID());
            pstmt.setString(2, nodeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PubSubPersistenceManager.loadSubscriptions(service, nodes, rs);
            }
            DbConnectionManager.fastcloseStmt(rs, pstmt);
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        for (Node node : nodes.values()) {
            node.setSavedToDB(true);
            service.addNode(node);
        }
    }

    private static void loadNode(PubSubService service, Map<String, Node> loadedNodes, Map<String, String> parentMappings, ResultSet rs) {
        try {
            String nodeID = PubSubPersistenceManager.decodeNodeID(rs.getString(1));
            boolean leaf = rs.getInt(2) == 1;
            String parent = PubSubPersistenceManager.decodeNodeID(rs.getString(5));
            JID creator = new JID(rs.getString(22));
            if (parent != null) {
                parentMappings.put(nodeID, parent);
            }
            Node node = leaf ? new LeafNode(service, null, nodeID, creator) : new CollectionNode(service, null, nodeID, creator);
            node.setCreationDate(new Date(Long.parseLong(rs.getString(3).trim())));
            node.setModificationDate(new Date(Long.parseLong(rs.getString(4).trim())));
            node.setPayloadDelivered(rs.getInt(6) == 1);
            if (leaf) {
                ((LeafNode)node).setMaxPayloadSize(rs.getInt(7));
                ((LeafNode)node).setPersistPublishedItems(rs.getInt(8) == 1);
                ((LeafNode)node).setMaxPublishedItems(rs.getInt(9));
                ((LeafNode)node).setSendItemSubscribe(rs.getInt(14) == 1);
            }
            node.setNotifiedOfConfigChanges(rs.getInt(10) == 1);
            node.setNotifiedOfDelete(rs.getInt(11) == 1);
            node.setNotifiedOfRetract(rs.getInt(12) == 1);
            node.setPresenceBasedDelivery(rs.getInt(13) == 1);
            node.setPublisherModel(PublisherModel.valueOf(rs.getString(15)));
            node.setSubscriptionEnabled(rs.getInt(16) == 1);
            node.setSubscriptionConfigurationRequired(rs.getInt(17) == 1);
            node.setAccessModel(AccessModel.valueOf(rs.getString(18)));
            node.setPayloadType(rs.getString(19));
            node.setBodyXSLT(rs.getString(20));
            node.setDataformXSLT(rs.getString(21));
            node.setDescription(rs.getString(23));
            node.setLanguage(rs.getString(24));
            node.setName(rs.getString(25));
            if (rs.getString(26) != null) {
                node.setReplyPolicy(Node.ItemReplyPolicy.valueOf(rs.getString(26)));
            }
            if (!leaf) {
                ((CollectionNode)node).setAssociationPolicy(CollectionNode.LeafNodeAssociationPolicy.valueOf(rs.getString(27)));
                ((CollectionNode)node).setMaxLeafNodes(rs.getInt(28));
            }
            loadedNodes.put(node.getNodeID(), node);
        }
        catch (SQLException sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
    }

    private static void loadAssociatedJIDs(Map<String, Node> nodes, ResultSet rs) {
        try {
            String nodeID = PubSubPersistenceManager.decodeNodeID(rs.getString(1));
            Node node = nodes.get(nodeID);
            if (node == null) {
                log.warn("JID associated to a non-existent node: " + nodeID);
                return;
            }
            JID jid = new JID(rs.getString(2));
            String associationType = rs.getString(3);
            if ("contacts".equals(associationType)) {
                node.addContact(jid);
            } else if ("replyRooms".equals(associationType)) {
                node.addReplyRoom(jid);
            } else if ("replyTo".equals(associationType)) {
                node.addReplyTo(jid);
            } else if ("associationTrusted".equals(associationType)) {
                ((CollectionNode)node).addAssociationTrusted(jid);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static void loadAssociatedGroups(Map<String, Node> nodes, ResultSet rs) {
        try {
            String nodeID = PubSubPersistenceManager.decodeNodeID(rs.getString(1));
            Node node = nodes.get(nodeID);
            if (node == null) {
                log.warn("Roster Group associated to a non-existent node: " + nodeID);
                return;
            }
            node.addAllowedRosterGroup(rs.getString(2));
        }
        catch (SQLException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static void loadAffiliations(Map<String, Node> nodes, ResultSet rs) {
        try {
            String nodeID = PubSubPersistenceManager.decodeNodeID(rs.getString(1));
            Node node = nodes.get(nodeID);
            if (node == null) {
                log.warn("Affiliations found for a non-existent node: " + nodeID);
                return;
            }
            NodeAffiliate affiliate = new NodeAffiliate(node, new JID(rs.getString(2)));
            affiliate.setAffiliation(NodeAffiliate.Affiliation.valueOf(rs.getString(3)));
            node.addAffiliate(affiliate);
        }
        catch (SQLException sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSubscription(PubSubService service, Node node, String subId) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        nodes.put(node.getNodeID(), node);
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_NODE_SUBSCRIPTION);
            pstmt.setString(1, service.getServiceID());
            pstmt.setString(2, node.getNodeID());
            pstmt.setString(3, subId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                PubSubPersistenceManager.loadSubscriptions(service, nodes, rs);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
    }

    private static void loadSubscriptions(PubSubService service, Map<String, Node> nodes, ResultSet rs) {
        try {
            String nodeID = PubSubPersistenceManager.decodeNodeID(rs.getString(1));
            Node node = nodes.get(nodeID);
            if (node == null) {
                log.warn("Subscription found for a non-existent node: " + nodeID);
                return;
            }
            String subID = rs.getString(2);
            JID subscriber = new JID(rs.getString(3));
            JID owner = new JID(rs.getString(4));
            if (node.getAffiliate(owner) == null) {
                log.warn("Subscription found for a non-existent affiliate: " + owner + " in node: " + nodeID);
                return;
            }
            NodeSubscription.State state = NodeSubscription.State.valueOf(rs.getString(5));
            NodeSubscription subscription = new NodeSubscription(node, owner, subscriber, state, subID);
            subscription.setShouldDeliverNotifications(rs.getInt(6) == 1);
            subscription.setUsingDigest(rs.getInt(7) == 1);
            subscription.setDigestFrequency(rs.getInt(8));
            if (rs.getString(9) != null) {
                subscription.setExpire(new Date(Long.parseLong(rs.getString(9).trim())));
            }
            subscription.setIncludingBody(rs.getInt(10) == 1);
            subscription.setPresenceStates(PubSubPersistenceManager.decodeWithComma(rs.getString(11)));
            subscription.setType(NodeSubscription.Type.valueOf(rs.getString(12)));
            subscription.setDepth(rs.getInt(13));
            subscription.setKeyword(rs.getString(14));
            subscription.setSavedToDB(true);
            node.addSubscription(subscription);
        }
        catch (SQLException sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAffiliation(Node node, NodeAffiliate affiliate, boolean create) {
        PreparedStatement pstmt;
        Connection con;
        block5: {
            con = null;
            pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                if (create) {
                    pstmt = con.prepareStatement(ADD_AFFILIATION);
                    pstmt.setString(1, node.getService().getServiceID());
                    pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                    pstmt.setString(3, affiliate.getJID().toString());
                    pstmt.setString(4, affiliate.getAffiliation().name());
                    pstmt.executeUpdate();
                    break block5;
                }
                pstmt = con.prepareStatement(UPDATE_AFFILIATION);
                pstmt.setString(1, affiliate.getAffiliation().name());
                pstmt.setString(2, node.getService().getServiceID());
                pstmt.setString(3, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                pstmt.setString(4, affiliate.getJID().toString());
                pstmt.executeUpdate();
            }
            catch (SQLException sqle) {
                try {
                    log.error(sqle.getMessage(), (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAffiliation(Node node, NodeAffiliate affiliate) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_AFFILIATION);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            pstmt.setString(3, affiliate.getJID().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSubscription(Node node, NodeSubscription subscription, boolean create) {
        PreparedStatement pstmt;
        Connection con;
        block10: {
            con = null;
            pstmt = null;
            try {
                con = DbConnectionManager.getConnection();
                if (create) {
                    pstmt = con.prepareStatement(ADD_SUBSCRIPTION);
                    pstmt.setString(1, node.getService().getServiceID());
                    pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                    pstmt.setString(3, subscription.getID());
                    pstmt.setString(4, subscription.getJID().toString());
                    pstmt.setString(5, subscription.getOwner().toString());
                    pstmt.setString(6, subscription.getState().name());
                    pstmt.setInt(7, subscription.shouldDeliverNotifications() ? 1 : 0);
                    pstmt.setInt(8, subscription.isUsingDigest() ? 1 : 0);
                    pstmt.setInt(9, subscription.getDigestFrequency());
                    Date expireDate = subscription.getExpire();
                    if (expireDate == null) {
                        pstmt.setString(10, null);
                    } else {
                        pstmt.setString(10, StringUtils.dateToMillis(expireDate));
                    }
                    pstmt.setInt(11, subscription.isIncludingBody() ? 1 : 0);
                    pstmt.setString(12, PubSubPersistenceManager.encodeWithComma(subscription.getPresenceStates()));
                    pstmt.setString(13, subscription.getType().name());
                    pstmt.setInt(14, subscription.getDepth());
                    pstmt.setString(15, subscription.getKeyword());
                    pstmt.executeUpdate();
                    subscription.setSavedToDB(true);
                    break block10;
                }
                if (NodeSubscription.State.none == subscription.getState()) {
                    pstmt = con.prepareStatement(DELETE_SUBSCRIPTION);
                    pstmt.setString(1, node.getService().getServiceID());
                    pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                    pstmt.setString(2, subscription.getID());
                    pstmt.executeUpdate();
                    break block10;
                }
                pstmt = con.prepareStatement(UPDATE_SUBSCRIPTION);
                pstmt.setString(1, subscription.getOwner().toString());
                pstmt.setString(2, subscription.getState().name());
                pstmt.setInt(3, subscription.shouldDeliverNotifications() ? 1 : 0);
                pstmt.setInt(4, subscription.isUsingDigest() ? 1 : 0);
                pstmt.setInt(5, subscription.getDigestFrequency());
                Date expireDate = subscription.getExpire();
                if (expireDate == null) {
                    pstmt.setString(6, null);
                } else {
                    pstmt.setString(6, StringUtils.dateToMillis(expireDate));
                }
                pstmt.setInt(7, subscription.isIncludingBody() ? 1 : 0);
                pstmt.setString(8, PubSubPersistenceManager.encodeWithComma(subscription.getPresenceStates()));
                pstmt.setString(9, subscription.getType().name());
                pstmt.setInt(10, subscription.getDepth());
                pstmt.setString(11, subscription.getKeyword());
                pstmt.setString(12, node.getService().getServiceID());
                pstmt.setString(13, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
                pstmt.setString(14, subscription.getID());
                pstmt.executeUpdate();
            }
            catch (SQLException sqle) {
                try {
                    log.error(sqle.getMessage(), (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSubscription(NodeSubscription subscription) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_SUBSCRIPTION);
            pstmt.setString(1, subscription.getNode().getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(subscription.getNode().getNodeID()));
            pstmt.setString(3, subscription.getID());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    public static void savePublishedItem(PublishedItem item) {
        PubSubPersistenceManager.savePublishedItem(new RetryWrapper(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePublishedItem(RetryWrapper wrapper) {
        boolean firstPass = wrapper.getRetryCount() == 0;
        PublishedItem item = wrapper.get();
        String itemKey = item.getItemKey();
        itemCache.put(itemKey, item);
        log.debug("Added new (inbound) item to cache");
        HashMap<String, LinkedListNode<RetryWrapper>> hashMap = itemsPending;
        synchronized (hashMap) {
            LinkedListNode<RetryWrapper> itemToReplace = itemsPending.remove(itemKey);
            if (itemToReplace != null) {
                itemToReplace.remove();
            }
            LinkedListNode<RetryWrapper> listNode = firstPass ? itemsToAdd.addLast(wrapper) : itemsToAdd.addFirst(wrapper);
            itemsPending.put(itemKey, listNode);
        }
        if (firstPass && itemsPending.size() > MAX_ITEMS_FLUSH) {
            TaskEngine.getInstance().submit(new Runnable(){

                @Override
                public void run() {
                    PubSubPersistenceManager.flushPendingItems(false);
                }
            });
        }
    }

    public static void flushPendingItems() {
        PubSubPersistenceManager.flushPendingItems(ClusterManager.isClusteringEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushPendingItems(boolean sendToCluster) {
        if (sendToCluster) {
            CacheFactory.doSynchronousClusterTask(new FlushTask(), false);
        }
        if (itemsToAdd.getFirst() == null && itemsToDelete.getFirst() == null) {
            return;
        }
        Connection con = null;
        boolean rollback = false;
        LinkedList<RetryWrapper> addList = null;
        LinkedList<PublishedItem> delList = null;
        HashMap<String, LinkedListNode<RetryWrapper>> hashMap = itemsPending;
        synchronized (hashMap) {
            addList = itemsToAdd;
            delList = itemsToDelete;
            itemsToAdd = new LinkedList();
            itemsToDelete = new LinkedList();
            int copied = 0;
            for (String key : itemsPending.keySet()) {
                if (itemCache.containsKey(key)) continue;
                itemCache.put(key, ((RetryWrapper)PubSubPersistenceManager.itemsPending.get((Object)key).object).get());
                ++copied;
            }
            if (log.isDebugEnabled() && copied > 0) {
                log.debug("Added " + copied + " pending items to published item cache");
            }
            itemsPending.clear();
        }
        try {
            con = DbConnectionManager.getTransactionConnection();
            PubSubPersistenceManager.writePendingItems(con, addList, delList);
        }
        catch (SQLException se) {
            log.error("Failed to flush pending items; initiating rollback", (Throwable)se);
            LinkedListNode<RetryWrapper> node = addList.getLast();
            while (node != null) {
                PubSubPersistenceManager.savePublishedItem((RetryWrapper)node.object);
                node.remove();
                node = addList.getLast();
            }
            rollback = true;
        }
        finally {
            DbConnectionManager.closeTransactionConnection(con, rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePendingItems(Connection con, LinkedList<RetryWrapper> addList, LinkedList<PublishedItem> delList) throws SQLException {
        LinkedListNode<RetryWrapper> addItem = addList.getFirst();
        LinkedListNode<PublishedItem> delItem = delList.getFirst();
        if (addItem == null && delItem == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Flush " + itemsPending.size() + " pending items to database");
        }
        if (addItem != null) {
            LinkedListNode addHead = addItem.previous;
            while (addItem != addHead) {
                delList.addLast(((RetryWrapper)addItem.object).get());
                addItem = addItem.next;
            }
        }
        if ((delItem = delList.getFirst()) != null) {
            PreparedStatement pstmt;
            block12: {
                pstmt = null;
                try {
                    LinkedListNode delHead = delItem.previous;
                    pstmt = con.prepareStatement(DELETE_ITEM);
                    Boolean hasBatchItems = false;
                    while (delItem != delHead) {
                        hasBatchItems = true;
                        PublishedItem item = (PublishedItem)delItem.object;
                        pstmt.setString(1, item.getNode().getService().getServiceID());
                        pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(item.getNode().getNodeID()));
                        pstmt.setString(3, item.getID());
                        pstmt.addBatch();
                        delItem = delItem.next;
                    }
                    if (!hasBatchItems.booleanValue()) break block12;
                    pstmt.executeBatch();
                }
                catch (SQLException ex) {
                    try {
                        log.error("Failed to delete published item(s) from DB", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        DbConnectionManager.closeStatement(pstmt);
                        throw throwable;
                    }
                    DbConnectionManager.closeStatement(pstmt);
                }
            }
            DbConnectionManager.closeStatement(pstmt);
        }
        try {
            PubSubPersistenceManager.writePendingItems(con, addList.getFirst(), true);
        }
        catch (SQLException ex) {
            PubSubPersistenceManager.writePendingItems(con, addList.getFirst(), false);
        }
    }

    private static void writePendingItems(Connection con, LinkedListNode<RetryWrapper> addItem, boolean batch) throws SQLException {
        if (addItem == null) {
            return;
        }
        LinkedListNode addHead = addItem.previous;
        PreparedStatement pstmt = null;
        RetryWrapper wrappedItem = null;
        PublishedItem item = null;
        try {
            pstmt = con.prepareStatement(ADD_ITEM);
            Boolean hasBatchItems = false;
            while (addItem != addHead) {
                hasBatchItems = true;
                wrappedItem = (RetryWrapper)addItem.object;
                item = wrappedItem.get();
                pstmt.setString(1, item.getNode().getService().getServiceID());
                pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(item.getNodeID()));
                pstmt.setString(3, item.getID());
                pstmt.setString(4, item.getPublisher().toString());
                pstmt.setString(5, StringUtils.dateToMillis(item.getCreationDate()));
                pstmt.setString(6, item.getPayloadXML());
                if (batch) {
                    pstmt.addBatch();
                } else {
                    try {
                        pstmt.execute();
                    }
                    catch (SQLException se) {
                        String itemKey = item.getItemKey();
                        if (wrappedItem.nextRetry() < MAX_ITEM_RETRY) {
                            log.warn("Failed to persist published item (will retry): " + itemKey);
                            PubSubPersistenceManager.savePublishedItem(wrappedItem);
                        }
                        log.error("Published item could not be written to database: " + itemKey + "\n" + item.getPayloadXML(), (Throwable)se);
                    }
                }
                addItem = addItem.next;
            }
            if (batch && hasBatchItems.booleanValue()) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException se) {
            log.error("Failed to persist published items as batch; will retry individually", (Throwable)se);
            throw se;
        }
        finally {
            DbConnectionManager.closeStatement(pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePublishedItem(PublishedItem item) {
        String itemKey = item.getItemKey();
        itemCache.remove(itemKey);
        HashMap<String, LinkedListNode<RetryWrapper>> hashMap = itemsPending;
        synchronized (hashMap) {
            itemsToDelete.addLast(item);
            LinkedListNode<RetryWrapper> itemToAdd = itemsPending.remove(itemKey);
            if (itemToAdd != null) {
                itemToAdd.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultNodeConfiguration loadDefaultConfiguration(PubSubService service, boolean isLeafType) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        DefaultNodeConfiguration config = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_DEFAULT_CONF);
            pstmt.setString(1, service.getServiceID());
            pstmt.setInt(2, isLeafType ? 1 : 0);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                config = new DefaultNodeConfiguration(isLeafType);
                config.setDeliverPayloads(rs.getInt(1) == 1);
                config.setMaxPayloadSize(rs.getInt(2));
                config.setPersistPublishedItems(rs.getInt(3) == 1);
                config.setMaxPublishedItems(rs.getInt(4));
                config.setNotifyConfigChanges(rs.getInt(5) == 1);
                config.setNotifyDelete(rs.getInt(6) == 1);
                config.setNotifyRetract(rs.getInt(7) == 1);
                config.setPresenceBasedDelivery(rs.getInt(8) == 1);
                config.setSendItemSubscribe(rs.getInt(9) == 1);
                config.setPublisherModel(PublisherModel.valueOf(rs.getString(10)));
                config.setSubscriptionEnabled(rs.getInt(11) == 1);
                config.setAccessModel(AccessModel.valueOf(rs.getString(12)));
                config.setLanguage(rs.getString(13));
                if (rs.getString(14) != null) {
                    config.setReplyPolicy(Node.ItemReplyPolicy.valueOf(rs.getString(14)));
                }
                config.setAssociationPolicy(CollectionNode.LeafNodeAssociationPolicy.valueOf(rs.getString(15)));
                config.setMaxLeafNodes(rs.getInt(16));
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (Exception sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDefaultConfiguration(PubSubService service, DefaultNodeConfiguration config) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(ADD_DEFAULT_CONF);
            pstmt.setString(1, service.getServiceID());
            pstmt.setInt(2, config.isLeaf() ? 1 : 0);
            pstmt.setInt(3, config.isDeliverPayloads() ? 1 : 0);
            pstmt.setInt(4, config.getMaxPayloadSize());
            pstmt.setInt(5, config.isPersistPublishedItems() ? 1 : 0);
            pstmt.setInt(6, config.getMaxPublishedItems());
            pstmt.setInt(7, config.isNotifyConfigChanges() ? 1 : 0);
            pstmt.setInt(8, config.isNotifyDelete() ? 1 : 0);
            pstmt.setInt(9, config.isNotifyRetract() ? 1 : 0);
            pstmt.setInt(10, config.isPresenceBasedDelivery() ? 1 : 0);
            pstmt.setInt(11, config.isSendItemSubscribe() ? 1 : 0);
            pstmt.setString(12, config.getPublisherModel().getName());
            pstmt.setInt(13, config.isSubscriptionEnabled() ? 1 : 0);
            pstmt.setString(14, config.getAccessModel().getName());
            pstmt.setString(15, config.getLanguage());
            if (config.getReplyPolicy() != null) {
                pstmt.setString(16, config.getReplyPolicy().name());
            } else {
                pstmt.setString(16, null);
            }
            pstmt.setString(17, config.getAssociationPolicy().name());
            pstmt.setInt(18, config.getMaxLeafNodes());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDefaultConfiguration(PubSubService service, DefaultNodeConfiguration config) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_DEFAULT_CONF);
            pstmt.setInt(1, config.isDeliverPayloads() ? 1 : 0);
            pstmt.setInt(2, config.getMaxPayloadSize());
            pstmt.setInt(3, config.isPersistPublishedItems() ? 1 : 0);
            pstmt.setInt(4, config.getMaxPublishedItems());
            pstmt.setInt(5, config.isNotifyConfigChanges() ? 1 : 0);
            pstmt.setInt(6, config.isNotifyDelete() ? 1 : 0);
            pstmt.setInt(7, config.isNotifyRetract() ? 1 : 0);
            pstmt.setInt(8, config.isPresenceBasedDelivery() ? 1 : 0);
            pstmt.setInt(9, config.isSendItemSubscribe() ? 1 : 0);
            pstmt.setString(10, config.getPublisherModel().getName());
            pstmt.setInt(11, config.isSubscriptionEnabled() ? 1 : 0);
            pstmt.setString(12, config.getAccessModel().getName());
            pstmt.setString(13, config.getLanguage());
            if (config.getReplyPolicy() != null) {
                pstmt.setString(14, config.getReplyPolicy().name());
            } else {
                pstmt.setString(14, null);
            }
            pstmt.setString(15, config.getAssociationPolicy().name());
            pstmt.setInt(16, config.getMaxLeafNodes());
            pstmt.setString(17, service.getServiceID());
            pstmt.setInt(18, config.isLeaf() ? 1 : 0);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    public static List<PublishedItem> getPublishedItems(LeafNode node) {
        return PubSubPersistenceManager.getPublishedItems(node, node.getMaxPublishedItems());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PublishedItem> getPublishedItems(LeafNode node, int maxRows) {
        Lock itemLock = CacheFactory.getLock(ITEM_CACHE, itemCache);
        try {
            itemLock.lock();
            PubSubPersistenceManager.flushPendingItems();
        }
        finally {
            itemLock.unlock();
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int max = MAX_ROWS_FETCH;
        int maxPublished = node.getMaxPublishedItems();
        if (maxRows != -1) {
            max = maxPublished == -1 ? Math.min(maxRows, MAX_ROWS_FETCH) : Math.min(maxRows, maxPublished);
        } else if (maxPublished != -1) {
            max = Math.min(MAX_ROWS_FETCH, maxPublished);
        }
        java.util.LinkedList<PublishedItem> results = new java.util.LinkedList<PublishedItem>();
        boolean descending = JiveGlobals.getBooleanProperty("xmpp.pubsub.order.descending", false);
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT id,jid,creationDate,payload FROM ofPubsubItem WHERE serviceID=? AND nodeID=? ORDER BY creationDate DESC");
            pstmt.setMaxRows(max);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            rs = pstmt.executeQuery();
            for (int counter = 0; rs.next() && counter < max; ++counter) {
                String itemID = rs.getString(1);
                JID publisher = new JID(rs.getString(2));
                Date creationDate = new Date(Long.parseLong(rs.getString(3).trim()));
                PublishedItem item = new PublishedItem(node, publisher, itemID, creationDate);
                if (rs.getString(4) != null) {
                    item.setPayloadXML(rs.getString(4));
                }
                if (descending) {
                    results.add(item);
                    continue;
                }
                results.addFirst(item);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (Exception sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublishedItem getLastPublishedItem(LeafNode node) {
        Lock itemLock = CacheFactory.getLock(ITEM_CACHE, itemCache);
        try {
            itemLock.lock();
            PubSubPersistenceManager.flushPendingItems();
        }
        finally {
            itemLock.unlock();
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        PublishedItem item = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement("SELECT id,jid,creationDate,payload FROM ofPubsubItem WHERE serviceID=? AND nodeID=? ORDER BY creationDate DESC");
            pstmt.setFetchSize(1);
            pstmt.setMaxRows(1);
            pstmt.setString(1, node.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(node.getNodeID()));
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String itemID = rs.getString(1);
                JID publisher = new JID(rs.getString(2));
                Date creationDate = new Date(Long.parseLong(rs.getString(3).trim()));
                item = new PublishedItem(node, publisher, itemID, creationDate);
                if (rs.getString(4) != null) {
                    item.setPayloadXML(rs.getString(4));
                }
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (Exception sqle) {
            log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublishedItem getPublishedItem(LeafNode node, String itemID) {
        String itemKey = PublishedItem.getItemKey(node, itemID);
        PublishedItem result = (PublishedItem)itemCache.get(itemKey);
        if (result == null) {
            Lock itemLock = CacheFactory.getLock(ITEM_CACHE, itemCache);
            try {
                itemLock.lock();
                result = (PublishedItem)itemCache.get(itemKey);
                if (result == null) {
                    PreparedStatement pstmt;
                    Connection con;
                    block11: {
                        PubSubPersistenceManager.flushPendingItems();
                        con = null;
                        pstmt = null;
                        ResultSet rs = null;
                        try {
                            con = DbConnectionManager.getConnection();
                            pstmt = con.prepareStatement(LOAD_ITEM);
                            pstmt.setString(1, node.getService().getServiceID());
                            pstmt.setString(2, node.getNodeID());
                            pstmt.setString(3, itemID);
                            rs = pstmt.executeQuery();
                            if (!rs.next()) break block11;
                            JID publisher = new JID(rs.getString(1));
                            Date creationDate = new Date(Long.parseLong(rs.getString(2).trim()));
                            result = new PublishedItem(node, publisher, itemID, creationDate);
                            if (rs.getString(3) != null) {
                                result.setPayloadXML(rs.getString(3));
                            }
                            itemCache.put(itemKey, result);
                            log.debug("Loaded item into cache from DB");
                        }
                        catch (Exception exc) {
                            try {
                                log.error(exc.getMessage(), (Throwable)exc);
                            }
                            catch (Throwable throwable) {
                                DbConnectionManager.closeConnection(pstmt, con);
                                throw throwable;
                            }
                            DbConnectionManager.closeConnection(pstmt, con);
                        }
                    }
                    DbConnectionManager.closeConnection(pstmt, con);
                }
                log.debug("Found cached item on second attempt (after acquiring lock)");
            }
            finally {
                itemLock.unlock();
            }
        } else {
            log.debug("Found cached item on first attempt (no lock)");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeNode(LeafNode leafNode) {
        Connection con = null;
        boolean rollback = false;
        try {
            con = DbConnectionManager.getTransactionConnection();
            PubSubPersistenceManager.purgeNode(leafNode, con);
            HashMap<String, LinkedListNode<RetryWrapper>> hashMap = itemsPending;
            synchronized (hashMap) {
                Iterator<Map.Entry<String, LinkedListNode<RetryWrapper>>> pendingIt = itemsPending.entrySet().iterator();
                while (pendingIt.hasNext()) {
                    LinkedListNode<RetryWrapper> itemNode = pendingIt.next().getValue();
                    if (!((RetryWrapper)itemNode.object).get().getNodeID().equals(leafNode.getNodeID())) continue;
                    itemNode.remove();
                    pendingIt.remove();
                }
            }
        }
        catch (SQLException exc) {
            log.error(exc.getMessage(), (Throwable)exc);
            rollback = true;
        }
        finally {
            DbConnectionManager.closeTransactionConnection(con, rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void purgeNode(LeafNode leafNode, Connection con) throws SQLException {
        PubSubPersistenceManager.flushPendingItems();
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(DELETE_ITEMS);
            pstmt.setString(1, leafNode.getService().getServiceID());
            pstmt.setString(2, PubSubPersistenceManager.encodeNodeID(leafNode.getNodeID()));
            pstmt.executeUpdate();
        }
        finally {
            DbConnectionManager.closeStatement(pstmt);
        }
        Cache<String, PublishedItem> cache = itemCache;
        synchronized (cache) {
            for (PublishedItem item : itemCache.values()) {
                if (!leafNode.getNodeID().equals(item.getNodeID())) continue;
                itemCache.remove(item.getItemKey());
            }
        }
    }

    private static String encodeWithComma(Collection<String> strings) {
        StringBuilder sb = new StringBuilder(90);
        for (String group : strings) {
            sb.append(group).append(',');
        }
        if (!strings.isEmpty()) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static Collection<String> decodeWithComma(String strings) {
        ArrayList<String> decodedStrings = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(strings.trim(), ",");
        while (tokenizer.hasMoreTokens()) {
            decodedStrings.add(tokenizer.nextToken());
        }
        return decodedStrings;
    }

    private static String encodeNodeID(String nodeID) {
        if (DbConnectionManager.getDatabaseType() == DbConnectionManager.DatabaseType.oracle && "".equals(nodeID)) {
            return " ";
        }
        return nodeID;
    }

    private static String decodeNodeID(String nodeID) {
        if (DbConnectionManager.getDatabaseType() == DbConnectionManager.DatabaseType.oracle && " ".equals(nodeID)) {
            return "";
        }
        return nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void purgeItems() {
        ResultSet rs;
        PreparedStatement nodeConfig;
        PreparedStatement pstmt;
        Connection con;
        boolean abortTransaction;
        block5: {
            abortTransaction = false;
            con = null;
            pstmt = null;
            nodeConfig = null;
            rs = null;
            try {
                con = DbConnectionManager.getTransactionConnection();
                nodeConfig = con.prepareStatement(PERSISTENT_NODES);
                rs = nodeConfig.executeQuery();
                PreparedStatement purgeNode = con.prepareStatement(PubSubPersistenceManager.getPurgeStatement(DbConnectionManager.getDatabaseType()));
                Boolean hasBatchItems = false;
                while (rs.next()) {
                    hasBatchItems = true;
                    String svcId = rs.getString(1);
                    String nodeId = rs.getString(2);
                    int maxItems = rs.getInt(3);
                    PubSubPersistenceManager.setPurgeParams(DbConnectionManager.getDatabaseType(), purgeNode, svcId, nodeId, maxItems);
                    purgeNode.addBatch();
                }
                if (!hasBatchItems.booleanValue()) break block5;
                purgeNode.executeBatch();
            }
            catch (Exception sqle) {
                try {
                    log.error(sqle.getMessage(), (Throwable)sqle);
                    abortTransaction = true;
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeResultSet(rs);
                    DbConnectionManager.closeStatement(rs, nodeConfig);
                    DbConnectionManager.closeTransactionConnection(pstmt, con, abortTransaction);
                    throw throwable;
                }
                DbConnectionManager.closeResultSet(rs);
                DbConnectionManager.closeStatement(rs, nodeConfig);
                DbConnectionManager.closeTransactionConnection(pstmt, con, abortTransaction);
            }
        }
        DbConnectionManager.closeResultSet(rs);
        DbConnectionManager.closeStatement(rs, nodeConfig);
        DbConnectionManager.closeTransactionConnection(pstmt, con, abortTransaction);
    }

    private static void setPurgeParams(DbConnectionManager.DatabaseType dbType, PreparedStatement purgeStmt, String serviceId, String nodeId, int maxItems) throws SQLException {
        switch (dbType) {
            case hsqldb: {
                purgeStmt.setString(1, serviceId);
                purgeStmt.setString(2, nodeId);
                purgeStmt.setString(3, serviceId);
                purgeStmt.setString(4, nodeId);
                purgeStmt.setInt(5, maxItems);
                break;
            }
            default: {
                purgeStmt.setString(1, serviceId);
                purgeStmt.setString(2, nodeId);
                purgeStmt.setInt(3, maxItems);
                purgeStmt.setString(4, serviceId);
                purgeStmt.setString(5, nodeId);
            }
        }
    }

    private static String getPurgeStatement(DbConnectionManager.DatabaseType type) {
        switch (type) {
            case postgresql: {
                return PURGE_FOR_SIZE_POSTGRESQL;
            }
            case mysql: {
                return PURGE_FOR_SIZE_MYSQL;
            }
            case hsqldb: {
                return PURGE_FOR_SIZE_HSQLDB;
            }
        }
        return PURGE_FOR_SIZE;
    }

    public static void shutdown() {
        log.info("Flushing write cache to database");
        PubSubPersistenceManager.flushPendingItems(false);
        if (!ClusterManager.isClusteringEnabled()) {
            PubSubPersistenceManager.purgeItems();
        }
    }

    static {
        try {
            if (MAX_ITEMS_FLUSH > 0) {
                TaskEngine.getInstance().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        PubSubPersistenceManager.flushPendingItems(false);
                    }
                }, Math.abs(prng.nextLong()) % flushTimerDelay, flushTimerDelay);
            }
            if (ClusterManager.isClusteringEnabled()) {
                purgeTimerDelay *= 2L;
            }
            TaskEngine.getInstance().schedule(new TimerTask(){

                @Override
                public void run() {
                    PubSubPersistenceManager.purgeItems();
                }
            }, Math.abs(prng.nextLong()) % purgeTimerDelay, purgeTimerDelay);
        }
        catch (Exception ex) {
            log.error("Failed to initialize pubsub maintentence tasks", (Throwable)ex);
        }
    }

    private static class RetryWrapper {
        private PublishedItem item;
        private volatile transient int retryCount = 0;

        public RetryWrapper(PublishedItem item) {
            this.item = item;
        }

        public PublishedItem get() {
            return this.item;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public int nextRetry() {
            return ++this.retryCount;
        }
    }
}

