/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.XMPPServerListener;
import org.jivesoftware.openfire.pep.PEPService;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.DefaultNodeConfiguration;
import org.jivesoftware.openfire.pubsub.LeafNode;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeAffiliate;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.NotAcceptableException;
import org.jivesoftware.openfire.pubsub.PubSubPersistenceManager;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.openfire.pubsub.PublishedItem;
import org.jivesoftware.openfire.pubsub.cluster.RefreshNodeTask;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class PubSubEngine {
    private static final Logger Log = LoggerFactory.getLogger(PubSubEngine.class);
    private PacketRouter router = null;

    public PubSubEngine(PacketRouter router) {
        this.router = router;
    }

    public boolean process(PubSubService service, IQ iq) {
        if (IQ.Type.error == iq.getType() || IQ.Type.result == iq.getType()) {
            return true;
        }
        Element childElement = iq.getChildElement();
        String namespace = null;
        if (childElement != null) {
            namespace = childElement.getNamespaceURI();
        }
        if ("http://jabber.org/protocol/pubsub".equals(namespace)) {
            Element action = childElement.element("publish");
            if (action != null) {
                this.publishItemsToNode(service, iq, action);
                return true;
            }
            action = childElement.element("subscribe");
            if (action != null) {
                this.subscribeNode(service, iq, childElement, action);
                return true;
            }
            action = childElement.element("options");
            if (action != null) {
                if (IQ.Type.get == iq.getType()) {
                    this.getSubscriptionConfiguration(service, iq, childElement, action);
                } else {
                    this.configureSubscription(service, iq, action);
                }
                return true;
            }
            action = childElement.element("create");
            if (action != null) {
                this.createNode(service, iq, childElement, action);
                return true;
            }
            action = childElement.element("unsubscribe");
            if (action != null) {
                this.unsubscribeNode(service, iq, action);
                return true;
            }
            action = childElement.element("subscriptions");
            if (action != null) {
                this.getSubscriptions(service, iq, childElement);
                return true;
            }
            action = childElement.element("affiliations");
            if (action != null) {
                this.getAffiliations(service, iq, childElement);
                return true;
            }
            action = childElement.element("items");
            if (action != null) {
                this.getPublishedItems(service, iq, action);
                return true;
            }
            action = childElement.element("retract");
            if (action != null) {
                this.deleteItems(service, iq, action);
                return true;
            }
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            return true;
        }
        if ("http://jabber.org/protocol/pubsub#owner".equals(namespace)) {
            Element action = childElement.element("configure");
            if (action != null) {
                String nodeID = action.attributeValue("node");
                if (nodeID == null) {
                    if (!service.isServiceAdmin(iq.getFrom()) || !service.isCollectionNodesSupported()) {
                        Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                        this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                        return true;
                    }
                    nodeID = service.getRootCollectionNode().getNodeID();
                }
                if (IQ.Type.get == iq.getType()) {
                    this.getNodeConfiguration(service, iq, childElement, nodeID);
                } else {
                    this.configureNode(service, iq, action, nodeID);
                }
                return true;
            }
            action = childElement.element("default");
            if (action != null) {
                this.getDefaultNodeConfiguration(service, iq, childElement, action);
                return true;
            }
            action = childElement.element("delete");
            if (action != null) {
                this.deleteNode(service, iq, action);
                return true;
            }
            action = childElement.element("subscriptions");
            if (action != null) {
                if (IQ.Type.get == iq.getType()) {
                    this.getNodeSubscriptions(service, iq, action);
                } else {
                    this.modifyNodeSubscriptions(service, iq, action);
                }
                return true;
            }
            action = childElement.element("affiliations");
            if (action != null) {
                if (IQ.Type.get == iq.getType()) {
                    this.getNodeAffiliations(service, iq, action);
                } else {
                    this.modifyNodeAffiliations(service, iq, action);
                }
                return true;
            }
            action = childElement.element("purge");
            if (action != null) {
                this.purgeNode(service, iq, action);
                return true;
            }
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            return true;
        }
        if ("http://jabber.org/protocol/commands".equals(namespace)) {
            IQ reply = service.getManager().process(iq);
            this.router.route(reply);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(PubSubService service, Presence presence) {
        if (presence.isAvailable()) {
            JID subscriber = presence.getFrom();
            Map<String, String> fullPresences = service.getBarePresences().get(subscriber.toBareJID());
            if (fullPresences == null) {
                String string = subscriber.toBareJID().intern();
                synchronized (string) {
                    fullPresences = service.getBarePresences().get(subscriber.toBareJID());
                    if (fullPresences == null) {
                        fullPresences = new ConcurrentHashMap<String, String>();
                        service.getBarePresences().put(subscriber.toBareJID(), fullPresences);
                    }
                }
            }
            Presence.Show show = presence.getShow();
            fullPresences.put(subscriber.toString(), show == null ? "online" : show.name());
        } else if (presence.getType() == Presence.Type.unavailable) {
            JID subscriber = presence.getFrom();
            Map<String, String> fullPresences = service.getBarePresences().get(subscriber.toBareJID());
            if (fullPresences != null) {
                fullPresences.remove(subscriber.toString());
                if (fullPresences.isEmpty()) {
                    service.getBarePresences().remove(subscriber.toBareJID());
                }
            }
        }
    }

    public void process(PubSubService service, Message message) {
        String formType;
        DataForm authForm;
        if (message.getType() == Message.Type.error) {
            if (message.getError().getType() == PacketError.Type.cancel) {
                JID owner = message.getFrom().asBareJID();
                this.cancelAllSubscriptions(service, owner);
            } else if (message.getError().getType() == PacketError.Type.auth) {
                // empty if block
            }
        } else if (message.getType() == Message.Type.normal && (authForm = (DataForm)message.getExtension("x", "jabber:x:data")) != null && authForm.getType() == DataForm.Type.submit && "http://jabber.org/protocol/pubsub#subscribe_authorization".equals(formType = (String)authForm.getField("FORM_TYPE").getValues().get(0))) {
            this.processAuthorizationAnswer(service, authForm, message);
        }
    }

    private void publishItemsToNode(PubSubService service, IQ iq, Element publishElement) {
        String nodeID = publishElement.attributeValue("node");
        JID from = iq.getFrom();
        JID owner = from.asBareJID();
        if (nodeID == null) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            if (service instanceof PEPService && service.isServiceAdmin(owner)) {
                Element childElement = iq.getChildElement();
                CreateNodeResponse response = this.createNodeHelper(service, iq, childElement, publishElement);
                if (response.newNode == null) {
                    this.sendErrorPacket(iq, response.creationStatus, response.pubsubError);
                } else {
                    node = response.newNode;
                }
            } else {
                this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
                return;
            }
        }
        if (!node.getPublisherModel().canPublish(node, owner) && !service.isServiceAdmin(owner)) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        if (node.isCollectionNode()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"unsupported", (String)"http://jabber.org/protocol/pubsub#errors"));
            pubsubError.addAttribute("feature", "publish");
            this.sendErrorPacket(iq, PacketError.Condition.feature_not_implemented, pubsubError);
            return;
        }
        LeafNode leafNode = (LeafNode)node;
        Iterator itemElements = publishElement.elementIterator("item");
        if (!itemElements.hasNext() && leafNode.isItemRequired()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"item-required", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        if (itemElements.hasNext() && !leafNode.isItemRequired()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"item-forbidden", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        ArrayList<Element> items = new ArrayList<Element>();
        while (itemElements.hasNext()) {
            Element payload;
            Element item = (Element)itemElements.next();
            List entries = item.elements();
            Element element = payload = entries.isEmpty() ? null : (Element)entries.get(0);
            if (payload == null && leafNode.isPayloadDelivered()) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"payload-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            if (entries.size() > 1) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"invalid-payload", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            items.add(item);
        }
        this.router.route(IQ.createResultIQ((IQ)iq));
        leafNode.publishItems(from, items);
    }

    private void deleteItems(PubSubService service, IQ iq, Element retractElement) {
        String nodeID = retractElement.attributeValue("node");
        if (nodeID == null) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        Iterator itemElements = retractElement.elementIterator("item");
        if (!itemElements.hasNext()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"item-required", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        if (node.isCollectionNode()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"unsupported", (String)"http://jabber.org/protocol/pubsub#errors"));
            pubsubError.addAttribute("feature", "persistent-items");
            this.sendErrorPacket(iq, PacketError.Condition.feature_not_implemented, pubsubError);
            return;
        }
        LeafNode leafNode = (LeafNode)node;
        if (!leafNode.isItemRequired()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"unsupported", (String)"http://jabber.org/protocol/pubsub#errors"));
            pubsubError.addAttribute("feature", "persistent-items");
            this.sendErrorPacket(iq, PacketError.Condition.feature_not_implemented, pubsubError);
            return;
        }
        ArrayList<PublishedItem> items = new ArrayList<PublishedItem>();
        while (itemElements.hasNext()) {
            Element itemElement = (Element)itemElements.next();
            String itemID = itemElement.attributeValue("id");
            if (itemID != null) {
                PublishedItem item = node.getPublishedItem(itemID);
                if (item == null) {
                    this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
                    return;
                }
                if (item.canDelete(iq.getFrom())) {
                    items.add(item);
                    continue;
                }
                this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
                return;
            }
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"item-required", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        this.router.route(IQ.createResultIQ((IQ)iq));
        leafNode.deleteItems(items);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void subscribeNode(PubSubService service, IQ iq, Element childElement, Element subscribeElement) {
        NodeSubscription existingSubscription;
        Element formElement;
        Node node;
        String nodeID = subscribeElement.attributeValue("node");
        if (nodeID == null) {
            if (!service.isCollectionNodesSupported()) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            node = service.getRootCollectionNode();
        } else {
            node = service.getNode(nodeID);
            if (node == null) {
                this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
                return;
            }
        }
        JID from = iq.getFrom();
        JID subscriberJID = new JID(subscribeElement.attributeValue("jid"));
        if (!from.toBareJID().equals(subscriberJID.toBareJID()) && !service.isServiceAdmin(from)) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"invalid-jid", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        JID owner = subscriberJID.asBareJID();
        AccessModel accessModel = node.getAccessModel();
        if (!accessModel.canSubscribe(node, owner, subscriberJID)) {
            this.sendErrorPacket(iq, accessModel.getSubsriptionError(), accessModel.getSubsriptionErrorDetail());
            return;
        }
        if (!this.isComponent(subscriberJID) && !UserManager.getInstance().isRegisteredUser(subscriberJID)) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        NodeAffiliate nodeAffiliate = node.getAffiliate(owner);
        if (nodeAffiliate != null && nodeAffiliate.getAffiliation() == NodeAffiliate.Affiliation.outcast) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        if (!node.isSubscriptionEnabled() && !service.isServiceAdmin(from)) {
            this.sendErrorPacket(iq, PacketError.Condition.not_allowed, null);
            return;
        }
        DataForm optionsForm = null;
        Element options = childElement.element("options");
        if (options != null && (formElement = options.element(QName.get((String)"x", (String)"jabber:x:data"))) != null) {
            optionsForm = new DataForm(formElement);
        }
        if (!node.isCollectionNode() && !node.isMultipleSubscriptionsEnabled() && (existingSubscription = node.getSubscription(subscriberJID)) != null) {
            existingSubscription.sendSubscriptionState(iq);
            return;
        }
        if (node.isCollectionNode()) {
            FormField field;
            boolean isNodeType = true;
            if (optionsForm != null && (field = optionsForm.getField("pubsub#subscription_type")) != null && "items".equals(field.getValues().get(0))) {
                isNodeType = false;
            }
            if (nodeAffiliate != null) {
                for (NodeSubscription subscription : nodeAffiliate.getSubscriptions()) {
                    if (isNodeType) {
                        if (NodeSubscription.Type.nodes != subscription.getType()) continue;
                        this.sendErrorPacket(iq, PacketError.Condition.conflict, null);
                        return;
                    }
                    if (node.isMultipleSubscriptionsEnabled() || NodeSubscription.Type.items != subscription.getType()) continue;
                    subscription.sendSubscriptionState(iq);
                    return;
                }
            }
        }
        node.createSubscription(iq, owner, subscriberJID, accessModel.isAuthorizationRequired(), optionsForm);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void unsubscribeNode(PubSubService service, IQ iq, Element unsubscribeElement) {
        NodeSubscription subscription;
        Node node;
        String nodeID = unsubscribeElement.attributeValue("node");
        String subID = unsubscribeElement.attributeValue("subid");
        String jidAttribute = unsubscribeElement.attributeValue("jid");
        if (jidAttribute == null) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"jid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        if (nodeID == null) {
            if (!service.isCollectionNodesSupported()) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            node = service.getRootCollectionNode();
        } else {
            node = service.getNode(nodeID);
            if (node == null) {
                this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
                return;
            }
        }
        JID owner = new JID(jidAttribute);
        if (node.isMultipleSubscriptionsEnabled() && node.getSubscriptions(owner).size() > 1) {
            if (subID == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"subid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            subscription = node.getSubscription(subID);
            if (subscription == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"invalid-subid", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.not_acceptable, pubsubError);
                return;
            }
        } else {
            JID subscriberJID = new JID(jidAttribute);
            subscription = node.getSubscription(subscriberJID);
            if (subscription == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"not-subscribed", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.unexpected_request, pubsubError);
                return;
            }
        }
        JID from = iq.getFrom();
        if (!node.isSubscriptionEnabled() && !service.isServiceAdmin(from)) {
            this.sendErrorPacket(iq, PacketError.Condition.not_allowed, null);
            return;
        }
        if (!subscription.canModify(from) && !subscription.canModify(owner)) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        node.cancelSubscription(subscription);
        this.router.route(IQ.createResultIQ((IQ)iq));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getSubscriptionConfiguration(PubSubService service, IQ iq, Element childElement, Element optionsElement) {
        NodeSubscription subscription;
        Node node;
        String nodeID = optionsElement.attributeValue("node");
        String subID = optionsElement.attributeValue("subid");
        if (nodeID == null) {
            if (!service.isCollectionNodesSupported()) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            node = service.getRootCollectionNode();
        } else {
            node = service.getNode(nodeID);
            if (node == null) {
                this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
                return;
            }
        }
        if (node.isMultipleSubscriptionsEnabled()) {
            if (subID == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"subid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            subscription = node.getSubscription(subID);
            if (subscription == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"invalid-subid", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.not_acceptable, pubsubError);
                return;
            }
        } else {
            String jidAttribute = optionsElement.attributeValue("jid");
            if (jidAttribute == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"jid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            JID subscriberJID = new JID(jidAttribute);
            subscription = node.getSubscription(subscriberJID);
            if (subscription == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"not-subscribed", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.unexpected_request, pubsubError);
                return;
            }
        }
        if (!subscription.canModify(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        IQ reply = IQ.createResultIQ((IQ)iq);
        Element replyChildElement = childElement.createCopy();
        reply.setChildElement(replyChildElement);
        replyChildElement.element("options").add(subscription.getConfigurationForm().getElement());
        this.router.route(reply);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configureSubscription(PubSubService service, IQ iq, Element optionsElement) {
        NodeSubscription subscription;
        Node node;
        String nodeID = optionsElement.attributeValue("node");
        String subID = optionsElement.attributeValue("subid");
        if (nodeID == null) {
            if (!service.isCollectionNodesSupported()) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            node = service.getRootCollectionNode();
        } else {
            node = service.getNode(nodeID);
            if (node == null) {
                this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
                return;
            }
        }
        if (node.isMultipleSubscriptionsEnabled()) {
            if (subID == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"subid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            subscription = node.getSubscription(subID);
            if (subscription == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"invalid-subid", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.not_acceptable, pubsubError);
                return;
            }
        } else {
            String jidAttribute = optionsElement.attributeValue("jid");
            if (jidAttribute == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"jid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            JID subscriberJID = new JID(jidAttribute);
            subscription = node.getSubscription(subscriberJID);
            if (subscription == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"not-subscribed", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.unexpected_request, pubsubError);
                return;
            }
        }
        if (!subscription.canModify(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        Element formElement = optionsElement.element(QName.get((String)"x", (String)"jabber:x:data"));
        if (formElement != null) {
            subscription.configure(iq, new DataForm(formElement));
            return;
        }
        this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
    }

    private void getSubscriptions(PubSubService service, IQ iq, Element childElement) {
        JID owner = iq.getFrom().asBareJID();
        Element subscriptionsElement = childElement.element("subscriptions");
        String nodeID = subscriptionsElement.attributeValue("node");
        ArrayList<NodeSubscription> subscriptions = new ArrayList<NodeSubscription>();
        if (nodeID == null) {
            for (Node node : service.getNodes()) {
                subscriptions.addAll(node.getSubscriptions(owner));
            }
        } else {
            subscriptions.addAll(service.getNode(nodeID).getSubscriptions(owner));
        }
        IQ reply = IQ.createResultIQ((IQ)iq);
        Element replyChildElement = childElement.createCopy();
        reply.setChildElement(replyChildElement);
        Element affiliationsElement = replyChildElement.element("subscriptions");
        for (NodeSubscription subscription : subscriptions) {
            Element subElement = affiliationsElement.addElement("subscription");
            Node node = subscription.getNode();
            NodeAffiliate nodeAffiliate = subscription.getAffiliate();
            if (!node.isRootCollectionNode() && nodeID == null) {
                subElement.addAttribute("node", node.getNodeID());
            }
            subElement.addAttribute("jid", subscription.getJID().toString());
            subElement.addAttribute("subscription", subscription.getState().name());
            if (!node.isMultipleSubscriptionsEnabled()) continue;
            subElement.addAttribute("subid", subscription.getID());
        }
        this.router.route(reply);
    }

    private void getAffiliations(PubSubService service, IQ iq, Element childElement) {
        JID owner = iq.getFrom().asBareJID();
        ArrayList<NodeAffiliate> affiliations = new ArrayList<NodeAffiliate>();
        for (Node node : service.getNodes()) {
            NodeAffiliate nodeAffiliate = node.getAffiliate(owner);
            if (nodeAffiliate == null) continue;
            affiliations.add(nodeAffiliate);
        }
        IQ reply = IQ.createResultIQ((IQ)iq);
        Element replyChildElement = childElement.createCopy();
        reply.setChildElement(replyChildElement);
        if (affiliations.isEmpty()) {
            reply.setError(PacketError.Condition.item_not_found);
        } else {
            Element affiliationsElement = replyChildElement.element("affiliations");
            for (NodeAffiliate affiliate : affiliations) {
                Element affiliateElement = affiliationsElement.addElement("affiliation");
                if (!affiliate.getNode().isRootCollectionNode()) {
                    affiliateElement.addAttribute("node", affiliate.getNode().getNodeID());
                }
                affiliateElement.addAttribute("jid", affiliate.getJID().toString());
                affiliateElement.addAttribute("affiliation", affiliate.getAffiliation().name());
            }
        }
        this.router.route(reply);
    }

    private void getPublishedItems(PubSubService service, IQ iq, Element itemsElement) {
        ArrayList<PublishedItem> items;
        String nodeID = itemsElement.attributeValue("node");
        String subID = itemsElement.attributeValue("subid");
        if (nodeID == null) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (node.isCollectionNode()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"unsupported", (String)"http://jabber.org/protocol/pubsub#errors"));
            pubsubError.addAttribute("feature", "retrieve-items");
            this.sendErrorPacket(iq, PacketError.Condition.feature_not_implemented, pubsubError);
            return;
        }
        JID subscriberJID = iq.getFrom();
        JID owner = subscriberJID.asBareJID();
        AccessModel accessModel = node.getAccessModel();
        if (!accessModel.canAccessItems(node, owner, subscriberJID)) {
            this.sendErrorPacket(iq, accessModel.getSubsriptionError(), accessModel.getSubsriptionErrorDetail());
            return;
        }
        NodeAffiliate affiliate = node.getAffiliate(owner);
        if (affiliate != null && affiliate.getAffiliation() == NodeAffiliate.Affiliation.outcast) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        NodeSubscription subscription = null;
        if (node.isMultipleSubscriptionsEnabled() && node.getSubscriptions(owner).size() > 1) {
            if (subID == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"subid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, pubsubError);
                return;
            }
            subscription = node.getSubscription(subID);
            if (subscription == null) {
                Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"invalid-subid", (String)"http://jabber.org/protocol/pubsub#errors"));
                this.sendErrorPacket(iq, PacketError.Condition.not_acceptable, pubsubError);
                return;
            }
        }
        if (subscription != null && !subscription.isActive()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"not-subscribed", (String)"http://jabber.org/protocol/pubsub#errors"));
            this.sendErrorPacket(iq, PacketError.Condition.not_authorized, pubsubError);
            return;
        }
        LeafNode leafNode = (LeafNode)node;
        boolean forceToIncludePayload = false;
        String max_items = itemsElement.attributeValue("max_items");
        int recentItems = 0;
        if (max_items != null) {
            try {
                recentItems = Integer.parseInt(max_items);
            }
            catch (NumberFormatException e) {
                Log.warn("Assuming that all items were requested", (Throwable)e);
                max_items = null;
            }
        }
        if (max_items != null) {
            items = new ArrayList<PublishedItem>(leafNode.getPublishedItems(recentItems));
        } else {
            List requestedItems = itemsElement.elements("item");
            if (requestedItems.isEmpty()) {
                items = new ArrayList<PublishedItem>(leafNode.getPublishedItems());
            } else {
                items = new ArrayList();
                forceToIncludePayload = true;
                for (Element element : requestedItems) {
                    String itemID = element.attributeValue("id");
                    PublishedItem item = leafNode.getPublishedItem(itemID);
                    if (item == null) continue;
                    items.add(item);
                }
            }
        }
        if (subscription != null && subscription.getKeyword() != null) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                PublishedItem item = (PublishedItem)it.next();
                if (subscription.isKeywordMatched(item)) continue;
                it.remove();
            }
        }
        leafNode.sendPublishedItems(iq, items, forceToIncludePayload);
    }

    private void createNode(PubSubService service, IQ iq, Element childElement, Element createElement) {
        CreateNodeResponse response = this.createNodeHelper(service, iq, childElement, createElement);
        if (response.newNode == null) {
            this.sendErrorPacket(iq, response.creationStatus, response.pubsubError);
        } else {
            IQ reply = IQ.createResultIQ((IQ)iq);
            Node newNode = response.newNode;
            String nodeID = createElement.attributeValue("node");
            if (!newNode.getNodeID().equals(nodeID)) {
                Element elem = reply.setChildElement("pubsub", "http://jabber.org/protocol/pubsub");
                elem.addElement("create").addAttribute("node", newNode.getNodeID());
            }
            this.router.route(reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateNodeResponse createNodeHelper(PubSubService service, IQ iq, Element childElement, Element createElement) {
        Element pubsubError;
        Node existingNode;
        String nodeID;
        JID from = iq.getFrom();
        if (!service.canCreateNode(from) || !this.isComponent(from) && !UserManager.getInstance().isRegisteredUser(from)) {
            return new CreateNodeResponse(PacketError.Condition.forbidden, null, null);
        }
        DataForm completedForm = null;
        CollectionNode parentNode = null;
        String newNodeID = nodeID = createElement.attributeValue("node");
        if (nodeID == null) {
            if (!service.isInstantNodeSupported()) {
                Element pubsubError2 = DocumentHelper.createElement((QName)QName.get((String)"nodeid-required", (String)"http://jabber.org/protocol/pubsub#errors"));
                return new CreateNodeResponse(PacketError.Condition.not_acceptable, pubsubError2, null);
            }
            while (service.getNode(newNodeID = StringUtils.randomString(15)) != null) {
            }
        }
        boolean collectionType = false;
        Element configureElement = childElement.element("configure");
        if (configureElement != null && (completedForm = this.getSentConfigurationForm(configureElement)) != null) {
            List values;
            FormField field = completedForm.getField("pubsub#collection");
            if (field != null && !(values = field.getValues()).isEmpty()) {
                String parentNodeID = (String)values.get(0);
                Node tempNode = service.getNode(parentNodeID);
                if (tempNode == null) {
                    return new CreateNodeResponse(PacketError.Condition.item_not_found, null, null);
                }
                if (!tempNode.isCollectionNode()) {
                    return new CreateNodeResponse(PacketError.Condition.not_acceptable, null, null);
                }
                parentNode = (CollectionNode)tempNode;
            }
            if ((field = completedForm.getField("pubsub#node_type")) != null && !(values = field.getValues()).isEmpty()) {
                collectionType = "collection".equals(values.get(0));
            }
        }
        if (parentNode == null && service.isCollectionNodesSupported()) {
            parentNode = service.getRootCollectionNode();
        }
        if ((existingNode = service.getNode(newNodeID)) != null) {
            return new CreateNodeResponse(PacketError.Condition.conflict, null, null);
        }
        if (collectionType && !service.isCollectionNodesSupported()) {
            pubsubError = DocumentHelper.createElement((QName)QName.get((String)"unsupported", (String)"http://jabber.org/protocol/pubsub#errors"));
            pubsubError.addAttribute("feature", "collections");
            return new CreateNodeResponse(PacketError.Condition.feature_not_implemented, pubsubError, null);
        }
        if (parentNode != null && !collectionType) {
            if (!parentNode.isAssociationAllowed(from)) {
                return new CreateNodeResponse(PacketError.Condition.forbidden, null, null);
            }
            if (parentNode.isMaxLeafNodeReached()) {
                pubsubError = DocumentHelper.createElement((QName)QName.get((String)"max-nodes-exceeded", (String)"http://jabber.org/protocol/pubsub#errors"));
                return new CreateNodeResponse(PacketError.Condition.conflict, pubsubError, null);
            }
        }
        boolean conflict = false;
        Node newNode = null;
        try {
            JID owner = from.asBareJID();
            String string = newNodeID.intern();
            synchronized (string) {
                if (service.getNode(newNodeID) == null) {
                    newNode = collectionType ? new CollectionNode(service, parentNode, newNodeID, from) : new LeafNode(service, parentNode, newNodeID, from);
                    newNode.addOwner(owner);
                    if (completedForm != null) {
                        newNode.configure(completedForm);
                    } else {
                        newNode.saveToDB();
                    }
                    CacheFactory.doClusterTask(new RefreshNodeTask(newNode));
                } else {
                    conflict = true;
                }
            }
            if (conflict) {
                return new CreateNodeResponse(PacketError.Condition.conflict, null, null);
            }
            return new CreateNodeResponse(null, null, newNode);
        }
        catch (NotAcceptableException e) {
            return new CreateNodeResponse(PacketError.Condition.not_acceptable, null, null);
        }
    }

    private void getNodeConfiguration(PubSubService service, IQ iq, Element childElement, String nodeID) {
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (!node.isAdmin(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        IQ reply = IQ.createResultIQ((IQ)iq);
        Element replyChildElement = childElement.createCopy();
        reply.setChildElement(replyChildElement);
        replyChildElement.element("configure").add(node.getConfigurationForm().getElement());
        this.router.route(reply);
    }

    private void getDefaultNodeConfiguration(PubSubService service, IQ iq, Element childElement, Element defaultElement) {
        String type = defaultElement.attributeValue("type");
        type = type == null ? "leaf" : type;
        boolean isLeafType = "leaf".equals(type);
        DefaultNodeConfiguration config = service.getDefaultNodeConfiguration(isLeafType);
        if (config == null) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"unsupported", (String)"http://jabber.org/protocol/pubsub#errors"));
            pubsubError.addAttribute("feature", isLeafType ? "leaf" : "collections");
            this.sendErrorPacket(iq, PacketError.Condition.feature_not_implemented, pubsubError);
            return;
        }
        IQ reply = IQ.createResultIQ((IQ)iq);
        Element replyChildElement = childElement.createCopy();
        reply.setChildElement(replyChildElement);
        replyChildElement.element("default").add(config.getConfigurationForm().getElement());
        this.router.route(reply);
    }

    private void configureNode(PubSubService service, IQ iq, Element configureElement, String nodeID) {
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (!node.isAdmin(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        DataForm completedForm = this.getSentConfigurationForm(configureElement);
        if (completedForm != null) {
            try {
                node.configure(completedForm);
                CacheFactory.doClusterTask(new RefreshNodeTask(node));
                this.router.route(IQ.createResultIQ((IQ)iq));
            }
            catch (NotAcceptableException e) {
                this.sendErrorPacket(iq, PacketError.Condition.not_acceptable, null);
            }
        } else {
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
        }
    }

    private void deleteNode(PubSubService service, IQ iq, Element deleteElement) {
        String nodeID = deleteElement.attributeValue("node");
        if (nodeID == null) {
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (!node.isAdmin(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        if (node.isRootCollectionNode()) {
            this.sendErrorPacket(iq, PacketError.Condition.not_allowed, null);
            return;
        }
        if (node.delete()) {
            this.router.route(IQ.createResultIQ((IQ)iq));
        } else {
            this.sendErrorPacket(iq, PacketError.Condition.internal_server_error, null);
        }
    }

    private void purgeNode(PubSubService service, IQ iq, Element purgeElement) {
        String nodeID = purgeElement.attributeValue("node");
        if (nodeID == null) {
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (!node.isAdmin(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        if (!((LeafNode)node).isPersistPublishedItems()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"unsupported", (String)"http://jabber.org/protocol/pubsub#errors"));
            pubsubError.addAttribute("feature", "persistent-items");
            this.sendErrorPacket(iq, PacketError.Condition.feature_not_implemented, pubsubError);
            return;
        }
        if (node.isCollectionNode()) {
            Element pubsubError = DocumentHelper.createElement((QName)QName.get((String)"unsupported", (String)"http://jabber.org/protocol/pubsub#errors"));
            pubsubError.addAttribute("feature", "purge-nodes");
            this.sendErrorPacket(iq, PacketError.Condition.feature_not_implemented, pubsubError);
            return;
        }
        ((LeafNode)node).purge();
        this.router.route(IQ.createResultIQ((IQ)iq));
    }

    private void getNodeSubscriptions(PubSubService service, IQ iq, Element affiliationsElement) {
        String nodeID = affiliationsElement.attributeValue("node");
        if (nodeID == null) {
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (!node.isAdmin(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        node.sendSubscriptions(iq);
    }

    private void modifyNodeSubscriptions(PubSubService service, IQ iq, Element entitiesElement) {
        String nodeID = entitiesElement.attributeValue("node");
        if (nodeID == null) {
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (!node.isAdmin(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        IQ reply = IQ.createResultIQ((IQ)iq);
        Iterator it = entitiesElement.elementIterator("subscription");
        while (it.hasNext()) {
            Element entity = (Element)it.next();
            JID subscriber = new JID(entity.attributeValue("jid"));
            JID owner = subscriber.asBareJID();
            String subStatus = entity.attributeValue("subscription");
            String subID = entity.attributeValue("subid");
            NodeSubscription subscription = null;
            if (node.isMultipleSubscriptionsEnabled()) {
                if (subID != null) {
                    subscription = node.getSubscription(subID);
                }
            } else {
                subscription = node.getSubscription(subscriber);
            }
            if ("none".equals(subStatus) && subscription != null) {
                node.cancelSubscription(subscription);
                continue;
            }
            if (!"subscribed".equals(subStatus)) continue;
            if (subscription != null) {
                node.approveSubscription(subscription, true);
                continue;
            }
            node.createSubscription(null, owner, subscriber, false, null);
        }
        this.router.route(reply);
    }

    private void getNodeAffiliations(PubSubService service, IQ iq, Element affiliationsElement) {
        String nodeID = affiliationsElement.attributeValue("node");
        if (nodeID == null) {
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (!node.isAdmin(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        node.sendAffiliations(iq);
    }

    private void modifyNodeAffiliations(PubSubService service, IQ iq, Element entitiesElement) {
        NodeAffiliate affiliate;
        String nodeID = entitiesElement.attributeValue("node");
        if (nodeID == null) {
            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            return;
        }
        Node node = service.getNode(nodeID);
        if (node == null) {
            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
            return;
        }
        if (!node.isAdmin(iq.getFrom())) {
            this.sendErrorPacket(iq, PacketError.Condition.forbidden, null);
            return;
        }
        IQ reply = IQ.createResultIQ((IQ)iq);
        ArrayList<JID> invalidAffiliates = new ArrayList<JID>();
        Iterator it = entitiesElement.elementIterator("affiliation");
        while (it.hasNext()) {
            Element affiliation = (Element)it.next();
            JID owner = new JID(affiliation.attributeValue("jid"));
            String newAffiliation = affiliation.attributeValue("affiliation");
            affiliate = node.getAffiliate(owner);
            if (affiliate != null && !affiliate.getAffiliation().name().equals(newAffiliation) && affiliate.getAffiliation() == NodeAffiliate.Affiliation.owner && node.getOwners().size() == 1) {
                invalidAffiliates.add(owner);
                continue;
            }
            if ("owner".equals(newAffiliation)) {
                node.addOwner(owner);
                continue;
            }
            if ("publisher".equals(newAffiliation)) {
                node.addPublisher(owner);
                continue;
            }
            if ("none".equals(newAffiliation)) {
                node.addNoneAffiliation(owner);
                continue;
            }
            node.addOutcast(owner);
        }
        if (!invalidAffiliates.isEmpty()) {
            reply.setError(PacketError.Condition.not_acceptable);
            Element child = reply.setChildElement("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element entities = child.addElement("affiliations");
            if (!node.isRootCollectionNode()) {
                entities.addAttribute("node", node.getNodeID());
            }
            for (JID affiliateJID : invalidAffiliates) {
                affiliate = node.getAffiliate(affiliateJID);
                Element entity = entities.addElement("affiliation");
                entity.addAttribute("jid", affiliate.getJID().toString());
                entity.addAttribute("affiliation", affiliate.getAffiliation().name());
            }
        }
        this.router.route(reply);
    }

    private void cancelAllSubscriptions(PubSubService service, JID user) {
        for (Node node : service.getNodes()) {
            NodeAffiliate affiliate = node.getAffiliate(user);
            if (affiliate == null) continue;
            for (NodeSubscription subscription : affiliate.getSubscriptions()) {
                node.cancelSubscription(subscription);
            }
        }
    }

    private void processAuthorizationAnswer(PubSubService service, DataForm authForm, Message message) {
        NodeSubscription subscription;
        boolean approved;
        String nodeID = (String)authForm.getField("pubsub#node").getValues().get(0);
        String subID = (String)authForm.getField("pubsub#subid").getValues().get(0);
        String allow = (String)authForm.getField("pubsub#allow").getValues().get(0);
        if ("1".equals(allow) || "true".equals(allow)) {
            approved = true;
        } else if ("0".equals(allow) || "false".equals(allow)) {
            approved = false;
        } else {
            Log.warn("Invalid allow value in completed authorization form: " + message.toXML());
            return;
        }
        Node node = service.getNode(nodeID);
        if (node != null && (subscription = node.getSubscription(subID)) != null) {
            node.approveSubscription(subscription, approved);
        }
    }

    void sendErrorPacket(IQ packet, PacketError.Condition error, Element pubsubError) {
        IQ reply = IQ.createResultIQ((IQ)packet);
        reply.setChildElement(packet.getChildElement().createCopy());
        reply.setError(error);
        if (pubsubError != null) {
            reply.getError().getElement().add(pubsubError);
        }
        this.router.route(reply);
    }

    private DataForm getSentConfigurationForm(Element configureElement) {
        String accessModel;
        DataForm completedForm = null;
        Element formElement = configureElement.element(QName.get((String)"x", (String)"jabber:x:data"));
        if (formElement != null) {
            completedForm = new DataForm(formElement);
        }
        if ((accessModel = configureElement.attributeValue("access")) != null) {
            FormField formField;
            if (completedForm == null) {
                completedForm = new DataForm(DataForm.Type.submit);
                formField = completedForm.addField();
                formField.setVariable("FORM_TYPE");
                formField.setType(FormField.Type.hidden);
                formField.addValue((Object)"http://jabber.org/protocol/pubsub#node_config");
            }
            if (completedForm.getField("pubsub#access_model") == null) {
                formField = completedForm.addField();
                formField.setVariable("pubsub#access_model");
                formField.addValue((Object)accessModel);
            } else {
                Log.debug("PubSubEngine: Owner sent access model in data form and as attribute: " + configureElement.asXML());
            }
            List groups = configureElement.elements("group");
            if (!groups.isEmpty()) {
                formField = completedForm.addField();
                formField.setVariable("pubsub#roster_groups_allowed");
                Iterator it = groups.iterator();
                while (it.hasNext()) {
                    formField.addValue((Object)((Element)it.next()).getTextTrim());
                }
            }
        }
        return completedForm;
    }

    public void start(final PubSubService service) {
        if (XMPPServer.getInstance().isStarted()) {
            this.probePresences(service);
        } else {
            XMPPServer.getInstance().addServerListener(new XMPPServerListener(){

                @Override
                public void serverStarted() {
                    PubSubEngine.this.probePresences(service);
                }

                @Override
                public void serverStopping() {
                }
            });
        }
    }

    private void probePresences(PubSubService service) {
        HashSet<JID> affiliates = new HashSet<JID>();
        for (Node node : service.getNodes()) {
            affiliates.addAll(node.getPresenceBasedSubscribers());
        }
        for (JID jid : affiliates) {
            Presence subscription = new Presence(Presence.Type.probe);
            subscription.setTo(jid);
            subscription.setFrom(service.getAddress());
            service.send((Packet)subscription);
        }
    }

    public void shutdown(PubSubService service) {
        PubSubPersistenceManager.shutdown();
        if (service != null) {
            if (service.getManager() != null) {
                service.getManager().stop();
            }
            service.getNodes().clear();
        }
    }

    public static Collection<String> getShowPresences(PubSubService service, JID subscriber) {
        Map<String, String> fullPresences = service.getBarePresences().get(subscriber.toBareJID());
        if (fullPresences == null) {
            return Collections.emptyList();
        }
        if (subscriber.getResource() == null) {
            return fullPresences.values();
        }
        String show = fullPresences.get(subscriber.toString());
        if (show == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(show);
    }

    public static void presenceSubscriptionNotRequired(PubSubService service, Node node, JID user) {
        for (Node hostedNode : service.getNodes()) {
            if (!hostedNode.isPresenceBasedDelivery(user)) continue;
            return;
        }
        Presence subscription = new Presence(Presence.Type.unsubscribe);
        subscription.setTo(user);
        subscription.setFrom(service.getAddress());
        service.send((Packet)subscription);
    }

    public static void presenceSubscriptionRequired(PubSubService service, Node node, JID user) {
        Map<String, String> fullPresences = service.getBarePresences().get(user.toString());
        if (fullPresences == null || fullPresences.isEmpty()) {
            Presence subscription = new Presence(Presence.Type.subscribe);
            subscription.setTo(user);
            subscription.setFrom(service.getAddress());
            service.send((Packet)subscription);
        }
    }

    private boolean isComponent(JID jid) {
        RoutingTable routingTable = XMPPServer.getInstance().getRoutingTable();
        if (routingTable != null) {
            return routingTable.hasComponentRoute(jid);
        }
        return false;
    }

    private class CreateNodeResponse {
        public final PacketError.Condition creationStatus;
        public final Node newNode;
        public final Element pubsubError;

        public CreateNodeResponse(PacketError.Condition creationStatus, Element pubsubError, Node newNode) {
            this.creationStatus = creationStatus;
            this.newNode = newNode;
            this.pubsubError = pubsubError;
        }
    }
}

