/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dom4j.Element;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.DefaultNodeConfiguration;
import org.jivesoftware.openfire.pubsub.NodeAffiliate;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.NotAcceptableException;
import org.jivesoftware.openfire.pubsub.PubSubPersistenceManager;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.openfire.pubsub.PublishedItem;
import org.jivesoftware.openfire.pubsub.cluster.AffiliationTask;
import org.jivesoftware.openfire.pubsub.cluster.CancelSubscriptionTask;
import org.jivesoftware.openfire.pubsub.cluster.ModifySubscriptionTask;
import org.jivesoftware.openfire.pubsub.cluster.NewSubscriptionTask;
import org.jivesoftware.openfire.pubsub.cluster.RemoveNodeTask;
import org.jivesoftware.openfire.pubsub.models.AccessModel;
import org.jivesoftware.openfire.pubsub.models.PublisherModel;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.CacheFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public abstract class Node {
    protected PubSubService service;
    protected CollectionNode parent;
    protected String nodeID;
    protected boolean deliverPayloads;
    protected ItemReplyPolicy replyPolicy;
    protected boolean notifyConfigChanges;
    protected boolean notifyDelete;
    protected boolean notifyRetract;
    protected boolean presenceBasedDelivery;
    protected PublisherModel publisherModel = PublisherModel.open;
    protected boolean subscriptionEnabled;
    protected AccessModel accessModel = AccessModel.open;
    protected Collection<String> rosterGroupsAllowed = new ArrayList<String>();
    protected Collection<JID> replyRooms = new ArrayList<JID>();
    protected Collection<JID> replyTo = new ArrayList<JID>();
    protected String payloadType = "";
    protected String bodyXSLT = "";
    protected String dataformXSLT = "";
    private boolean savedToDB = false;
    protected Date creationDate;
    private Date modificationDate;
    protected JID creator;
    protected String description = "";
    protected String language = "";
    protected Collection<JID> contacts = new ArrayList<JID>();
    protected String name = "";
    protected boolean subscriptionConfigurationRequired = false;
    protected Collection<NodeAffiliate> affiliates = new CopyOnWriteArrayList<NodeAffiliate>();
    protected Map<String, NodeSubscription> subscriptionsByID = new ConcurrentHashMap<String, NodeSubscription>();
    protected Map<String, NodeSubscription> subscriptionsByJID = new ConcurrentHashMap<String, NodeSubscription>();

    Node(PubSubService service, CollectionNode parent, String nodeID, JID creator) {
        this.service = service;
        this.parent = parent;
        this.nodeID = nodeID;
        this.creator = creator;
        long startTime = System.currentTimeMillis();
        this.creationDate = new Date(startTime);
        this.modificationDate = new Date(startTime);
        DefaultNodeConfiguration defaultConfiguration = service.getDefaultNodeConfiguration(!this.isCollectionNode());
        this.subscriptionEnabled = defaultConfiguration.isSubscriptionEnabled();
        this.deliverPayloads = defaultConfiguration.isDeliverPayloads();
        this.notifyConfigChanges = defaultConfiguration.isNotifyConfigChanges();
        this.notifyDelete = defaultConfiguration.isNotifyDelete();
        this.notifyRetract = defaultConfiguration.isNotifyRetract();
        this.presenceBasedDelivery = defaultConfiguration.isPresenceBasedDelivery();
        this.accessModel = defaultConfiguration.getAccessModel();
        this.publisherModel = defaultConfiguration.getPublisherModel();
        this.language = defaultConfiguration.getLanguage();
        this.replyPolicy = defaultConfiguration.getReplyPolicy();
    }

    public NodeAffiliate addOwner(JID jid) {
        NodeAffiliate nodeAffiliate = this.addAffiliation(jid, NodeAffiliate.Affiliation.owner);
        for (NodeSubscription subscription : this.getSubscriptions(jid)) {
            if (!subscription.isAuthorizationPending()) continue;
            subscription.approved();
        }
        return nodeAffiliate;
    }

    public void removeOwner(JID jid) {
        NodeAffiliate affiliate = this.getAffiliate(jid);
        if (affiliate.getSubscriptions().isEmpty()) {
            this.removeAffiliation(jid, NodeAffiliate.Affiliation.owner);
            this.removeSubscriptions(jid);
        } else {
            this.addNoneAffiliation(jid);
        }
    }

    public NodeAffiliate addPublisher(JID jid) {
        return this.addAffiliation(jid, NodeAffiliate.Affiliation.publisher);
    }

    public void removePublisher(JID jid) {
        NodeAffiliate affiliate = this.getAffiliate(jid);
        if (affiliate.getSubscriptions().isEmpty()) {
            this.removeAffiliation(jid, NodeAffiliate.Affiliation.publisher);
            this.removeSubscriptions(jid);
        } else {
            this.addNoneAffiliation(jid);
        }
    }

    public NodeAffiliate addNoneAffiliation(JID jid) {
        return this.addAffiliation(jid, NodeAffiliate.Affiliation.none);
    }

    public NodeAffiliate addOutcast(JID jid) {
        NodeAffiliate nodeAffiliate = this.addAffiliation(jid, NodeAffiliate.Affiliation.outcast);
        this.removeSubscriptions(jid);
        return nodeAffiliate;
    }

    public void removeOutcast(JID jid) {
        this.removeAffiliation(jid, NodeAffiliate.Affiliation.outcast);
    }

    private NodeAffiliate addAffiliation(JID jid, NodeAffiliate.Affiliation affiliation) {
        boolean created = false;
        NodeAffiliate affiliate = this.getAffiliate(jid);
        if (affiliate != null && affiliation == affiliate.getAffiliation()) {
            return affiliate;
        }
        if (affiliate != null) {
            affiliate.setAffiliation(affiliation);
        } else {
            affiliate = new NodeAffiliate(this, jid);
            affiliate.setAffiliation(affiliation);
            this.addAffiliate(affiliate);
            created = true;
        }
        if (this.savedToDB) {
            PubSubPersistenceManager.saveAffiliation(this, affiliate, created);
        }
        CacheFactory.doClusterTask(new AffiliationTask(this, jid, affiliation));
        return affiliate;
    }

    private void removeAffiliation(JID jid, NodeAffiliate.Affiliation affiliation) {
        NodeAffiliate affiliate = this.getAffiliate(jid);
        if (affiliate != null && affiliation == affiliate.getAffiliation()) {
            this.removeAffiliation(affiliate);
        }
    }

    private void removeAffiliation(NodeAffiliate affiliate) {
        this.affiliates.remove(affiliate);
        if (this.savedToDB) {
            PubSubPersistenceManager.removeAffiliation(this, affiliate);
        }
    }

    private void removeSubscriptions(JID owner) {
        for (NodeSubscription subscription : this.getSubscriptions(owner)) {
            this.cancelSubscription(subscription);
        }
    }

    public Collection<NodeSubscription> getSubscriptions(JID owner) {
        ArrayList<NodeSubscription> subscriptions = new ArrayList<NodeSubscription>();
        for (NodeSubscription subscription : this.subscriptionsByID.values()) {
            if (!owner.equals((Object)subscription.getOwner())) continue;
            subscriptions.add(subscription);
        }
        return subscriptions;
    }

    Collection<NodeSubscription> getSubscriptions() {
        return this.subscriptionsByID.values();
    }

    public Collection<NodeSubscription> getAllSubscriptions() {
        if (this.isMultipleSubscriptionsEnabled()) {
            return this.subscriptionsByID.values();
        }
        return this.subscriptionsByJID.values();
    }

    public Collection<NodeAffiliate> getAllAffiliates() {
        return this.affiliates;
    }

    public NodeAffiliate getAffiliate(JID jid) {
        for (NodeAffiliate affiliate : this.affiliates) {
            if (!jid.equals((Object)affiliate.getJID())) continue;
            return affiliate;
        }
        return null;
    }

    public Collection<JID> getOwners() {
        ArrayList<JID> jids = new ArrayList<JID>();
        for (NodeAffiliate affiliate : this.affiliates) {
            if (NodeAffiliate.Affiliation.owner != affiliate.getAffiliation()) continue;
            jids.add(affiliate.getJID());
        }
        return jids;
    }

    public Collection<JID> getPublishers() {
        ArrayList<JID> jids = new ArrayList<JID>();
        for (NodeAffiliate affiliate : this.affiliates) {
            if (NodeAffiliate.Affiliation.publisher != affiliate.getAffiliation()) continue;
            jids.add(affiliate.getJID());
        }
        return jids;
    }

    public void configure(DataForm completedForm) throws NotAcceptableException {
        boolean wasPresenceBased = this.isPresenceBasedDelivery();
        if (!DataForm.Type.cancel.equals((Object)completedForm.getType()) && DataForm.Type.submit.equals((Object)completedForm.getType())) {
            FormField publisherField;
            FormField ownerField = completedForm.getField("pubsub#owner");
            boolean ownersSent = ownerField != null;
            ArrayList<JID> owners = new ArrayList<JID>();
            if (ownersSent) {
                for (String value : ownerField.getValues()) {
                    try {
                        owners.add(new JID(value));
                    }
                    catch (Exception exception) {}
                }
            }
            if (ownersSent && owners.isEmpty()) {
                throw new NotAcceptableException();
            }
            for (Object field : completedForm.getFields()) {
                String booleanValue;
                List values;
                if ("FORM_TYPE".equals(field.getVariable())) continue;
                if ("pubsub#deliver_payloads".equals(field.getVariable())) {
                    values = field.getValues();
                    booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                    this.deliverPayloads = "1".equals(booleanValue);
                    continue;
                }
                if ("pubsub#notify_config".equals(field.getVariable())) {
                    values = field.getValues();
                    booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                    this.notifyConfigChanges = "1".equals(booleanValue);
                    continue;
                }
                if ("pubsub#notify_delete".equals(field.getVariable())) {
                    values = field.getValues();
                    booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                    this.notifyDelete = "1".equals(booleanValue);
                    continue;
                }
                if ("pubsub#notify_retract".equals(field.getVariable())) {
                    values = field.getValues();
                    booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                    this.notifyRetract = "1".equals(booleanValue);
                    continue;
                }
                if ("pubsub#presence_based_delivery".equals(field.getVariable())) {
                    values = field.getValues();
                    booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                    this.presenceBasedDelivery = "1".equals(booleanValue);
                    continue;
                }
                if ("pubsub#subscribe".equals(field.getVariable())) {
                    values = field.getValues();
                    booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                    this.subscriptionEnabled = "1".equals(booleanValue);
                    continue;
                }
                if ("pubsub#subscription_required".equals(field.getVariable())) {
                    values = field.getValues();
                    booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                    this.subscriptionConfigurationRequired = "1".equals(booleanValue);
                    continue;
                }
                if ("pubsub#type".equals(field.getVariable())) {
                    values = field.getValues();
                    this.payloadType = values.size() > 0 ? (String)values.get(0) : " ";
                    continue;
                }
                if ("pubsub#body_xslt".equals(field.getVariable())) {
                    values = field.getValues();
                    this.bodyXSLT = values.size() > 0 ? (String)values.get(0) : " ";
                    continue;
                }
                if ("pubsub#dataform_xslt".equals(field.getVariable())) {
                    values = field.getValues();
                    this.dataformXSLT = values.size() > 0 ? (String)values.get(0) : " ";
                    continue;
                }
                if ("pubsub#access_model".equals(field.getVariable())) {
                    values = field.getValues();
                    if (values.size() <= 0) continue;
                    this.accessModel = AccessModel.valueOf((String)values.get(0));
                    continue;
                }
                if ("pubsub#publish_model".equals(field.getVariable())) {
                    values = field.getValues();
                    if (values.size() <= 0) continue;
                    this.publisherModel = PublisherModel.valueOf((String)values.get(0));
                    continue;
                }
                if ("pubsub#roster_groups_allowed".equals(field.getVariable())) {
                    this.rosterGroupsAllowed = new ArrayList<String>();
                    for (String value : field.getValues()) {
                        this.addAllowedRosterGroup(value);
                    }
                    continue;
                }
                if ("pubsub#contact".equals(field.getVariable())) {
                    this.contacts = new ArrayList<JID>();
                    for (String value : field.getValues()) {
                        try {
                            this.addContact(new JID(value));
                        }
                        catch (Exception exception) {}
                    }
                    continue;
                }
                if ("pubsub#description".equals(field.getVariable())) {
                    values = field.getValues();
                    this.description = values.size() > 0 ? (String)values.get(0) : " ";
                    continue;
                }
                if ("pubsub#language".equals(field.getVariable())) {
                    values = field.getValues();
                    this.language = values.size() > 0 ? (String)values.get(0) : " ";
                    continue;
                }
                if ("pubsub#title".equals(field.getVariable())) {
                    values = field.getValues();
                    this.name = values.size() > 0 ? (String)values.get(0) : " ";
                    continue;
                }
                if ("pubsub#itemreply".equals(field.getVariable())) {
                    values = field.getValues();
                    if (values.size() <= 0) continue;
                    this.replyPolicy = ItemReplyPolicy.valueOf((String)values.get(0));
                    continue;
                }
                if ("pubsub#replyroom".equals(field.getVariable())) {
                    this.replyRooms = new ArrayList<JID>();
                    for (String value : field.getValues()) {
                        try {
                            this.addReplyRoom(new JID(value));
                        }
                        catch (Exception exception) {}
                    }
                    continue;
                }
                if ("pubsub#replyto".equals(field.getVariable())) {
                    this.replyTo = new ArrayList<JID>();
                    for (String value : field.getValues()) {
                        try {
                            this.addReplyTo(new JID(value));
                        }
                        catch (Exception exception) {}
                    }
                    continue;
                }
                if ("pubsub#collection".equals(field.getVariable())) {
                    values = field.getValues();
                    String newParent = values.size() > 0 ? (String)values.get(0) : " ";
                    Node newParentNode = this.service.getNode(newParent);
                    if (!(newParentNode instanceof CollectionNode)) {
                        throw new NotAcceptableException("Specified node in field pubsub#collection [" + newParent + "] " + (newParentNode == null ? "does not exist" : "is not a collection node"));
                    }
                    this.changeParent((CollectionNode)newParentNode);
                    continue;
                }
                this.configure((FormField)field);
            }
            if (ownersSent) {
                Collection<JID> oldOwners = this.getOwners();
                oldOwners.removeAll(owners);
                for (JID jid : oldOwners) {
                    this.removeOwner(jid);
                }
                owners.removeAll(this.getOwners());
                for (JID jid : owners) {
                    this.addOwner(jid);
                }
            }
            if ((publisherField = completedForm.getField("pubsub#publisher")) != null) {
                ArrayList<JID> publishers = new ArrayList<JID>();
                for (String value : publisherField.getValues()) {
                    try {
                        publishers.add(new JID(value));
                    }
                    catch (Exception exception) {}
                }
                Collection<JID> oldPublishers = this.getPublishers();
                oldPublishers.removeAll(publishers);
                for (JID jid : oldPublishers) {
                    this.removePublisher(jid);
                }
                publishers.removeAll(this.getPublishers());
                for (JID jid : publishers) {
                    this.addPublisher(jid);
                }
            }
            this.postConfigure(completedForm);
            this.modificationDate = new Date();
            this.nodeConfigurationChanged();
        }
        this.saveToDB();
        if (wasPresenceBased != this.isPresenceBasedDelivery()) {
            if (this.isPresenceBasedDelivery()) {
                this.addPresenceSubscriptions();
            } else {
                this.cancelPresenceSubscriptions();
            }
        }
    }

    protected abstract void configure(FormField var1) throws NotAcceptableException;

    abstract void postConfigure(DataForm var1);

    private void nodeConfigurationChanged() {
        if (!this.isNotifiedOfConfigChanges() || !this.savedToDB) {
            return;
        }
        Message message = new Message();
        Element event = message.addChildElement("event", "http://jabber.org/protocol/pubsub#event");
        Element config = event.addElement("configuration");
        config.addAttribute("node", this.nodeID);
        if (this.deliverPayloads) {
            config.add(this.getConfigurationChangeForm().getElement());
        }
        this.broadcastNodeEvent(message, false);
    }

    DataForm getAuthRequestForm(NodeSubscription subscription) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle(LocaleUtils.getLocalizedString("pubsub.form.authorization.title"));
        form.addInstruction(LocaleUtils.getLocalizedString("pubsub.form.authorization.instruction"));
        FormField formField = form.addField();
        formField.setVariable("FORM_TYPE");
        formField.setType(FormField.Type.hidden);
        formField.addValue((Object)"http://jabber.org/protocol/pubsub#subscribe_authorization");
        formField = form.addField();
        formField.setVariable("pubsub#subid");
        formField.setType(FormField.Type.hidden);
        formField.addValue((Object)subscription.getID());
        formField = form.addField();
        formField.setVariable("pubsub#node");
        formField.setType(FormField.Type.text_single);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.authorization.node"));
        formField.addValue((Object)this.getNodeID());
        formField = form.addField();
        formField.setVariable("pubsub#subscriber_jid");
        formField.setType(FormField.Type.jid_single);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.authorization.subscriber"));
        formField.addValue((Object)subscription.getJID().toString());
        formField = form.addField();
        formField.setVariable("pubsub#allow");
        formField.setType(FormField.Type.boolean_type);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.authorization.allow"));
        formField.addValue((Object)Boolean.FALSE);
        return form;
    }

    public DataForm getConfigurationForm() {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle(LocaleUtils.getLocalizedString("pubsub.form.conf.title"));
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.getNodeID());
        form.addInstruction(LocaleUtils.getLocalizedString("pubsub.form.conf.instruction", params));
        FormField formField = form.addField();
        formField.setVariable("FORM_TYPE");
        formField.setType(FormField.Type.hidden);
        formField.addValue((Object)"http://jabber.org/protocol/pubsub#node_config");
        this.addFormFields(form, true);
        return form;
    }

    protected void addFormFields(DataForm form, boolean isEditing) {
        FormField formField = form.addField();
        formField.setVariable("pubsub#title");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.short_name"));
        }
        formField.addValue((Object)this.name);
        formField = form.addField();
        formField.setVariable("pubsub#description");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.description"));
        }
        formField.addValue((Object)this.description);
        formField = form.addField();
        formField.setVariable("pubsub#node_type");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.node_type"));
        }
        formField = form.addField();
        formField.setVariable("pubsub#collection");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.collection"));
        }
        if (this.parent != null && !this.parent.isRootCollectionNode()) {
            formField.addValue((Object)this.parent.getNodeID());
        }
        formField = form.addField();
        formField.setVariable("pubsub#subscribe");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.subscribe"));
        }
        formField.addValue((Object)this.subscriptionEnabled);
        formField = form.addField();
        formField.setVariable("pubsub#subscription_required");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.subscription_required"));
        }
        formField.addValue((Object)this.subscriptionConfigurationRequired);
        formField = form.addField();
        formField.setVariable("pubsub#deliver_payloads");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.deliver_payloads"));
        }
        formField.addValue((Object)this.deliverPayloads);
        formField = form.addField();
        formField.setVariable("pubsub#notify_config");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.notify_config"));
        }
        formField.addValue((Object)this.notifyConfigChanges);
        formField = form.addField();
        formField.setVariable("pubsub#notify_delete");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.notify_delete"));
        }
        formField.addValue((Object)this.notifyDelete);
        formField = form.addField();
        formField.setVariable("pubsub#notify_retract");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.notify_retract"));
        }
        formField.addValue((Object)this.notifyRetract);
        formField = form.addField();
        formField.setVariable("pubsub#presence_based_delivery");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.presence_based"));
        }
        formField.addValue((Object)this.presenceBasedDelivery);
        formField = form.addField();
        formField.setVariable("pubsub#type");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.type"));
        }
        formField.addValue((Object)this.payloadType);
        formField = form.addField();
        formField.setVariable("pubsub#body_xslt");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.body_xslt"));
        }
        formField.addValue((Object)this.bodyXSLT);
        formField = form.addField();
        formField.setVariable("pubsub#dataform_xslt");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.dataform_xslt"));
        }
        formField.addValue((Object)this.dataformXSLT);
        formField = form.addField();
        formField.setVariable("pubsub#access_model");
        if (isEditing) {
            formField.setType(FormField.Type.list_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.access_model"));
            formField.addOption(null, AccessModel.authorize.getName());
            formField.addOption(null, AccessModel.open.getName());
            formField.addOption(null, AccessModel.presence.getName());
            formField.addOption(null, AccessModel.roster.getName());
            formField.addOption(null, AccessModel.whitelist.getName());
        }
        formField.addValue((Object)this.accessModel.getName());
        formField = form.addField();
        formField.setVariable("pubsub#publish_model");
        if (isEditing) {
            formField.setType(FormField.Type.list_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.publish_model"));
            formField.addOption(null, PublisherModel.publishers.getName());
            formField.addOption(null, PublisherModel.subscribers.getName());
            formField.addOption(null, PublisherModel.open.getName());
        }
        formField.addValue((Object)this.publisherModel.getName());
        formField = form.addField();
        formField.setVariable("pubsub#roster_groups_allowed");
        if (isEditing) {
            formField.setType(FormField.Type.list_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.roster_allowed"));
        }
        for (String group : this.rosterGroupsAllowed) {
            formField.addValue((Object)group);
        }
        formField = form.addField();
        formField.setVariable("pubsub#contact");
        if (isEditing) {
            formField.setType(FormField.Type.jid_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.contact"));
        }
        for (JID contact : this.contacts) {
            formField.addValue((Object)contact.toString());
        }
        formField = form.addField();
        formField.setVariable("pubsub#language");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.language"));
        }
        formField.addValue((Object)this.language);
        formField = form.addField();
        formField.setVariable("pubsub#owner");
        if (isEditing) {
            formField.setType(FormField.Type.jid_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.owner"));
        }
        for (JID owner : this.getOwners()) {
            formField.addValue((Object)owner.toString());
        }
        formField = form.addField();
        formField.setVariable("pubsub#publisher");
        if (isEditing) {
            formField.setType(FormField.Type.jid_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.publisher"));
        }
        for (JID owner : this.getPublishers()) {
            formField.addValue((Object)owner.toString());
        }
        formField = form.addField();
        formField.setVariable("pubsub#itemreply");
        if (isEditing) {
            formField.setType(FormField.Type.list_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.itemreply"));
            formField.addOption(null, ItemReplyPolicy.owner.name());
            formField.addOption(null, ItemReplyPolicy.publisher.name());
        }
        if (this.replyPolicy != null) {
            formField.addValue((Object)this.replyPolicy.name());
        }
        formField = form.addField();
        formField.setVariable("pubsub#replyroom");
        if (isEditing) {
            formField.setType(FormField.Type.jid_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.replyroom"));
        }
        for (JID owner : this.getReplyRooms()) {
            formField.addValue((Object)owner.toString());
        }
        formField = form.addField();
        formField.setVariable("pubsub#replyto");
        if (isEditing) {
            formField.setType(FormField.Type.jid_multi);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.replyto"));
        }
        for (JID owner : this.getReplyTo()) {
            formField.addValue((Object)owner.toString());
        }
    }

    private DataForm getConfigurationChangeForm() {
        DataForm form = new DataForm(DataForm.Type.result);
        FormField formField = form.addField();
        formField.setVariable("FORM_TYPE");
        formField.setType(FormField.Type.hidden);
        formField.addValue((Object)"http://jabber.org/protocol/pubsub#node_config");
        this.addFormFields(form, false);
        return form;
    }

    public DataForm getMetadataForm() {
        DataForm form = new DataForm(DataForm.Type.result);
        FormField formField = form.addField();
        formField.setVariable("FORM_TYPE");
        formField.setType(FormField.Type.hidden);
        formField.addValue((Object)"http://jabber.org/protocol/pubsub#meta-data");
        this.addFormFields(form, true);
        return form;
    }

    public boolean isRootCollectionNode() {
        return this.service.getRootCollectionNode() == this;
    }

    public boolean isMultipleSubscriptionsEnabled() {
        return this.service.isMultipleSubscriptionsEnabled();
    }

    public boolean isCollectionNode() {
        return false;
    }

    public boolean isChildNode(Node child) {
        return false;
    }

    public boolean isDescendantNode(Node child) {
        return false;
    }

    public boolean isAdmin(JID user) {
        if (this.getOwners().contains(user) || this.service.isServiceAdmin(user)) {
            return true;
        }
        if (user.getResource() != null) {
            user = user.asBareJID();
            return this.isAdmin(user);
        }
        return false;
    }

    public PubSubService getService() {
        return this.service;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPayloadDelivered() {
        return this.deliverPayloads;
    }

    public ItemReplyPolicy getReplyPolicy() {
        return this.replyPolicy;
    }

    public boolean isNotifiedOfConfigChanges() {
        return this.notifyConfigChanges;
    }

    public boolean isNotifiedOfDelete() {
        return this.notifyDelete;
    }

    public boolean isNotifiedOfRetract() {
        return this.notifyRetract;
    }

    public boolean isPresenceBasedDelivery() {
        return this.presenceBasedDelivery;
    }

    public boolean isPresenceBasedDelivery(JID user) {
        Collection<NodeSubscription> subscriptions = this.getSubscriptions(user);
        if (!subscriptions.isEmpty()) {
            if (this.presenceBasedDelivery) {
                return true;
            }
            for (NodeSubscription subscription : subscriptions) {
                if (subscription.getPresenceStates().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    Collection<JID> getPresenceBasedSubscribers() {
        ArrayList<JID> affiliatesJID = new ArrayList<JID>();
        if (this.presenceBasedDelivery) {
            for (NodeAffiliate affiliate : this.affiliates) {
                if (affiliate.getSubscriptions().isEmpty()) continue;
                affiliatesJID.add(affiliate.getJID());
            }
        } else {
            block1: for (NodeAffiliate affiliate : this.affiliates) {
                Collection<NodeSubscription> subscriptions = affiliate.getSubscriptions();
                for (NodeSubscription subscription : subscriptions) {
                    if (subscription.getPresenceStates().isEmpty()) continue;
                    affiliatesJID.add(affiliate.getJID());
                    continue block1;
                }
            }
        }
        return affiliatesJID;
    }

    public boolean isSendItemSubscribe() {
        return false;
    }

    public PublisherModel getPublisherModel() {
        return this.publisherModel;
    }

    public boolean isSubscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    public boolean isSubscriptionConfigurationRequired() {
        return this.subscriptionConfigurationRequired;
    }

    public AccessModel getAccessModel() {
        return this.accessModel;
    }

    public Collection<String> getRosterGroupsAllowed() {
        return Collections.unmodifiableCollection(this.rosterGroupsAllowed);
    }

    void addAllowedRosterGroup(String groupName) {
        this.rosterGroupsAllowed.add(groupName);
    }

    public Collection<JID> getReplyRooms() {
        return Collections.unmodifiableCollection(this.replyRooms);
    }

    void addReplyRoom(JID roomJID) {
        this.replyRooms.add(roomJID);
    }

    public Collection<JID> getReplyTo() {
        return Collections.unmodifiableCollection(this.replyTo);
    }

    void addReplyTo(JID entity) {
        this.replyTo.add(entity);
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public String getBodyXSLT() {
        return this.bodyXSLT;
    }

    public String getDataformXSLT() {
        return this.dataformXSLT;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public JID getCreator() {
        return this.creator;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLanguage() {
        return this.language;
    }

    public Collection<JID> getContacts() {
        return Collections.unmodifiableCollection(this.contacts);
    }

    void addContact(JID user) {
        this.contacts.add(user);
    }

    public Collection<Node> getNodes() {
        return Collections.emptyList();
    }

    public CollectionNode getParent() {
        return this.parent;
    }

    public Collection<CollectionNode> getParents() {
        ArrayList<CollectionNode> parents = new ArrayList<CollectionNode>();
        for (CollectionNode myParent = this.parent; myParent != null; myParent = myParent.getParent()) {
            parents.add(myParent);
        }
        return parents;
    }

    void setPayloadDelivered(boolean deliverPayloads) {
        this.deliverPayloads = deliverPayloads;
    }

    void setReplyPolicy(ItemReplyPolicy replyPolicy) {
        this.replyPolicy = replyPolicy;
    }

    void setNotifiedOfConfigChanges(boolean notifyConfigChanges) {
        this.notifyConfigChanges = notifyConfigChanges;
    }

    void setNotifiedOfDelete(boolean notifyDelete) {
        this.notifyDelete = notifyDelete;
    }

    void setNotifiedOfRetract(boolean notifyRetract) {
        this.notifyRetract = notifyRetract;
    }

    void setPresenceBasedDelivery(boolean presenceBasedDelivery) {
        this.presenceBasedDelivery = presenceBasedDelivery;
    }

    void setPublisherModel(PublisherModel publisherModel) {
        this.publisherModel = publisherModel;
    }

    void setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    void setSubscriptionConfigurationRequired(boolean subscriptionConfigurationRequired) {
        this.subscriptionConfigurationRequired = subscriptionConfigurationRequired;
    }

    void setAccessModel(AccessModel accessModel) {
        this.accessModel = accessModel;
    }

    void setRosterGroupsAllowed(Collection<String> rosterGroupsAllowed) {
        this.rosterGroupsAllowed = rosterGroupsAllowed;
    }

    void setReplyRooms(Collection<JID> replyRooms) {
        this.replyRooms = replyRooms;
    }

    void setReplyTo(Collection<JID> replyTo) {
        this.replyTo = replyTo;
    }

    void setPayloadType(String payloadType) {
        this.payloadType = payloadType;
    }

    void setBodyXSLT(String bodyXSLT) {
        this.bodyXSLT = bodyXSLT;
    }

    void setDataformXSLT(String dataformXSLT) {
        this.dataformXSLT = dataformXSLT;
    }

    void setSavedToDB(boolean savedToDB) {
        this.savedToDB = savedToDB;
        if (savedToDB && this.parent != null) {
            this.parent.addChildNode(this);
        }
    }

    void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setLanguage(String language) {
        this.language = language;
    }

    void setName(String name) {
        this.name = name;
    }

    void setContacts(Collection<JID> contacts) {
        this.contacts = contacts;
    }

    public void saveToDB() {
        if (!this.savedToDB) {
            PubSubPersistenceManager.createNode(this);
            this.setSavedToDB(true);
            for (NodeAffiliate affialiate : this.affiliates) {
                PubSubPersistenceManager.saveAffiliation(this, affialiate, true);
            }
            for (NodeSubscription subscription : this.subscriptionsByID.values()) {
                PubSubPersistenceManager.saveSubscription(this, subscription, true);
            }
            this.service.addNode(this);
            if (this.parent != null) {
                this.parent.childNodeAdded(this);
            }
        } else {
            PubSubPersistenceManager.updateNode(this);
        }
    }

    public void addAffiliate(NodeAffiliate affiliate) {
        this.affiliates.add(affiliate);
    }

    public void addSubscription(NodeSubscription subscription) {
        this.subscriptionsByID.put(subscription.getID(), subscription);
        this.subscriptionsByJID.put(subscription.getJID().toString(), subscription);
    }

    public NodeSubscription getSubscription(JID subscriberJID) {
        if (this.isMultipleSubscriptionsEnabled() && this.getSubscriptions(subscriberJID).size() > 1) {
            throw new IllegalStateException("Multiple subscriptions is enabled so subscriptions should be retrieved using subID.");
        }
        return this.subscriptionsByJID.get(subscriberJID.toString());
    }

    public NodeSubscription getSubscription(String subscriptionID) {
        return this.subscriptionsByID.get(subscriptionID);
    }

    public boolean delete() {
        if (PubSubPersistenceManager.removeNode(this)) {
            if (this.parent != null) {
                this.parent.removeChildNode(this);
            }
            this.deletingNode();
            if (this.isNotifiedOfDelete()) {
                Message message = new Message();
                Element event = message.addChildElement("event", "http://jabber.org/protocol/pubsub#event");
                Element items = event.addElement("delete");
                items.addAttribute("node", this.nodeID);
                this.broadcastNodeEvent(message, true);
            }
            if (this.parent != null) {
                this.parent.childNodeDeleted(this);
            }
            this.cancelPresenceSubscriptions();
            this.service.removeNode(this.getNodeID());
            CacheFactory.doClusterTask(new RemoveNodeTask(this));
            this.affiliates.clear();
            this.subscriptionsByID.clear();
            this.subscriptionsByJID.clear();
            return true;
        }
        return false;
    }

    protected abstract void deletingNode();

    protected void changeParent(CollectionNode newParent) {
        if (this.parent == newParent) {
            return;
        }
        if (this.parent != null) {
            this.parent.removeChildNode(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.addChildNode(this);
        }
        if (this.savedToDB) {
            PubSubPersistenceManager.updateNode(this);
        }
    }

    private void addPresenceSubscriptions() {
        for (NodeAffiliate affiliate : this.affiliates) {
            if (affiliate.getAffiliation() == NodeAffiliate.Affiliation.outcast || !this.isPresenceBasedDelivery() && affiliate.getSubscriptions().isEmpty()) continue;
            this.service.presenceSubscriptionRequired(this, affiliate.getJID());
        }
    }

    private void cancelPresenceSubscriptions() {
        for (NodeSubscription subscription : this.getSubscriptions()) {
            if (!this.isPresenceBasedDelivery() && subscription.getPresenceStates().isEmpty()) continue;
            this.service.presenceSubscriptionNotRequired(this, subscription.getOwner());
        }
    }

    void sendAffiliations(IQ iqRequest) {
        IQ reply = IQ.createResultIQ((IQ)iqRequest);
        Element childElement = iqRequest.getChildElement().createCopy();
        reply.setChildElement(childElement);
        Element affiliations = childElement.element("affiliations");
        for (NodeAffiliate affiliate : this.affiliates) {
            if (affiliate.getAffiliation() == NodeAffiliate.Affiliation.none) continue;
            Element entity = affiliations.addElement("affiliation");
            entity.addAttribute("jid", affiliate.getJID().toString());
            entity.addAttribute("affiliation", affiliate.getAffiliation().name());
        }
        this.service.send((Packet)reply);
    }

    void sendSubscriptions(IQ iqRequest) {
        IQ reply = IQ.createResultIQ((IQ)iqRequest);
        Element childElement = iqRequest.getChildElement().createCopy();
        reply.setChildElement(childElement);
        Element subscriptions = childElement.element("subscriptions");
        for (NodeAffiliate affiliate : this.affiliates) {
            for (NodeSubscription subscription : affiliate.getSubscriptions()) {
                if (subscription.isAuthorizationPending()) continue;
                Element entity = subscriptions.addElement("subscription");
                entity.addAttribute("jid", subscription.getJID().toString());
                entity.addAttribute("subscription", subscription.getState().name());
                if (!this.isMultipleSubscriptionsEnabled()) continue;
                entity.addAttribute("subid", subscription.getID());
            }
        }
        this.service.send((Packet)reply);
    }

    protected void broadcastNodeEvent(Message message, boolean includeAll) {
        ArrayList<JID> jids = new ArrayList<JID>();
        for (NodeSubscription subscription : this.subscriptionsByID.values()) {
            if (!includeAll && !subscription.canSendNodeEvents()) continue;
            jids.add(subscription.getJID());
        }
        this.service.broadcast(this, message, jids);
    }

    protected void sendEventNotification(JID subscriberJID, Message notification, Collection<String> subIDs) {
        Element headers = null;
        if (subIDs != null) {
            headers = notification.addChildElement("headers", "http://jabber.org/protocol/shim");
            for (String subID : subIDs) {
                Element header = headers.addElement("header");
                header.addAttribute("name", "SubID");
                header.setText(subID);
            }
        }
        if (subscriberJID.getResource() == null || SessionManager.getInstance().getSession(subscriberJID) != null) {
            this.service.sendNotification(this, notification, subscriberJID);
        }
        if (headers != null) {
            notification.getElement().remove(headers);
        }
    }

    public void createSubscription(IQ originalIQ, JID owner, JID subscriber, boolean authorizationRequired, DataForm options) {
        PublishedItem lastItem;
        if (this.getAffiliate(owner) == null) {
            this.addNoneAffiliation(owner);
        }
        NodeSubscription.State subState = NodeSubscription.State.subscribed;
        if (this.isSubscriptionConfigurationRequired()) {
            subState = NodeSubscription.State.unconfigured;
        } else if (authorizationRequired && !this.isAdmin(owner)) {
            subState = NodeSubscription.State.pending;
        }
        String id = StringUtils.randomString(40);
        NodeSubscription subscription = new NodeSubscription(this, owner, subscriber, subState, id);
        if (options != null) {
            subscription.configure(options);
        }
        this.addSubscription(subscription);
        if (this.savedToDB) {
            PubSubPersistenceManager.saveSubscription(this, subscription, true);
        }
        if (originalIQ != null) {
            subscription.sendSubscriptionState(originalIQ);
        }
        if (subscription.isAuthorizationPending()) {
            subscription.sendAuthorizationRequest();
        }
        CacheFactory.doClusterTask(new NewSubscriptionTask(subscription));
        if (this.isSendItemSubscribe() && subscription.isActive() && (lastItem = this.getLastPublishedItem()) != null) {
            subscription.sendLastPublishedItem(lastItem);
        }
        if (this.isPresenceBasedDelivery() && this.getSubscriptions(subscription.getOwner()).size() == 1 && subscription.getPresenceStates().isEmpty()) {
            this.service.presenceSubscriptionRequired(this, owner);
        }
    }

    public void cancelSubscription(NodeSubscription subscription, boolean sendToCluster) {
        this.subscriptionsByID.remove(subscription.getID());
        this.subscriptionsByJID.remove(subscription.getJID().toString());
        NodeAffiliate affiliate = subscription.getAffiliate();
        if (affiliate != null && affiliate.getAffiliation() == NodeAffiliate.Affiliation.none && this.getSubscriptions(subscription.getOwner()).isEmpty()) {
            this.removeAffiliation(affiliate);
        }
        if (this.savedToDB) {
            PubSubPersistenceManager.removeSubscription(subscription);
        }
        if (sendToCluster) {
            CacheFactory.doClusterTask(new CancelSubscriptionTask(subscription));
        }
        if (this.isPresenceBasedDelivery() && this.getSubscriptions(subscription.getOwner()).isEmpty()) {
            this.service.presenceSubscriptionNotRequired(this, subscription.getOwner());
        }
    }

    public void cancelSubscription(NodeSubscription subscription) {
        this.cancelSubscription(subscription, ClusterManager.isClusteringEnabled());
    }

    public PublishedItem getPublishedItem(String itemID) {
        return null;
    }

    public List<PublishedItem> getPublishedItems() {
        return Collections.emptyList();
    }

    public List<PublishedItem> getPublishedItems(int recentItems) {
        return Collections.emptyList();
    }

    public Collection<NodeSubscription> getPendingSubscriptions() {
        if (this.accessModel.isAuthorizationRequired()) {
            ArrayList<NodeSubscription> pendingSubscriptions = new ArrayList<NodeSubscription>();
            for (NodeSubscription subscription : this.subscriptionsByID.values()) {
                if (!subscription.isAuthorizationPending()) continue;
                pendingSubscriptions.add(subscription);
            }
            return pendingSubscriptions;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return super.toString() + " - ID: " + this.getNodeID();
    }

    public PublishedItem getLastPublishedItem() {
        return null;
    }

    public void approveSubscription(NodeSubscription subscription, boolean approved) {
        if (!subscription.isAuthorizationPending()) {
            return;
        }
        if (approved) {
            subscription.approved();
            CacheFactory.doClusterTask(new ModifySubscriptionTask(subscription));
        } else {
            this.cancelSubscription(subscription);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nodeID.hashCode();
        result = 31 * result + this.service.getServiceID().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node compareNode = (Node)obj;
        return this.service.getServiceID().equals(compareNode.service.getServiceID()) && this.nodeID.equals(compareNode.nodeID);
    }

    public static enum ItemReplyPolicy {
        owner,
        publisher;

    }
}

