/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.dom4j.Element;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.DefaultNodeConfiguration;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeAffiliate;
import org.jivesoftware.openfire.pubsub.NodeSubscription;
import org.jivesoftware.openfire.pubsub.NotAcceptableException;
import org.jivesoftware.openfire.pubsub.PubSubPersistenceManager;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.openfire.pubsub.PublishedItem;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.cache.CacheFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class LeafNode
extends Node {
    private static final String genIdSeed = UUID.randomUUID().toString();
    private static final AtomicLong sequenceCounter = new AtomicLong();
    private boolean persistPublishedItems;
    private int maxPublishedItems;
    private int maxPayloadSize;
    private boolean sendItemSubscribe;
    private PublishedItem lastPublished;

    public LeafNode(PubSubService service, CollectionNode parentNode, String nodeID, JID creator) {
        super(service, parentNode, nodeID, creator);
        DefaultNodeConfiguration defaultConfiguration = service.getDefaultNodeConfiguration(true);
        this.persistPublishedItems = defaultConfiguration.isPersistPublishedItems();
        this.maxPublishedItems = defaultConfiguration.getMaxPublishedItems();
        this.maxPayloadSize = defaultConfiguration.getMaxPayloadSize();
        this.sendItemSubscribe = defaultConfiguration.isSendItemSubscribe();
    }

    @Override
    protected void configure(FormField field) throws NotAcceptableException {
        if ("pubsub#persist_items".equals(field.getVariable())) {
            List values = field.getValues();
            String booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
            this.persistPublishedItems = "1".equals(booleanValue);
        } else if ("pubsub#max_payload_size".equals(field.getVariable())) {
            List values = field.getValues();
            this.maxPayloadSize = values.size() > 0 ? Integer.parseInt((String)values.get(0)) : 5120;
        } else if ("pubsub#send_item_subscribe".equals(field.getVariable())) {
            List values = field.getValues();
            String booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
            this.sendItemSubscribe = "1".equals(booleanValue);
        }
    }

    @Override
    void postConfigure(DataForm completedForm) {
        if (!this.persistPublishedItems) {
            this.maxPublishedItems = 1;
        } else {
            FormField field = completedForm.getField("pubsub#max_items");
            if (field != null) {
                List values = field.getValues();
                this.maxPublishedItems = values.size() > 0 ? Integer.parseInt((String)values.get(0)) : 50;
            }
        }
    }

    @Override
    protected void addFormFields(DataForm form, boolean isEditing) {
        super.addFormFields(form, isEditing);
        FormField typeField = form.getField("pubsub#node_type");
        typeField.addValue((Object)"leaf");
        FormField formField = form.addField();
        formField.setVariable("pubsub#send_item_subscribe");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.send_item_subscribe"));
        }
        formField.addValue((Object)this.sendItemSubscribe);
        formField = form.addField();
        formField.setVariable("pubsub#persist_items");
        if (isEditing) {
            formField.setType(FormField.Type.boolean_type);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.persist_items"));
        }
        formField.addValue((Object)this.persistPublishedItems);
        formField = form.addField();
        formField.setVariable("pubsub#max_items");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.max_items"));
        }
        formField.addValue((Object)this.maxPublishedItems);
        formField = form.addField();
        formField.setVariable("pubsub#max_payload_size");
        if (isEditing) {
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.conf.max_payload_size"));
        }
        formField.addValue((Object)this.maxPayloadSize);
    }

    @Override
    protected void deletingNode() {
    }

    public synchronized void setLastPublishedItem(PublishedItem item) {
        if (this.lastPublished == null || item != null && item.getCreationDate().after(this.lastPublished.getCreationDate())) {
            this.lastPublished = item;
        }
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isPersistPublishedItems() {
        return this.persistPublishedItems;
    }

    public int getMaxPublishedItems() {
        return this.maxPublishedItems;
    }

    public boolean isItemRequired() {
        return this.isPersistPublishedItems() || this.isPayloadDelivered();
    }

    public void publishItems(JID publisher, List<Element> itemElements) {
        ArrayList<PublishedItem> newPublishedItems = new ArrayList<PublishedItem>();
        if (this.isItemRequired()) {
            for (Element item : itemElements) {
                Element payload;
                String itemID = item.attributeValue("id");
                List entries = item.elements();
                Element element = payload = entries.isEmpty() ? null : (Element)entries.get(0);
                if (itemID == null) {
                    itemID = genIdSeed + sequenceCounter.getAndIncrement();
                }
                PublishedItem newItem = new PublishedItem(this, publisher, itemID, new Date(CacheFactory.getClusterTime()));
                newItem.setPayload(payload);
                newPublishedItems.add(newItem);
                this.setLastPublishedItem(newItem);
                if (!this.isPersistPublishedItems()) continue;
                PubSubPersistenceManager.savePublishedItem(newItem);
            }
        }
        Message message = new Message();
        Element event = message.addChildElement("event", "http://jabber.org/protocol/pubsub#event");
        HashSet<NodeAffiliate> affiliatesToNotify = new HashSet<NodeAffiliate>(this.affiliates);
        for (CollectionNode parentNode : this.getParents()) {
            for (NodeSubscription subscription : parentNode.getSubscriptions()) {
                affiliatesToNotify.add(subscription.getAffiliate());
            }
        }
        for (NodeAffiliate affiliate : affiliatesToNotify) {
            affiliate.sendPublishedNotifications(message, event, this, newPublishedItems);
        }
    }

    public void deleteItems(List<PublishedItem> toDelete) {
        for (PublishedItem item : toDelete) {
            PubSubPersistenceManager.removePublishedItem(item);
            if (this.lastPublished == null || !this.lastPublished.getID().equals(item.getID())) continue;
            this.lastPublished = null;
        }
        if (this.isNotifiedOfRetract()) {
            Message message = new Message();
            Element event = message.addChildElement("event", "http://jabber.org/protocol/pubsub#event");
            HashSet<NodeAffiliate> affiliatesToNotify = new HashSet<NodeAffiliate>(this.affiliates);
            for (CollectionNode parentNode : this.getParents()) {
                for (NodeSubscription subscription : parentNode.getSubscriptions()) {
                    affiliatesToNotify.add(subscription.getAffiliate());
                }
            }
            for (NodeAffiliate affiliate : affiliatesToNotify) {
                affiliate.sendDeletionNotifications(message, event, this, toDelete);
            }
        }
    }

    void sendPublishedItems(IQ originalRequest, List<PublishedItem> publishedItems, boolean forceToIncludePayload) {
        IQ result = IQ.createResultIQ((IQ)originalRequest);
        Element pubsubElem = result.setChildElement("pubsub", "http://jabber.org/protocol/pubsub");
        Element items = pubsubElem.addElement("items");
        items.addAttribute("node", this.getNodeID());
        for (PublishedItem publishedItem : publishedItems) {
            Element item = items.addElement("item");
            if (this.isItemRequired()) {
                item.addAttribute("id", publishedItem.getID());
            }
            if (!forceToIncludePayload && !this.isPayloadDelivered() || publishedItem.getPayload() == null) continue;
            item.add(publishedItem.getPayload().createCopy());
        }
        this.service.send((Packet)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishedItem getPublishedItem(String itemID) {
        if (!this.isItemRequired()) {
            return null;
        }
        LeafNode leafNode = this;
        synchronized (leafNode) {
            if (this.lastPublished != null && this.lastPublished.getID().equals(itemID)) {
                return this.lastPublished;
            }
        }
        return PubSubPersistenceManager.getPublishedItem(this, itemID);
    }

    @Override
    public List<PublishedItem> getPublishedItems() {
        return this.getPublishedItems(this.getMaxPublishedItems());
    }

    @Override
    public synchronized List<PublishedItem> getPublishedItems(int recentItems) {
        List<PublishedItem> publishedItems = PubSubPersistenceManager.getPublishedItems(this, recentItems);
        if (this.lastPublished != null) {
            boolean persistentItemsContainsLastItem = false;
            for (PublishedItem publishedItem : publishedItems) {
                if (!publishedItem.getID().equals(this.lastPublished.getID())) continue;
                persistentItemsContainsLastItem = true;
                break;
            }
            if (!persistentItemsContainsLastItem) {
                publishedItems.add(0, this.lastPublished);
                if (publishedItems.size() > recentItems) {
                    publishedItems.remove(publishedItems.size() - 1);
                }
            }
        }
        return publishedItems;
    }

    @Override
    public synchronized PublishedItem getLastPublishedItem() {
        if (this.lastPublished == null) {
            this.lastPublished = PubSubPersistenceManager.getLastPublishedItem(this);
        }
        return this.lastPublished;
    }

    @Override
    public boolean isSendItemSubscribe() {
        return this.sendItemSubscribe;
    }

    void setMaxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    void setPersistPublishedItems(boolean persistPublishedItems) {
        this.persistPublishedItems = persistPublishedItems;
    }

    void setMaxPublishedItems(int maxPublishedItems) {
        this.maxPublishedItems = maxPublishedItems;
    }

    void setSendItemSubscribe(boolean sendItemSubscribe) {
        this.sendItemSubscribe = sendItemSubscribe;
    }

    public void purge() {
        PubSubPersistenceManager.purgeNode(this);
        Message message = new Message();
        Element event = message.addChildElement("event", "http://jabber.org/protocol/pubsub#event");
        Element items = event.addElement("purge");
        items.addAttribute("node", this.nodeID);
        this.broadcastNodeEvent(message, false);
    }
}

