/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.privacy;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivacyListProvider {
    private static final PrivacyListProvider instance = new PrivacyListProvider();
    private static final Logger Log = LoggerFactory.getLogger(PrivacyListProvider.class);
    private static final String PRIVACY_LIST_COUNT = "SELECT count(*) from ofPrivacyList";
    private static final String LOAD_LIST_NAMES = "SELECT name, isDefault FROM ofPrivacyList WHERE username=?";
    private static final String LOAD_PRIVACY_LIST = "SELECT isDefault, list FROM ofPrivacyList WHERE username=? AND name=?";
    private static final String LOAD_DEFAULT_PRIVACY_LIST = "SELECT name, list FROM ofPrivacyList WHERE username=? AND isDefault=1";
    private static final String DELETE_PRIVACY_LIST = "DELETE FROM ofPrivacyList WHERE username=? AND name=?";
    private static final String DELETE_PRIVACY_LISTS = "DELETE FROM ofPrivacyList WHERE username=?";
    private static final String UPDATE_PRIVACY_LIST = "UPDATE ofPrivacyList SET isDefault=?, list=? WHERE username=? AND name=?";
    private static final String INSERT_PRIVACY_LIST = "INSERT INTO ofPrivacyList (username, name, isDefault, list) VALUES (?, ?, ?, ?)";
    private static final int POOL_SIZE = 50;
    private BlockingQueue<SAXReader> xmlReaders = new LinkedBlockingQueue<SAXReader>(50);
    private AtomicBoolean databaseContainsPrivacyLists;

    public static PrivacyListProvider getInstance() {
        return instance;
    }

    private PrivacyListProvider() {
        for (int i = 0; i < 50; ++i) {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            this.xmlReaders.add(xmlReader);
        }
        this.databaseContainsPrivacyLists = new AtomicBoolean(false);
        this.loadDatabaseContainsPrivacyLists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Boolean> getPrivacyLists(String username) {
        if (!this.databaseContainsPrivacyLists.get()) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> names = new HashMap<String, Boolean>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_LIST_NAMES);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                names.put(rs.getString(1), rs.getInt(2) == 1);
            }
        }
        catch (Exception e) {
            try {
                Log.error("Error loading names of privacy lists for username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivacyList loadPrivacyList(String username, String listName) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        String listValue;
        boolean isDefault;
        block12: {
            PrivacyList privacyList;
            if (!this.databaseContainsPrivacyLists.get()) {
                return null;
            }
            isDefault = false;
            listValue = null;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_PRIVACY_LIST);
                pstmt.setString(1, username);
                pstmt.setString(2, listName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    isDefault = rs.getInt(1) == 1;
                    listValue = rs.getString(2);
                    break block12;
                }
                privacyList = null;
            }
            catch (Exception e) {
                PrivacyList privacyList2;
                try {
                    Log.error("Error loading privacy list: " + listName + " of username: " + username, (Throwable)e);
                    privacyList2 = null;
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
                return privacyList2;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return privacyList;
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        PrivacyList privacyList = null;
        SAXReader xmlReader = null;
        try {
            xmlReader = this.xmlReaders.take();
            Element listElement = xmlReader.read((Reader)new StringReader(listValue)).getRootElement();
            privacyList = new PrivacyList(username, listName, isDefault, listElement);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (xmlReader != null) {
                this.xmlReaders.add(xmlReader);
            }
        }
        return privacyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivacyList loadDefaultPrivacyList(String username) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        String listValue;
        String listName;
        block12: {
            PrivacyList privacyList;
            if (!this.databaseContainsPrivacyLists.get()) {
                return null;
            }
            listName = null;
            listValue = null;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_DEFAULT_PRIVACY_LIST);
                pstmt.setString(1, username);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    listName = rs.getString(1);
                    listValue = rs.getString(2);
                    break block12;
                }
                privacyList = null;
            }
            catch (Exception e) {
                PrivacyList privacyList2;
                try {
                    Log.error("Error loading default privacy list of username: " + username, (Throwable)e);
                    privacyList2 = null;
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
                return privacyList2;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return privacyList;
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        PrivacyList privacyList = null;
        SAXReader xmlReader = null;
        try {
            xmlReader = this.xmlReaders.take();
            Element listElement = xmlReader.read((Reader)new StringReader(listValue)).getRootElement();
            privacyList = new PrivacyList(username, listName, true, listElement);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (xmlReader != null) {
                this.xmlReaders.add(xmlReader);
            }
        }
        return privacyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPrivacyList(String username, PrivacyList list) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_PRIVACY_LIST);
            pstmt.setString(1, username);
            pstmt.setString(2, list.getName());
            pstmt.setInt(3, list.isDefault() ? 1 : 0);
            pstmt.setString(4, list.asElement().asXML());
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                Log.error("Error adding privacy list: " + list.getName() + " of username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        this.databaseContainsPrivacyLists.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePrivacyList(String username, PrivacyList list) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_PRIVACY_LIST);
            pstmt.setInt(1, list.isDefault() ? 1 : 0);
            pstmt.setString(2, list.asElement().asXML());
            pstmt.setString(3, username);
            pstmt.setString(4, list.getName());
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                Log.error("Error updating privacy list: " + list.getName() + " of username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        this.databaseContainsPrivacyLists.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePrivacyList(String username, String listName) {
        if (!this.databaseContainsPrivacyLists.get()) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PRIVACY_LIST);
            pstmt.setString(1, username);
            pstmt.setString(2, listName);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                Log.error("Error deleting privacy list: " + listName + " of username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        this.databaseContainsPrivacyLists.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePrivacyLists(String username) {
        if (!this.databaseContainsPrivacyLists.get()) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PRIVACY_LISTS);
            pstmt.setString(1, username);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                Log.error("Error deleting privacy lists of username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        this.databaseContainsPrivacyLists.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDatabaseContainsPrivacyLists() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(PRIVACY_LIST_COUNT);
            rs = pstmt.executeQuery();
            rs.next();
            this.databaseContainsPrivacyLists.set(rs.getInt(1) != 0);
        }
        catch (Exception e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
    }
}

