/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pep;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.pep.PEPService;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.PubSubEngine;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;

public class PEPServiceManager {
    public static final Logger Log = LoggerFactory.getLogger(PEPServiceManager.class);
    private static final String GET_PEP_SERVICE = "SELECT DISTINCT serviceID FROM ofPubsubNode WHERE serviceID=?";
    private final Cache<String, PEPService> pepServices = CacheFactory.createLocalCache("PEPServiceManager");
    private PubSubEngine pubSubEngine = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEPService getPEPService(String jid) {
        PEPService pepService = null;
        Lock lock = CacheFactory.getLock(jid, this.pepServices);
        try {
            lock.lock();
            if (this.pepServices.containsKey(jid)) {
                pepService = (PEPService)this.pepServices.get(jid);
            } else {
                pepService = this.loadPEPServiceFromDB(jid);
                this.pepServices.put(jid, pepService);
            }
        }
        finally {
            lock.unlock();
        }
        return pepService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEPService create(JID owner) {
        if (!XMPPServer.getInstance().isLocal(owner) || !UserManager.getInstance().isRegisteredUser(owner.getNode())) {
            throw new IllegalArgumentException("Request must be initiated by a local, registered user, but is not: " + owner);
        }
        PEPService pepService = null;
        String bareJID = owner.toBareJID();
        Lock lock = CacheFactory.getLock(owner, this.pepServices);
        try {
            lock.lock();
            pepService = (PEPService)this.pepServices.get(bareJID);
            if (pepService == null) {
                pepService = new PEPService(XMPPServer.getInstance(), bareJID);
                this.pepServices.put(bareJID, pepService);
                if (Log.isDebugEnabled()) {
                    Log.debug("PEPService created for : " + bareJID);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return pepService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PEPService loadPEPServiceFromDB(String jid) {
        PEPService pepService = null;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GET_PEP_SERVICE);
            pstmt.setString(1, jid);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String serviceID = rs.getString(1);
                pepService = new PEPService(XMPPServer.getInstance(), serviceID);
                this.pepServices.put(serviceID, pepService);
                this.pubSubEngine.start(pepService);
                if (!Log.isDebugEnabled()) continue;
                Log.debug("PEP: Restored service for " + serviceID + " from the database.");
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return pepService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(JID owner) {
        PEPService service = null;
        Lock lock = CacheFactory.getLock(owner, this.pepServices);
        try {
            lock.lock();
            service = (PEPService)this.pepServices.remove(owner.toBareJID());
        }
        finally {
            lock.unlock();
        }
        if (service == null) {
            return;
        }
        CollectionNode rootNode = service.getRootCollectionNode();
        for (Node node : service.getNodes()) {
            if (!rootNode.isChildNode(node)) continue;
            node.delete();
        }
        rootNode.delete();
    }

    public void start(PEPService pepService) {
        this.pubSubEngine.start(pepService);
    }

    public void start() {
        this.pubSubEngine = new PubSubEngine(XMPPServer.getInstance().getPacketRouter());
    }

    public void stop() {
        for (PEPService service : this.pepServices.values()) {
            this.pubSubEngine.shutdown(service);
        }
        this.pubSubEngine = null;
    }

    public void process(PEPService service, IQ iq) {
        this.pubSubEngine.process((PubSubService)service, iq);
    }

    public boolean hasCachedService(JID owner) {
        return this.pepServices.get(owner.toBareJID()) != null;
    }

    public void unload(PEPService service) {
        this.pubSubEngine.shutdown(service);
    }
}

