/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.nio;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.jivesoftware.openfire.nio.XMLNotWellFormedException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;

class XMLLightweightParser {
    private static final Pattern XML_HAS_CHARREF = Pattern.compile("&#(0*([0-9]+)|[xX]0*([0-9a-fA-F]+));");
    private static final String MAX_PROPERTY_NAME = "xmpp.parser.buffer.size";
    private static int maxBufferSize;
    protected static char[] CDATA_START;
    protected static char[] CDATA_END;
    protected StringBuilder buffer = new StringBuilder();
    protected static final int INIT = 0;
    protected static final int HEAD = 2;
    protected static final int INSIDE = 3;
    protected static final int PRETAIL = 4;
    protected static final int TAIL = 5;
    protected static final int VERIFY_CLOSE_TAG = 6;
    protected static final int INSIDE_PARAM_VALUE = 7;
    protected static final int INSIDE_CDATA = 8;
    protected static final int OUTSIDE = 9;
    final String[] sstatus = new String[]{"INIT", "", "HEAD", "INSIDE", "PRETAIL", "TAIL", "VERIFY", "INSIDE_PARAM", "INSIDE_CDATA", "OUTSIDE"};
    protected int status = 0;
    protected int cdataOffset = 0;
    protected int tailCount = 0;
    protected int startLastMsg = 0;
    protected boolean insideRootTag = false;
    protected StringBuilder head = new StringBuilder(5);
    protected List<String> msgs = new ArrayList<String>();
    private int depth = 0;
    protected boolean insideChildrenTag = false;
    CharsetDecoder encoder;

    public XMLLightweightParser(Charset charset) {
        this.encoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public boolean areThereMsgs() {
        return this.msgs.size() > 0;
    }

    public String[] getMsgs() {
        String[] res = new String[this.msgs.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.msgs.get(i);
        }
        this.msgs.clear();
        this.invalidateBuffer();
        return res;
    }

    protected void invalidateBuffer() {
        if (this.buffer.length() > 0) {
            String str = this.buffer.substring(this.startLastMsg);
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append(str);
            this.buffer.trimToSize();
        }
        this.startLastMsg = 0;
    }

    protected void foundMsg(String msg) throws XMLNotWellFormedException {
        if (msg != null) {
            if (XMLLightweightParser.hasIllegalCharacterReferences(msg)) {
                this.buffer = null;
                throw new XMLNotWellFormedException("Illegal character reference found in: " + msg);
            }
            this.msgs.add(msg);
        }
        this.status = 0;
        this.tailCount = 0;
        this.cdataOffset = 0;
        this.head.setLength(0);
        this.insideRootTag = false;
        this.insideChildrenTag = false;
        this.depth = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void read(IoBuffer byteBuffer) throws Exception {
        if (this.buffer == null) {
            byteBuffer.position(byteBuffer.limit());
            return;
        }
        this.invalidateBuffer();
        if (this.buffer.length() > maxBufferSize) {
            this.buffer = null;
            ProtocolDecoderException ex = new ProtocolDecoderException("Stopped parsing never ending stanza");
            ex.setHexdump("(redacted hex dump of never ending stanza)");
            throw ex;
        }
        CharBuffer charBuffer = CharBuffer.allocate(byteBuffer.capacity());
        this.encoder.reset();
        this.encoder.decode(byteBuffer.buf(), charBuffer, false);
        char[] buf = new char[charBuffer.position()];
        charBuffer.flip();
        charBuffer.get(buf);
        int readChar = buf.length;
        if (readChar == 0) {
            return;
        }
        this.buffer.append(buf);
        boolean isHighSurrogate = false;
        for (int i = 0; i < readChar; ++i) {
            String msg;
            int end;
            char ch = buf[i];
            if (ch < ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\u0000') {
                this.buffer = null;
                throw new XMLNotWellFormedException("Character is invalid in: " + ch);
            }
            if (isHighSurrogate) {
                if (!Character.isLowSurrogate(ch)) {
                    this.buffer = null;
                    throw new Exception("Found high surrogate not followed by low surrogate");
                }
                isHighSurrogate = false;
            } else if (Character.isHighSurrogate(ch)) {
                isHighSurrogate = true;
            } else if (Character.isLowSurrogate(ch)) {
                this.buffer = null;
                throw new Exception("Found low surrogate char without a preceding high surrogate");
            }
            if (this.status == 5) {
                if (this.depth < 1 && ch == this.head.charAt(this.tailCount)) {
                    ++this.tailCount;
                    if (this.tailCount != this.head.length()) continue;
                    end = this.buffer.length() - readChar + (i + 1);
                    msg = this.buffer.substring(this.startLastMsg, end);
                    this.foundMsg(msg);
                    this.startLastMsg = end;
                    continue;
                }
                this.tailCount = 0;
                this.status = 3;
                continue;
            }
            if (this.status == 4) {
                if (ch == CDATA_START[this.cdataOffset]) {
                    ++this.cdataOffset;
                    if (this.cdataOffset == CDATA_START.length) {
                        this.status = 8;
                        this.cdataOffset = 0;
                        continue;
                    }
                } else {
                    this.cdataOffset = 0;
                    this.status = 3;
                }
                if (ch == '/') {
                    this.status = 5;
                    --this.depth;
                    continue;
                }
                if (ch == '!') {
                    this.status = 3;
                    continue;
                }
                ++this.depth;
                continue;
            }
            if (this.status == 6) {
                if (ch == '>') {
                    --this.depth;
                    this.status = 9;
                    if (this.depth >= 1) continue;
                    end = this.buffer.length() - readChar + (i + 1);
                    msg = this.buffer.substring(this.startLastMsg, end);
                    this.foundMsg(msg);
                    this.startLastMsg = end;
                    continue;
                }
                if (ch == '<') {
                    this.status = 4;
                    this.insideChildrenTag = true;
                    continue;
                }
                this.status = 3;
                continue;
            }
            if (this.status == 7) {
                if (ch != '\"') continue;
                this.status = 3;
                continue;
            }
            if (this.status == 8) {
                if (ch == CDATA_END[this.cdataOffset]) {
                    ++this.cdataOffset;
                    if (this.cdataOffset != CDATA_END.length) continue;
                    this.status = 9;
                    this.cdataOffset = 0;
                    continue;
                }
                if (this.cdataOffset == CDATA_END.length - 1 && ch == CDATA_END[this.cdataOffset - 1]) continue;
                this.cdataOffset = 0;
                continue;
            }
            if (this.status == 3) {
                if (ch == CDATA_START[this.cdataOffset]) {
                    ++this.cdataOffset;
                    if (this.cdataOffset == CDATA_START.length) {
                        this.status = 8;
                        this.cdataOffset = 0;
                        continue;
                    }
                } else {
                    this.cdataOffset = 0;
                    this.status = 3;
                }
                if (ch == '\"') {
                    this.status = 7;
                    continue;
                }
                if (ch == '>') {
                    this.status = 9;
                    if (this.insideRootTag && ("stream:stream>".equals(this.head.toString()) || "?xml>".equals(this.head.toString()) || "flash:stream>".equals(this.head.toString()))) {
                        end = this.buffer.length() - readChar + (i + 1);
                        while (this.startLastMsg < end && '<' != this.buffer.charAt(this.startLastMsg)) {
                            ++this.startLastMsg;
                        }
                        msg = this.buffer.substring(this.startLastMsg, end);
                        this.foundMsg(msg);
                        this.startLastMsg = end;
                    }
                    this.insideRootTag = false;
                    continue;
                }
                if (ch != '/') continue;
                this.status = 6;
                continue;
            }
            if (this.status == 2) {
                if (ch == ' ' || ch == '>') {
                    this.head.append('>');
                    this.status = ch == '>' ? 9 : 3;
                    this.insideRootTag = true;
                    this.insideChildrenTag = false;
                    continue;
                }
                if (ch == '/' && this.head.length() > 0) {
                    this.status = 6;
                    --this.depth;
                }
                this.head.append(ch);
                continue;
            }
            if (this.status == 0) {
                if (ch == '<') {
                    this.status = 2;
                    this.depth = 1;
                    continue;
                }
                ++this.startLastMsg;
                continue;
            }
            if (this.status != 9 || ch != '<') continue;
            this.status = 4;
            this.cdataOffset = 1;
            this.insideChildrenTag = true;
        }
        if (this.head.length() > 0 && ("/stream:stream>".equals(this.head.toString()) || "/flash:stream>".equals(this.head.toString()))) {
            this.foundMsg("</stream:stream>");
        }
    }

    public static boolean hasIllegalCharacterReferences(String string) {
        Matcher matcher = XML_HAS_CHARREF.matcher(string);
        while (matcher.find()) {
            String decValue = matcher.group(2);
            if (decValue != null) {
                int value = Integer.parseInt(decValue);
                if (XMLLightweightParser.isLegalXmlCharacter(value)) continue;
                return true;
            }
            String hexValue = matcher.group(3);
            if (hexValue != null) {
                int value = Integer.parseInt(hexValue, 16);
                if (XMLLightweightParser.isLegalXmlCharacter(value)) continue;
                return true;
            }
            throw new IllegalStateException("An error occurred while searching for illegal character references in the value [" + string + "].");
        }
        return false;
    }

    public static boolean isLegalXmlCharacter(int value) {
        return value == 9 || value == 10 || value == 13 || value >= 32 && value <= 55295 || value >= 57344 && value <= 65533 || value >= 65536 && value <= 0x10FFFF;
    }

    static {
        CDATA_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
        CDATA_END = new char[]{']', ']', '>'};
        maxBufferSize = JiveGlobals.getIntProperty(MAX_PROPERTY_NAME, 0x100000);
        PropertyEventDispatcher.addListener(new PropertyListener());
    }

    private static class PropertyListener
    implements PropertyEventListener {
        private PropertyListener() {
        }

        @Override
        public void propertySet(String property, Map<String, Object> params) {
            String value;
            if (XMLLightweightParser.MAX_PROPERTY_NAME.equals(property) && (value = (String)params.get("value")) != null) {
                maxBufferSize = Integer.parseInt(value);
            }
        }

        @Override
        public void propertyDeleted(String property, Map<String, Object> params) {
            if (XMLLightweightParser.MAX_PROPERTY_NAME.equals(property)) {
                maxBufferSize = 0x100000;
            }
        }

        @Override
        public void xmlPropertySet(String property, Map<String, Object> params) {
        }

        @Override
        public void xmlPropertyDeleted(String property, Map<String, Object> params) {
        }
    }
}

