/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.nio;

import org.jivesoftware.openfire.OfflineMessageStrategy;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class OfflinePacketDeliverer
implements PacketDeliverer {
    private static final Logger Log = LoggerFactory.getLogger(OfflinePacketDeliverer.class);
    private OfflineMessageStrategy messageStrategy = XMPPServer.getInstance().getOfflineMessageStrategy();

    @Override
    public void deliver(Packet packet) throws UnauthorizedException, PacketException {
        if (packet instanceof Message) {
            this.messageStrategy.storeOffline((Message)packet);
        } else if (!(packet instanceof Presence) && packet instanceof IQ) {
            Log.warn(LocaleUtils.getLocalizedString("admin.error.routing") + "\n" + packet.toString());
        }
    }
}

