/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import org.jivesoftware.openfire.net.DNSUtil;
import org.jivesoftware.openfire.server.RemoteServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketUtil {
    private static final Logger Log = LoggerFactory.getLogger(SocketUtil.class);

    public static Socket createSocketToXmppDomain(String xmppDomain, int port) {
        Log.debug("Creating a socket connection to XMPP domain '{}' ...", (Object)xmppDomain);
        Log.debug("Use DNS to resolve remote hosts for the provided XMPP domain '{}' (default port: {}) ...", (Object)xmppDomain, (Object)port);
        List<DNSUtil.HostAddress> remoteHosts = DNSUtil.resolveXMPPDomain(xmppDomain, port);
        Log.debug("Found {} host(s) for XMPP domain '{}'.", (Object)remoteHosts.size(), (Object)xmppDomain);
        Socket socket = null;
        int socketTimeout = RemoteServerManager.getSocketTimeout();
        for (DNSUtil.HostAddress remoteHost : remoteHosts) {
            String realHostname = remoteHost.getHost();
            int realPort = remoteHost.getPort();
            try {
                socket = new Socket();
                Log.debug("Trying to create socket connection to XMPP domain '{}' using remote host: {}:{} (blocks up to {} ms) ...", new Object[]{xmppDomain, realHostname, realPort, socketTimeout});
                socket.connect(new InetSocketAddress(realHostname, realPort), socketTimeout);
                Log.debug("Successfully created socket connection to XMPP domain '{}' using remote host: {}:{}!", new Object[]{xmppDomain, realHostname, realPort});
                return socket;
            }
            catch (Exception e) {
                Log.debug("An exception occurred while trying to create a socket connection to XMPP domain '{}' using remote host {}:{}", new Object[]{xmppDomain, realHostname, realPort, e});
                Log.warn("Unable to create a socket connection to XMPP domain '{}' using remote host: {}:{}. Cause: {} (a full stacktrace is logged on debug level)", new Object[]{xmppDomain, realHostname, realPort, e.getMessage()});
                try {
                    if (socket == null) continue;
                    socket.close();
                    socket = null;
                }
                catch (IOException ex) {
                    Log.debug("An additional exception occurred while trying to close a socket when creating a connection to {}:{} failed.", new Object[]{realHostname, realPort, ex});
                }
            }
        }
        Log.warn("Unable to create a socket connection to XMPP domain '{}': Unable to connect to any of its remote hosts.", (Object)xmppDomain);
        return null;
    }
}

