/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.X509TrustManager;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTrustManager
implements X509TrustManager {
    private static final Logger Log = LoggerFactory.getLogger(ServerTrustManager.class);
    private KeyStore trustStore;

    @Deprecated
    public ServerTrustManager(String server, KeyStore trustStore, Connection connection) {
        this(trustStore);
    }

    public ServerTrustManager(KeyStore trustTrust) {
        this.trustStore = trustTrust;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String string) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String string) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (JiveGlobals.getBooleanProperty("xmpp.server.certificate.accept-selfsigned", false)) {
            return new X509Certificate[0];
        }
        X509Certificate[] X509Certs = null;
        try {
            int numberOfEntry = this.trustStore.size();
            if (numberOfEntry > 0) {
                X509Certs = new X509Certificate[numberOfEntry];
                Enumeration<String> aliases = this.trustStore.aliases();
                int i = 0;
                while (aliases.hasMoreElements()) {
                    X509Certs[i] = (X509Certificate)this.trustStore.getCertificate(aliases.nextElement());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            X509Certs = null;
        }
        return X509Certs;
    }
}

