/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.jivesoftware.openfire.net.OCSPChecker;
import org.jivesoftware.util.CertificateManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTrustManager
implements X509TrustManager {
    private static final Logger Log = LoggerFactory.getLogger(ClientTrustManager.class);
    private KeyStore trustStore;
    private CertStore crlStore = null;
    private Collection<X509CRL> crls = null;
    private long crlLastUpdated = 0L;
    private boolean useCRLs = false;

    public ClientTrustManager(KeyStore trustTrust) {
        this.trustStore = trustTrust;
        this.crls = new ArrayList<X509CRL>();
        CollectionCertStoreParameters params = new CollectionCertStoreParameters(this.crls);
        try {
            this.crlStore = CertStore.getInstance("Collection", params);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException ex) {
            Log.warn("ClientTrustManager: ", (Throwable)ex);
        }
        this.loadCRL();
    }

    private void loadCRL() {
        File crlFile = new File(JiveGlobals.getProperty("xmpp.client.certificate.crl", "resources" + File.separator + "security" + File.separator + "crl.pem"));
        if (!crlFile.isFile()) {
            Log.debug("ClientTrustmanager: crl file not found " + crlFile.toString());
            this.useCRLs = false;
            return;
        }
        long modified = crlFile.lastModified();
        if (modified > this.crlLastUpdated) {
            this.crlLastUpdated = modified;
            Log.debug("ClientTrustManager: Updating CRLs");
            this.useCRLs = false;
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                FileInputStream crlStream = new FileInputStream(crlFile);
                BufferedInputStream crlBuffer = new BufferedInputStream(crlStream);
                this.crls.clear();
                while (crlBuffer.available() > 0) {
                    X509CRL crl = (X509CRL)cf.generateCRL(crlBuffer);
                    Log.debug("ClientTrustManager: adding CRL for " + crl.getIssuerDN());
                    this.crls.add(crl);
                }
                this.useCRLs = true;
            }
            catch (FileNotFoundException e) {
                Log.debug("ClientTrustManager: CRL file not found: " + crlFile.toString());
            }
            catch (IOException e) {
                Log.error("ClientTrustManager: IOException while parsing CRLs", (Throwable)e);
            }
            catch (CertificateException e) {
                Log.error("ClientTrustManager: ", (Throwable)e);
            }
            catch (CRLException e) {
                Log.error("ClientTrustManager: CRLException while parsing CRLs", (Throwable)e);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String string) throws CertificateException {
        Log.debug("ClientTrustManager: checkClientTrusted(x509Certificates," + string + ") called");
        this.loadCRL();
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (int i = 0; i < x509Certificates.length; ++i) {
            certs.add(x509Certificates[i]);
        }
        boolean verify = JiveGlobals.getBooleanProperty("xmpp.client.certificate.verify", true);
        if (verify) {
            int i;
            int nSize = x509Certificates.length;
            List<String> peerIdentities = CertificateManager.getClientIdentities(x509Certificates[0]);
            if (JiveGlobals.getBooleanProperty("xmpp.client.certificate.verify.chain", true)) {
                Principal principalLast = null;
                for (i = nSize - 1; i >= 0; --i) {
                    X509Certificate x509certificate = x509Certificates[i];
                    Principal principalIssuer = x509certificate.getIssuerDN();
                    Principal principalSubject = x509certificate.getSubjectDN();
                    if (principalLast != null) {
                        if (principalIssuer.equals(principalLast)) {
                            try {
                                PublicKey publickey = x509Certificates[i + 1].getPublicKey();
                                x509Certificates[i].verify(publickey);
                            }
                            catch (GeneralSecurityException generalsecurityexception) {
                                throw new CertificateException("signature verification failed of " + peerIdentities);
                            }
                        } else {
                            throw new CertificateException("subject/issuer verification failed of " + peerIdentities);
                        }
                    }
                    principalLast = principalSubject;
                }
            }
            if (JiveGlobals.getBooleanProperty("xmpp.client.certificate.verify.root", true)) {
                boolean trusted = false;
                try {
                    Enumeration<String> aliases = this.trustStore.aliases();
                    while (aliases.hasMoreElements()) {
                        PublicKey publickey;
                        String alias = aliases.nextElement();
                        X509Certificate tCert = (X509Certificate)this.trustStore.getCertificate(alias);
                        if (x509Certificates[nSize - 1].equals(tCert)) {
                            try {
                                publickey = tCert.getPublicKey();
                                x509Certificates[nSize - 1].verify(publickey);
                            }
                            catch (GeneralSecurityException generalsecurityexception) {
                                throw new CertificateException("signature verification failed of " + peerIdentities);
                            }
                            trusted = true;
                            break;
                        }
                        if (!x509Certificates[nSize - 1].getIssuerDN().equals(tCert.getSubjectDN())) continue;
                        try {
                            publickey = tCert.getPublicKey();
                            x509Certificates[nSize - 1].verify(publickey);
                        }
                        catch (GeneralSecurityException generalsecurityexception) {
                            throw new CertificateException("signature verification failed of " + peerIdentities);
                        }
                        trusted = true;
                        break;
                    }
                }
                catch (KeyStoreException e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
                if (!trusted) {
                    throw new CertificateException("root certificate not trusted of " + peerIdentities);
                }
            }
            if (JiveGlobals.getBooleanProperty("xmpp.client.certificate.verify.validity", true)) {
                Date date = new Date();
                for (i = 0; i < nSize; ++i) {
                    try {
                        x509Certificates[i].checkValidity(date);
                        continue;
                    }
                    catch (GeneralSecurityException generalsecurityexception) {
                        throw new CertificateException("invalid date of " + peerIdentities);
                    }
                }
            }
            try {
                PKIXCertPathValidatorResult cpvResult;
                X509Certificate trustedCert;
                CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
                CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX");
                X509CertSelector certSelector = new X509CertSelector();
                certSelector.setCertificate(x509Certificates[0]);
                PKIXBuilderParameters params = new PKIXBuilderParameters(this.trustStore, (CertSelector)certSelector);
                if (this.useCRLs) {
                    params.addCertStore(this.crlStore);
                } else {
                    Log.debug("ClientTrustManager: no CRL's found, so setRevocationEnabled(false)");
                    params.setRevocationEnabled(false);
                }
                CertPathBuilderResult cpbr = cpb.build(params);
                CertPath cp = cpbr.getCertPath();
                if (JiveGlobals.getBooleanProperty("ocsp.enable", false)) {
                    Log.debug("ClientTrustManager: OCSP requested");
                    OCSPChecker ocspChecker = new OCSPChecker(cp, params);
                    params.addCertPathChecker(ocspChecker);
                }
                if ((trustedCert = (cpvResult = (PKIXCertPathValidatorResult)cpv.validate(cp, params)).getTrustAnchor().getTrustedCert()) == null) {
                    throw new CertificateException("certificate path failed: Trusted CA is NULL");
                }
                Log.debug("ClientTrustManager: Trusted CA: " + trustedCert.getSubjectDN());
            }
            catch (CertPathBuilderException | CertPathValidatorException e) {
                Log.debug("ClientTrustManager:", (Throwable)e);
                throw new CertificateException("certificate path failed: " + e.getMessage());
            }
            catch (Exception e) {
                Log.debug("ClientTrustManager:", (Throwable)e);
                throw new CertificateException("unexpected error: " + e.getMessage());
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String string) throws CertificateException {
        Log.debug("ClientTrustManager: checkServerTrusted(...) called");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (JiveGlobals.getBooleanProperty("xmpp.client.certificate.accept-selfsigned", false)) {
            return new X509Certificate[0];
        }
        X509Certificate[] X509Certs = null;
        try {
            int numberOfEntry = this.trustStore.size();
            if (numberOfEntry > 0) {
                X509Certs = new X509Certificate[numberOfEntry];
                Enumeration<String> aliases = this.trustStore.aliases();
                int i = 0;
                while (aliases.hasMoreElements()) {
                    X509Certs[i] = (X509Certificate)this.trustStore.getCertificate(aliases.nextElement());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            X509Certs = null;
        }
        return X509Certs;
    }
}

