/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.multiplex;

import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.SessionPacketRouter;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.multiplex.ConnectionMultiplexerManager;
import org.jivesoftware.openfire.multiplex.Route;
import org.jivesoftware.openfire.multiplex.UnknownStanzaException;
import org.jivesoftware.openfire.session.ConnectionMultiplexerSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.spi.BasicStreamIDFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class MultiplexerPacketHandler {
    private static final Logger Log = LoggerFactory.getLogger(MultiplexerPacketHandler.class);
    private String connectionManagerDomain;
    private final ConnectionMultiplexerManager multiplexerManager;

    public MultiplexerPacketHandler(String connectionManagerDomain) {
        this.connectionManagerDomain = connectionManagerDomain;
        this.multiplexerManager = ConnectionMultiplexerManager.getInstance();
    }

    public void handle(Packet packet) {
        IQ iq;
        if (packet instanceof IQ && (iq = (IQ)packet).getType() != IQ.Type.result) {
            if (iq.getType() == IQ.Type.error) {
                Log.warn("Connection Manager failed to process IQ packet: " + packet.toXML());
            } else if (iq.getType() == IQ.Type.set) {
                Element child = iq.getChildElement();
                String streamIDValue = child.attributeValue("id");
                if (streamIDValue == null) {
                    Element extraError = DocumentHelper.createElement((QName)QName.get((String)"id-required", (String)"http://jabber.org/protocol/connectionmanager#errors"));
                    this.sendErrorPacket(iq, PacketError.Condition.bad_request, extraError);
                } else if ("session".equals(child.getName())) {
                    StreamID streamID = BasicStreamIDFactory.createStreamID(streamIDValue);
                    Element create = child.element("create");
                    if (create != null) {
                        String hostAddress;
                        Element hostElement = create.element("host");
                        String hostName = hostElement != null ? hostElement.attributeValue("name") : null;
                        boolean created = this.multiplexerManager.createClientSession(this.connectionManagerDomain, streamID, hostName, hostAddress = hostElement != null ? hostElement.attributeValue("address") : null);
                        if (created) {
                            this.sendResultPacket(iq);
                        } else {
                            this.sendErrorPacket(iq, PacketError.Condition.not_allowed, null);
                        }
                    } else {
                        LocalClientSession session = this.multiplexerManager.getClientSession(this.connectionManagerDomain, streamID);
                        if (session == null) {
                            this.sendErrorPacket(iq, PacketError.Condition.item_not_found, null);
                        } else if (child.element("close") != null) {
                            this.multiplexerManager.closeClientSession(this.connectionManagerDomain, streamID);
                            this.sendResultPacket(iq);
                        } else if (child.element("failed") != null) {
                            List wrappedElements = child.element("failed").elements();
                            if (wrappedElements.size() != 1) {
                                Element extraError = DocumentHelper.createElement((QName)QName.get((String)"invalid-payload", (String)"http://jabber.org/protocol/connectionmanager#errors"));
                                this.sendErrorPacket(iq, PacketError.Condition.bad_request, extraError);
                            } else {
                                Element wrappedElement = (Element)wrappedElements.get(0);
                                String tag = wrappedElement.getName();
                                if ("message".equals(tag)) {
                                    XMPPServer.getInstance().getOfflineMessageStrategy().storeOffline(new Message(wrappedElement));
                                    this.sendResultPacket(iq);
                                } else {
                                    Element extraError = DocumentHelper.createElement((QName)QName.get((String)"unknown-stanza", (String)"http://jabber.org/protocol/connectionmanager#errors"));
                                    this.sendErrorPacket(iq, PacketError.Condition.bad_request, extraError);
                                }
                            }
                        } else {
                            this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
                        }
                    }
                } else {
                    this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
                }
            } else {
                this.sendErrorPacket(iq, PacketError.Condition.bad_request, null);
            }
        }
    }

    public void route(Route route) {
        LocalClientSession session;
        StreamID streamID = route.getStreamID();
        if (streamID == null) {
            Element extraError = DocumentHelper.createElement((QName)QName.get((String)"id-required", (String)"http://jabber.org/protocol/connectionmanager#errors"));
            this.sendErrorPacket(route, PacketError.Condition.bad_request, extraError);
        }
        if ((session = this.multiplexerManager.getClientSession(this.connectionManagerDomain, streamID)) == null) {
            this.sendErrorPacket(route, PacketError.Condition.item_not_found, null);
            return;
        }
        SessionPacketRouter router = new SessionPacketRouter(session);
        router.setSkipJIDValidation(true);
        try {
            router.route(route.getChildElement());
        }
        catch (UnknownStanzaException use) {
            Element extraError = DocumentHelper.createElement((QName)QName.get((String)"unknown-stanza", (String)"http://jabber.org/protocol/connectionmanager#errors"));
            this.sendErrorPacket(route, PacketError.Condition.bad_request, extraError);
        }
        catch (Exception e) {
            Log.error("Error processing wrapped packet: " + route.getChildElement().asXML(), (Throwable)e);
            this.sendErrorPacket(route, PacketError.Condition.internal_server_error, null);
        }
    }

    private void sendErrorPacket(IQ packet, PacketError.Condition error, Element extraError) {
        IQ reply = IQ.createResultIQ((IQ)packet);
        reply.setChildElement(packet.getChildElement().createCopy());
        reply.setError(error);
        if (extraError != null) {
            reply.getError().getElement().add(extraError);
        }
        this.deliver((Packet)reply);
    }

    private void sendErrorPacket(Route packet, PacketError.Condition error, Element extraError) {
        Route reply = new Route(packet.getStreamID());
        reply.setID(packet.getID());
        reply.setFrom(packet.getTo());
        reply.setTo(packet.getFrom());
        reply.setError(error);
        if (extraError != null) {
            reply.getError().getElement().add(extraError);
        }
        this.deliver(reply);
    }

    private void sendResultPacket(IQ packet) {
        IQ reply = IQ.createResultIQ((IQ)packet);
        reply.setChildElement(packet.getChildElement().createCopy());
        this.deliver((Packet)reply);
    }

    private void deliver(Packet reply) {
        ConnectionMultiplexerSession session = this.multiplexerManager.getMultiplexerSession(this.connectionManagerDomain);
        if (session != null) {
            session.process(reply);
        } else {
            Log.warn("No multiplexer session found. Packet not delivered: " + reply.toXML());
        }
    }
}

