/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.openfire.event.GroupEventDispatcher;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;

public class LocalMUCRoomManager {
    private Map<String, LocalMUCRoom> rooms = new ConcurrentHashMap<String, LocalMUCRoom>();

    public int getNumberChatRooms() {
        return this.rooms.size();
    }

    public void addRoom(String roomname, LocalMUCRoom room) {
        this.rooms.put(roomname, room);
        GroupEventDispatcher.addListener(room);
    }

    public Collection<LocalMUCRoom> getRooms() {
        return this.rooms.values();
    }

    public LocalMUCRoom getRoom(String roomname) {
        return this.rooms.get(roomname);
    }

    public MUCRoom removeRoom(String roomname) {
        if (this.rooms.containsKey(roomname)) {
            GroupEventDispatcher.removeListener(this.rooms.get(roomname));
        }
        return this.rooms.remove(roomname);
    }

    public void cleanupRooms(Date cleanUpDate) {
        for (MUCRoom mUCRoom : this.getRooms()) {
            if (mUCRoom.getEmptyDate() == null || !mUCRoom.getEmptyDate().before(cleanUpDate)) continue;
            this.removeRoom(mUCRoom.getName());
        }
    }
}

