/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.muc.HistoryStrategy;
import org.jivesoftware.openfire.muc.spi.MultiUserChatServiceImpl;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class UpdateHistoryStrategy
implements ClusterTask<Void> {
    private String serviceName;
    private int type;
    private int maxNumber;

    public UpdateHistoryStrategy() {
    }

    public UpdateHistoryStrategy(String serviceName, HistoryStrategy historyStrategy) {
        this.serviceName = serviceName;
        this.type = historyStrategy.getType().ordinal();
        this.maxNumber = historyStrategy.getMaxNumber();
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void run() {
        MultiUserChatServiceImpl mucServer = (MultiUserChatServiceImpl)XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatService(this.serviceName);
        if (mucServer == null) {
            throw new IllegalArgumentException("MUC service not found for subdomain: " + this.serviceName);
        }
        HistoryStrategy strategy = mucServer.getHistoryStrategy();
        strategy.setType(HistoryStrategy.Type.values()[this.type]);
        strategy.setMaxNumber(this.maxNumber);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.serviceName);
        ExternalizableUtil.getInstance().writeInt(out, this.type);
        ExternalizableUtil.getInstance().writeInt(out, this.maxNumber);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serviceName = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.type = ExternalizableUtil.getInstance().readInt(in);
        this.maxNumber = ExternalizableUtil.getInstance().readInt(in);
    }
}

