/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.cluster.RoomInfo;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class ServiceInfo
implements Externalizable {
    private String subdomain;
    private String description;
    private Boolean isHidden;
    private List<RoomInfo> rooms = new ArrayList<RoomInfo>();

    public ServiceInfo() {
    }

    public ServiceInfo(MultiUserChatService service) {
        this.subdomain = service.getServiceName();
        this.description = service.getDescription();
        this.isHidden = service.isHidden();
        this.rooms = new ArrayList<RoomInfo>();
        for (MUCRoom room : service.getChatRooms()) {
            LocalMUCRoom localRoom = (LocalMUCRoom)room;
            if (room.getOccupants().isEmpty()) continue;
            this.rooms.add(new RoomInfo(localRoom, localRoom.getOccupants()));
        }
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean isHidden() {
        return this.isHidden;
    }

    public List<RoomInfo> getRooms() {
        return this.rooms;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.subdomain);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.description);
        ExternalizableUtil.getInstance().writeBoolean(out, this.isHidden);
        ExternalizableUtil.getInstance().writeExternalizableCollection(out, this.rooms);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.subdomain = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.description = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.isHidden = ExternalizableUtil.getInstance().readBoolean(in);
        ExternalizableUtil.getInstance().readExternalizableCollection(in, this.rooms, this.getClass().getClassLoader());
    }
}

