/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.cluster.OccupantAddedEvent;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class RoomInfo
implements Externalizable {
    private LocalMUCRoom room;
    private List<OccupantAddedEvent> occupants = new ArrayList<OccupantAddedEvent>();

    public RoomInfo() {
    }

    public RoomInfo(LocalMUCRoom room, Collection<MUCRole> occupants) {
        this.room = room;
        for (MUCRole occupant : occupants) {
            this.occupants.add(new OccupantAddedEvent(room, occupant));
        }
    }

    public LocalMUCRoom getRoom() {
        return this.room;
    }

    public List<OccupantAddedEvent> getOccupants() {
        return this.occupants;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSerializable(out, this.room);
        ExternalizableUtil.getInstance().writeExternalizableCollection(out, this.occupants);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.room = (LocalMUCRoom)ExternalizableUtil.getInstance().readSerializable(in);
        ExternalizableUtil.getInstance().readExternalizableCollection(in, this.occupants, this.getClass().getClassLoader());
    }
}

