/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.cluster.RoomInfo;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.util.cache.ClusterTask;

public class GetNewMemberRoomsRequest
implements ClusterTask<List<RoomInfo>> {
    private List<RoomInfo> rooms;

    @Override
    public List<RoomInfo> getResult() {
        return this.rooms;
    }

    @Override
    public void run() {
        this.rooms = new ArrayList<RoomInfo>();
        for (MultiUserChatService mucService : XMPPServer.getInstance().getMultiUserChatManager().getMultiUserChatServices()) {
            for (MUCRoom room : mucService.getChatRooms()) {
                LocalMUCRoom localRoom = (LocalMUCRoom)room;
                ArrayList<MUCRole> localOccupants = new ArrayList<MUCRole>();
                for (MUCRole occupant : room.getOccupants()) {
                    if (!occupant.isLocal()) continue;
                    localOccupants.add(occupant);
                }
                if (localOccupants.isEmpty()) continue;
                this.rooms.add(new RoomInfo(localRoom, localOccupants));
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }
}

