/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc;

import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.dom4j.Element;
import org.jivesoftware.openfire.muc.MUCRoomHistory;
import org.jivesoftware.openfire.muc.spi.LocalMUCRole;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class HistoryRequest {
    private static final Logger Log = LoggerFactory.getLogger(HistoryRequest.class);
    private static final XMPPDateTimeFormat xmppDateTime = new XMPPDateTimeFormat();
    private int maxChars = -1;
    private int maxStanzas = -1;
    private int seconds = -1;
    private Date since;

    public HistoryRequest(Element userFragment) {
        Element history = userFragment.element("history");
        if (history != null) {
            if (history.attribute("maxchars") != null) {
                this.maxChars = Integer.parseInt(history.attributeValue("maxchars"));
            }
            if (history.attribute("maxstanzas") != null) {
                this.maxStanzas = Integer.parseInt(history.attributeValue("maxstanzas"));
            }
            if (history.attribute("seconds") != null) {
                this.seconds = Integer.parseInt(history.attributeValue("seconds"));
            }
            if (history.attribute("since") != null) {
                try {
                    this.since = xmppDateTime.parseString(history.attributeValue("since"));
                }
                catch (ParseException pe) {
                    Log.error("Error parsing date from history management", (Throwable)pe);
                    this.since = null;
                }
            }
        }
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public int getMaxStanzas() {
        return this.maxStanzas;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public Date getSince() {
        return this.since;
    }

    private boolean isConfigured() {
        return this.maxChars > -1 || this.maxStanzas > -1 || this.seconds > -1 || this.since != null;
    }

    public void sendHistory(LocalMUCRole joinRole, MUCRoomHistory roomHistory) {
        if (!this.isConfigured()) {
            Iterator<Message> history = roomHistory.getMessageHistory();
            while (history.hasNext()) {
                joinRole.send((Packet)history.next());
            }
        } else {
            if (this.getMaxChars() == 0) {
                return;
            }
            int accumulatedChars = 0;
            int accumulatedStanzas = 0;
            LinkedList<Message> historyToSend = new LinkedList<Message>();
            ListIterator<Message> iterator = roomHistory.getReverseMessageHistory();
            while (iterator.hasPrevious()) {
                String string;
                Message message = iterator.previous();
                String string2 = string = message.getBody() == null ? message.getSubject() : message.getBody();
                if (string == null) continue;
                if (this.getMaxChars() > -1 && (accumulatedChars += string.length()) > this.getMaxChars() || this.getMaxStanzas() > -1 && ++accumulatedStanzas > this.getMaxStanzas()) break;
                if (this.getSeconds() > -1 || this.getSince() != null) {
                    Element delayInformation = message.getChildElement("delay", "urn:xmpp:delay");
                    try {
                        Date delayedDate = xmppDateTime.parseString(delayInformation.attributeValue("stamp"));
                        if (this.getSince() != null && delayedDate != null && delayedDate.before(this.getSince())) break;
                        if (this.getSeconds() > -1) {
                            Date current = new Date();
                            long diff = (current.getTime() - delayedDate.getTime()) / 1000L;
                            if ((long)this.getSeconds() <= diff) {
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.error("Error parsing date from historic message", (Throwable)e);
                    }
                }
                historyToSend.addFirst(message);
            }
            for (Object e : historyToSend) {
                joinRole.send((Packet)((Message)e));
            }
        }
    }
}

