/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.mediaproxy;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.jivesoftware.openfire.mediaproxy.Channel;
import org.jivesoftware.openfire.mediaproxy.DatagramListener;
import org.jivesoftware.openfire.mediaproxy.ProxyCandidate;
import org.jivesoftware.openfire.mediaproxy.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MediaProxySession
extends Thread
implements ProxyCandidate,
DatagramListener {
    private static final Logger Log = LoggerFactory.getLogger(MediaProxySession.class);
    private List<SessionListener> sessionListeners = new ArrayList<SessionListener>();
    private String id;
    private String pass;
    private String creator = "";
    private long timestamp = 0L;
    protected InetAddress localAddress;
    protected InetAddress hostA;
    protected InetAddress hostB;
    protected int portA;
    protected int portB;
    protected int localPortA;
    protected int localPortB;
    protected DatagramSocket socketA;
    protected DatagramSocket socketAControl;
    protected DatagramSocket socketB;
    protected DatagramSocket socketBControl;
    protected Channel channelAtoB;
    protected Channel channelAtoBControl;
    protected Channel channelBtoA;
    protected Channel channelBtoAControl;
    protected Thread threadAtoB;
    protected Thread threadAtoBControl;
    protected Thread threadBtoA;
    protected Thread threadBtoAControl;
    private Timer idleTimer = null;
    private Timer lifeTimer = null;
    private int minPort = 10000;
    private int maxPort = 20000;

    public MediaProxySession(String id, String creator, String localAddress, String hostA, int portA, String hostB, int portB, int minPort, int maxPort) {
        this.id = id;
        this.creator = creator;
        this.minPort = minPort;
        this.maxPort = maxPort;
        this.pass = String.valueOf(Math.abs(new Random().nextLong()));
        try {
            this.hostA = InetAddress.getByName(hostA);
            this.hostB = InetAddress.getByName(hostB);
            this.portA = portA;
            this.portB = portB;
            this.localAddress = InetAddress.getByName(localAddress);
            this.localPortA = this.getFreePort();
            this.socketA = new DatagramSocket(this.localPortA, this.localAddress);
            this.socketAControl = new DatagramSocket(this.localPortA + 1, this.localAddress);
            this.localPortB = this.getFreePort();
            this.socketB = new DatagramSocket(this.localPortB, this.localAddress);
            this.socketBControl = new DatagramSocket(this.localPortB + 1, this.localAddress);
            if (Log.isDebugEnabled()) {
                Log.debug("MediaProxySession: Session Created at: A " + this.localPortA + " : B " + this.localPortB);
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFreePort() {
        ServerSocket ss;
        int freePort = 0;
        for (int i = 0; i < 10; ++i) {
            freePort = (int)((long)this.minPort + Math.round(Math.random() * (double)(this.maxPort - this.minPort)));
            freePort = freePort % 2 == 0 ? freePort : freePort + 1;
            try {
                ss = new ServerSocket(freePort);
                freePort = ss.getLocalPort();
                ss.close();
                ss = new ServerSocket(freePort + 1);
                int controlPort = ss.getLocalPort();
                ss.close();
                if (controlPort != freePort + 1) continue;
                return freePort;
            }
            catch (IOException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            ss = new ServerSocket(0);
            freePort = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ss = null;
        }
        return freePort;
    }

    @Override
    public String getSID() {
        return this.id;
    }

    @Override
    public String getPass() {
        return this.pass;
    }

    public String getCreator() {
        return this.creator;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void run() {
        this.createChannels();
        this.threadAtoB = new Thread(this.channelAtoB);
        this.threadAtoBControl = new Thread(this.channelAtoBControl);
        this.threadBtoA = new Thread(this.channelBtoA);
        this.threadBtoAControl = new Thread(this.channelBtoAControl);
        this.threadAtoB.start();
        this.threadAtoBControl.start();
        this.threadBtoA.start();
        this.threadBtoAControl.start();
        this.addChannelListeners();
    }

    abstract void createChannels();

    void addChannelListeners() {
        this.channelAtoB.addListener(this);
        this.channelAtoBControl.addListener(this);
        this.channelBtoA.addListener(this);
        this.channelBtoAControl.addListener(this);
    }

    @Override
    public void stopAgent() {
        try {
            if (this.idleTimer != null) {
                this.idleTimer.cancel();
                this.idleTimer.purge();
                this.idleTimer = null;
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.lifeTimer != null) {
                this.lifeTimer.cancel();
                this.lifeTimer.purge();
                this.lifeTimer = null;
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        this.channelAtoB.removeListeners();
        this.channelAtoBControl.removeListeners();
        this.channelBtoA.removeListeners();
        this.channelBtoAControl.removeListeners();
        try {
            this.channelAtoB.cancel();
            this.channelAtoBControl.cancel();
            this.channelBtoA.cancel();
            this.channelBtoAControl.cancel();
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        this.socketA.close();
        this.socketAControl.close();
        this.socketB.close();
        this.socketBControl.close();
        this.dispatchAgentStopped();
        Log.debug("MediaProxySession: Session Stopped");
    }

    @Override
    public InetAddress getLocalhost() {
        return this.localAddress;
    }

    @Override
    public InetAddress getHostA() {
        return this.hostA;
    }

    @Override
    public InetAddress getHostB() {
        return this.hostB;
    }

    @Override
    public void setPortA(int portA) {
        if (Log.isDebugEnabled()) {
            Log.debug("MediaProxySession: PORT CHANGED(A):" + portA);
        }
        this.portA = portA;
    }

    @Override
    public void setPortB(int portB) {
        if (Log.isDebugEnabled()) {
            Log.debug("MediaProxySession: PORT CHANGED(B):" + portB);
        }
        this.portB = portB;
    }

    @Override
    public void setHostA(InetAddress hostA) {
        this.hostA = hostA;
    }

    @Override
    public void setHostB(InetAddress hostB) {
        this.hostB = hostB;
    }

    @Override
    public int getPortA() {
        return this.portA;
    }

    @Override
    public int getPortB() {
        return this.portB;
    }

    @Override
    public int getLocalPortA() {
        return this.localPortA;
    }

    @Override
    public int getLocalPortB() {
        return this.localPortB;
    }

    @Override
    public void sendFromPortA(String host, int port) {
        try {
            InetAddress address = InetAddress.getByName(host);
            this.channelAtoB.setHost(address);
            this.channelAtoB.setPort(port);
            this.channelAtoBControl.setHost(address);
            this.channelAtoBControl.setPort(port + 1);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void sendFromPortB(String host, int port) {
        try {
            InetAddress address = InetAddress.getByName(host);
            this.channelBtoA.setHost(address);
            this.channelBtoA.setPort(port);
            this.channelBtoAControl.setHost(address);
            this.channelBtoAControl.setPort(port + 1);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean datagramReceived(DatagramPacket datagramPacket) {
        this.timestamp = System.currentTimeMillis();
        return true;
    }

    void addKeepAlive(long delay) {
        if (this.idleTimer != null) {
            return;
        }
        this.idleTimer = new Timer();
        this.idleTimer.scheduleAtFixedRate(new TimerTask(){
            long lastTimeStamp;
            {
                this.lastTimeStamp = MediaProxySession.this.getTimestamp();
            }

            @Override
            public void run() {
                if (this.lastTimeStamp == MediaProxySession.this.getTimestamp()) {
                    MediaProxySession.this.stopAgent();
                    return;
                }
                this.lastTimeStamp = MediaProxySession.this.getTimestamp();
            }
        }, delay, delay);
    }

    void addLifeTime(long lifetime) {
        lifetime *= 1000L;
        if (this.lifeTimer != null) {
            return;
        }
        this.lifeTimer = new Timer();
        this.lifeTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MediaProxySession.this.stopAgent();
            }
        }, lifetime, lifetime);
    }

    public void addAgentListener(SessionListener sessionListener) {
        this.sessionListeners.add(sessionListener);
    }

    public void removeAgentListener(SessionListener sessionListener) {
        this.sessionListeners.remove(sessionListener);
    }

    public void clearAgentListeners() {
        this.sessionListeners.clear();
    }

    public void dispatchAgentStopped() {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.sessionClosed(this);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

