/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.mediaproxy;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutableChannelHandler;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.disco.DiscoInfoProvider;
import org.jivesoftware.openfire.disco.DiscoItem;
import org.jivesoftware.openfire.disco.DiscoItemsProvider;
import org.jivesoftware.openfire.disco.DiscoServerItem;
import org.jivesoftware.openfire.disco.ServerItemsProvider;
import org.jivesoftware.openfire.mediaproxy.Echo;
import org.jivesoftware.openfire.mediaproxy.MediaProxy;
import org.jivesoftware.openfire.mediaproxy.MediaProxySession;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class MediaProxyService
extends BasicModule
implements ServerItemsProvider,
RoutableChannelHandler,
DiscoInfoProvider,
DiscoItemsProvider {
    private static final Logger Log = LoggerFactory.getLogger(MediaProxyService.class);
    private String serviceName;
    private RoutingTable routingTable;
    private PacketRouter router;
    private Echo echo = null;
    private int echoPort = 10020;
    private SessionManager sessionManager = null;
    private MediaProxy mediaProxy = null;
    private boolean enabled = true;
    public static final String NAMESPACE = "http://www.jivesoftware.com/protocol/rtpbridge";

    public MediaProxyService() {
        super("Media Proxy Service");
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.sessionManager = server.getSessionManager();
        String ipAddress = JiveGlobals.getProperty("mediaproxy.externalip", server.getServerInfo().getXMPPDomain());
        this.mediaProxy = new MediaProxy(ipAddress);
        String defaultName = "rtpbridge";
        this.serviceName = JiveGlobals.getProperty("mediaproxy.serviceName", defaultName);
        this.serviceName = this.serviceName.equals("") ? defaultName : this.serviceName;
        this.echoPort = JiveGlobals.getIntProperty("mediaproxy.echoPort", this.echoPort);
        this.routingTable = server.getRoutingTable();
        this.router = server.getPacketRouter();
        this.initMediaProxy();
    }

    @Override
    public void start() {
        if (this.isEnabled()) {
            try {
                this.echo = new Echo(this.echoPort);
                Thread t = new Thread(this.echo);
                t.start();
            }
            catch (SocketException | UnknownHostException iOException) {
                // empty catch block
            }
            this.routingTable.addComponentRoute(this.getAddress(), this);
            XMPPServer.getInstance().getIQDiscoItemsHandler().addServerItemsProvider(this);
        } else {
            if (this.echo != null) {
                this.echo.cancel();
            }
            XMPPServer.getInstance().getIQDiscoItemsHandler().removeComponentItem(this.getAddress().toString());
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.mediaProxy.stopProxy();
        XMPPServer.getInstance().getIQDiscoItemsHandler().removeComponentItem(this.getAddress().toString());
        this.routingTable.removeComponentRoute(this.getAddress());
        if (this.echo != null) {
            this.echo.cancel();
        }
    }

    @Override
    public String getName() {
        return this.serviceName;
    }

    @Override
    public Iterator<DiscoItem> getItems(String name, String node, JID senderJID) {
        return new ArrayList().iterator();
    }

    @Override
    public void process(Packet packet) throws UnauthorizedException, PacketException {
        if (packet instanceof IQ) {
            IQ iq = (IQ)packet;
            if (IQ.Type.error == iq.getType() || IQ.Type.result == iq.getType()) {
                return;
            }
            this.processIQ(iq);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processIQ(IQ iq) {
        reply = IQ.createResultIQ((IQ)iq);
        childElement = iq.getChildElement();
        namespace = childElement.getNamespaceURI();
        childElementCopy = iq.getChildElement().createCopy();
        reply.setChildElement(childElementCopy);
        if ("http://jabber.org/protocol/disco#info".equals(namespace)) {
            reply = XMPPServer.getInstance().getIQDiscoInfoHandler().handleIQ(iq);
            this.router.route(reply);
            return;
        }
        if ("http://jabber.org/protocol/disco#items".equals(namespace)) {
            reply = XMPPServer.getInstance().getIQDiscoItemsHandler().handleIQ(iq);
            this.router.route(reply);
            return;
        }
        if ("http://www.jivesoftware.com/protocol/rtpbridge".equals(namespace) && this.enabled) {
            candidateElement = childElementCopy.element("candidate");
            sid = childElementCopy.attribute("sid").getValue() + "-" + iq.getFrom();
            if (candidateElement != null) {
                childElementCopy.remove(candidateElement);
                candidate = childElementCopy.addElement("candidate ");
                proxyCandidate = this.mediaProxy.addRelayAgent(sid, iq.getFrom().toString());
                MediaProxyService.Log.debug("MediaProxyService: " + sid);
                proxyCandidate.start();
                candidate.addAttribute("name", "voicechannel");
                candidate.addAttribute("ip", this.mediaProxy.getPublicIP());
                candidate.addAttribute("porta", String.valueOf(proxyCandidate.getLocalPortA()));
                candidate.addAttribute("portb", String.valueOf(proxyCandidate.getLocalPortB()));
                candidate.addAttribute("pass", proxyCandidate.getPass());
            } else {
                candidateElement = childElementCopy.element("relay");
                if (candidateElement != null) {
                    session = this.mediaProxy.getSession(sid);
                    MediaProxyService.Log.debug("MediaProxyService: " + sid);
                    if (session != null) {
                        pass = candidateElement.attribute("pass");
                        if (pass != null && pass.getValue().trim().equals(session.getPass().trim())) {
                            portA = candidateElement.attribute("porta");
                            portB = candidateElement.attribute("portb");
                            hostA = candidateElement.attribute("hosta");
                            hostB = candidateElement.attribute("hostb");
                            try {
                                if (hostA == null || portA == null) ** GOTO lbl56
                                for (i = 0; i < 2; ++i) {
                                    session.sendFromPortA(hostB.getValue(), Integer.parseInt(portB.getValue()));
                                }
                            }
                            catch (Exception e) {
                                MediaProxyService.Log.error(e.getMessage(), (Throwable)e);
                            }
                        } else {
                            reply.setError(PacketError.Condition.forbidden);
                        }
                    }
lbl56:
                    // 6 sources

                    childElementCopy.remove(candidateElement);
                } else {
                    candidateElement = childElementCopy.element("publicip");
                    if (candidateElement != null) {
                        childElementCopy.remove(candidateElement);
                        publicIp = childElementCopy.addElement("publicip");
                        try {
                            ip = this.sessionManager.getSession(iq.getFrom()).getHostAddress();
                            if (ip != null) {
                                publicIp.addAttribute("ip", ip);
                            }
                        }
                        catch (UnknownHostException e) {
                            MediaProxyService.Log.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        childElementCopy.remove(candidateElement);
                        reply.setError(PacketError.Condition.forbidden);
                    }
                }
            }
        } else {
            reply.setError(PacketError.Condition.service_unavailable);
        }
        try {
            if (MediaProxyService.Log.isDebugEnabled()) {
                MediaProxyService.Log.debug("MediaProxyService: RETURNED:" + reply.toXML());
            }
            this.router.route(reply);
        }
        catch (Exception e) {
            MediaProxyService.Log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initMediaProxy() {
        try {
            long idleTime = Long.valueOf(JiveGlobals.getProperty("mediaproxy.idleTimeout"));
            this.mediaProxy.setIdleTime(idleTime);
        }
        catch (NumberFormatException idleTime) {
            // empty catch block
        }
        try {
            long lifetime = Long.valueOf(JiveGlobals.getProperty("mediaproxy.lifetime"));
            this.mediaProxy.setLifetime(lifetime);
        }
        catch (NumberFormatException lifetime) {
            // empty catch block
        }
        try {
            int minPort = Integer.valueOf(JiveGlobals.getProperty("mediaproxy.portMin"));
            this.mediaProxy.setMinPort(minPort);
        }
        catch (NumberFormatException minPort) {
            // empty catch block
        }
        try {
            int maxPort = JiveGlobals.getIntProperty("mediaproxy.portMax", this.mediaProxy.getMaxPort());
            this.mediaProxy.setMaxPort(maxPort);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.enabled = JiveGlobals.getBooleanProperty("mediaproxy.enabled");
    }

    public String getServiceDomain() {
        return this.serviceName + "." + XMPPServer.getInstance().getServerInfo().getXMPPDomain();
    }

    @Override
    public JID getAddress() {
        return new JID(null, this.getServiceDomain(), null);
    }

    @Override
    public Iterator<DiscoServerItem> getItems() {
        ArrayList<DiscoServerItem> items = new ArrayList<DiscoServerItem>();
        if (!this.isEnabled()) {
            return items.iterator();
        }
        DiscoServerItem item = new DiscoServerItem(new JID(this.getServiceDomain()), "Media Proxy Service", null, null, this, this);
        items.add(item);
        return items.iterator();
    }

    @Override
    public Iterator<Element> getIdentities(String name, String node, JID senderJID) {
        ArrayList<Element> identities = new ArrayList<Element>();
        Element identity = DocumentHelper.createElement((String)"identity");
        identity.addAttribute("category", "proxy");
        identity.addAttribute("name", "Media Proxy Service");
        identity.addAttribute("type", "rtpbridge");
        identities.add(identity);
        return identities.iterator();
    }

    @Override
    public Iterator<String> getFeatures(String name, String node, JID senderJID) {
        return Arrays.asList(NAMESPACE, "http://jabber.org/protocol/disco#info").iterator();
    }

    @Override
    public DataForm getExtendedInfo(String name, String node, JID senderJID) {
        return null;
    }

    @Override
    public boolean hasInfo(String name, String node, JID senderJID) {
        return true;
    }

    public Collection<MediaProxySession> getAgents() {
        return this.mediaProxy.getSessions();
    }

    public void setKeepAliveDelay(long delay) {
        this.mediaProxy.setIdleTime(delay);
    }

    public long getIdleTime() {
        return this.mediaProxy.getIdleTime();
    }

    public void setMinPort(int minPort) {
        this.mediaProxy.setMinPort(minPort);
    }

    public void setMaxPort(int maxPort) {
        this.mediaProxy.setMaxPort(maxPort);
    }

    public int getMinPort() {
        return this.mediaProxy.getMinPort();
    }

    public int getMaxPort() {
        return this.mediaProxy.getMaxPort();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.isEnabled()) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void stopAgents() {
        this.mediaProxy.stopProxy();
    }

    public long getLifetime() {
        return this.mediaProxy.getLifetime();
    }

    public void setLifetime(long lifetime) {
        this.mediaProxy.setLifetime(lifetime);
    }

    public int getEchoPort() {
        return this.echoPort;
    }

    public void setEchoPort(int echoPort) {
        this.echoPort = echoPort;
    }
}

