/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.lockout;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.lockout.LockOutEventListener;
import org.jivesoftware.openfire.lockout.LockOutFlag;

public class LockOutEventDispatcher {
    private static List<LockOutEventListener> listeners = new CopyOnWriteArrayList<LockOutEventListener>();

    public static void addListener(LockOutEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(LockOutEventListener listener) {
        listeners.remove(listener);
    }

    public static void accountLocked(LockOutFlag flag) {
        if (!listeners.isEmpty()) {
            for (LockOutEventListener listener : listeners) {
                listener.accountLocked(flag);
            }
        }
    }

    public static void accountUnlocked(String username) {
        if (!listeners.isEmpty()) {
            for (LockOutEventListener listener : listeners) {
                listener.accountUnlocked(username);
            }
        }
    }

    public static void lockedAccountDenied(String username) {
        if (!listeners.isEmpty()) {
            for (LockOutEventListener listener : listeners) {
                listener.lockedAccountDenied(username);
            }
        }
    }
}

