/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.ldap;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.AbstractGroupProvider;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class LdapGroupProvider
extends AbstractGroupProvider {
    private static final Logger Log = LoggerFactory.getLogger(LdapGroupProvider.class);
    private LdapManager manager;
    private UserManager userManager;
    private String[] standardAttributes;
    private int groupCount = -1;
    private long expiresStamp = System.currentTimeMillis();

    public LdapGroupProvider() {
        this.manager = LdapManager.getInstance();
        this.userManager = UserManager.getInstance();
        this.standardAttributes = new String[3];
        this.standardAttributes[0] = this.manager.getGroupNameField();
        this.standardAttributes[1] = this.manager.getGroupDescriptionField();
        this.standardAttributes[2] = this.manager.getGroupMemberField();
    }

    @Override
    public Group getGroup(String groupName) throws GroupNotFoundException {
        LdapContext ctx = null;
        try {
            String groupDN = this.manager.findGroupDN(groupName);
            ctx = this.manager.getContext(this.manager.getGroupsBaseDN(groupName));
            Attributes attrs = ctx.getAttributes(groupDN, this.standardAttributes);
            Group group = this.processGroup(ctx, attrs);
            return group;
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            throw new GroupNotFoundException("Group with name " + groupName + " not found.", e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.setRequestControls(null);
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public int getGroupCount() {
        if (this.manager.isDebugEnabled()) {
            Log.debug("LdapGroupProvider: Trying to get the number of groups in the system.");
        }
        if (this.groupCount != -1 && System.currentTimeMillis() < this.expiresStamp) {
            return this.groupCount;
        }
        this.groupCount = this.manager.retrieveListCount(this.manager.getGroupNameField(), MessageFormat.format(this.manager.getGroupSearchFilter(), "*"));
        this.expiresStamp = System.currentTimeMillis() + 300000L;
        return this.groupCount;
    }

    @Override
    public Collection<String> getGroupNames() {
        return this.getGroupNames(-1, -1);
    }

    @Override
    public Collection<String> getGroupNames(int startIndex, int numResults) {
        return this.manager.retrieveList(this.manager.getGroupNameField(), MessageFormat.format(this.manager.getGroupSearchFilter(), "*"), startIndex, numResults, null);
    }

    @Override
    public Collection<String> getGroupNames(JID user) {
        String username;
        XMPPServer server = XMPPServer.getInstance();
        if (!this.manager.isPosixMode()) {
            if (!server.isLocal(user)) {
                return Collections.emptyList();
            }
            username = JID.unescapeNode((String)user.getNode());
            try {
                username = this.manager.findUserDN(username) + "," + this.manager.getUsersBaseDN(username);
            }
            catch (Exception e) {
                Log.error("Could not find user in LDAP " + username);
                return Collections.emptyList();
            }
        } else {
            String string = username = server.isLocal(user) ? JID.unescapeNode((String)user.getNode()) : user.toString();
        }
        if (username == null || "".equals(username)) {
            return Collections.emptyList();
        }
        return this.search(this.manager.getGroupMemberField(), username);
    }

    @Override
    public Collection<String> search(String key, String value) {
        StringBuilder filter = new StringBuilder();
        filter.append("(&");
        filter.append(MessageFormat.format(this.manager.getGroupSearchFilter(), "*"));
        filter.append('(').append(key).append('=').append(LdapManager.sanitizeSearchFilter(value));
        filter.append("))");
        if (Log.isDebugEnabled()) {
            Log.debug("Trying to find group names using query: " + filter.toString());
        }
        return this.manager.retrieveList(this.manager.getGroupNameField(), filter.toString(), -1, -1, null);
    }

    @Override
    public Collection<String> search(String query) {
        return this.search(query, -1, -1);
    }

    @Override
    public Collection<String> search(String query, int startIndex, int numResults) {
        if (query == null || "".equals(query)) {
            return Collections.emptyList();
        }
        StringBuilder filter = new StringBuilder();
        filter.append('(').append(this.manager.getGroupNameField()).append('=').append(LdapManager.sanitizeSearchFilter(query)).append("*)");
        return this.manager.retrieveList(this.manager.getGroupNameField(), filter.toString(), startIndex, numResults, null);
    }

    @Override
    public boolean isSearchSupported() {
        return true;
    }

    private Group processGroup(LdapContext ctx, Attributes a) throws NamingException {
        String description;
        String name;
        String[] stringArray;
        XMPPServer server = XMPPServer.getInstance();
        String serverName = server.getServerInfo().getXMPPDomain();
        Pattern pattern = Pattern.compile("(?i)(^" + this.manager.getUsernameField() + "=)([^,]+)(.+)");
        boolean isAD = this.manager.getUsernameField().equals("sAMAccountName");
        if (isAD) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "distinguishedName";
            stringArray = stringArray2;
            stringArray2[1] = this.manager.getUsernameField();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.manager.getUsernameField();
        }
        String[] returningAttributes = stringArray;
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(returningAttributes);
        if (this.manager.isSubTreeSearch()) {
            searchControls.setSearchScope(2);
        } else {
            searchControls.setSearchScope(1);
        }
        try {
            name = (String)a.get(this.manager.getGroupNameField()).get();
        }
        catch (Exception e) {
            name = "";
        }
        try {
            description = (String)a.get(this.manager.getGroupDescriptionField()).get();
        }
        catch (Exception e) {
            description = "";
        }
        TreeSet<JID> members = new TreeSet<JID>();
        Attribute memberField = a.get(this.manager.getGroupMemberField());
        if (memberField != null) {
            NamingEnumeration<?> ne = memberField.getAll();
            while (ne.hasMore()) {
                String username = (String)ne.next();
                if (!this.manager.isPosixMode()) {
                    try {
                        Matcher matcher = pattern.matcher(username);
                        if (matcher.matches() && matcher.groupCount() == 3) {
                            username = matcher.group(2);
                        } else {
                            LdapName ldapName = new LdapName(username);
                            StringBuilder userFilter = new StringBuilder();
                            userFilter.append("(&(");
                            userFilter.append(ldapName.get(ldapName.size() - 1));
                            userFilter.append(')');
                            userFilter.append(MessageFormat.format(this.manager.getSearchFilter(), "*"));
                            userFilter.append(')');
                            NamingEnumeration<SearchResult> usrAnswer = ctx.search("", userFilter.toString(), searchControls);
                            if (usrAnswer != null && usrAnswer.hasMoreElements()) {
                                SearchResult searchResult = null;
                                while (usrAnswer.hasMoreElements()) {
                                    searchResult = (SearchResult)usrAnswer.nextElement();
                                    Attributes attrs = searchResult.getAttributes();
                                    if (isAD) {
                                        Attribute userdnAttr = attrs.get("distinguishedName");
                                        if (!username.equals((String)userdnAttr.get())) continue;
                                        username = (String)attrs.get(this.manager.getUsernameField()).get();
                                        break;
                                    }
                                    username = (String)attrs.get(this.manager.getUsernameField()).get();
                                    break;
                                }
                            }
                            usrAnswer.close();
                        }
                    }
                    catch (Exception e) {
                        Log.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    JID userJID;
                    int position = username.indexOf("@" + serverName);
                    if (position == -1) {
                        String escapedUsername = JID.escapeNode((String)username);
                        if (!escapedUsername.equals(username)) {
                            this.userManager.getUser(escapedUsername);
                        }
                        userJID = server.createJID(escapedUsername, null);
                    } else {
                        String node = username.substring(0, position);
                        String escapedUsername = JID.escapeNode((String)node);
                        userJID = new JID(escapedUsername + "@" + serverName);
                    }
                    members.add(userJID);
                }
                catch (UserNotFoundException e) {
                    if (!this.manager.isDebugEnabled()) continue;
                    Log.debug("LdapGroupProvider: User not found: " + username);
                }
            }
            ne.close();
        }
        if (this.manager.isDebugEnabled()) {
            Log.debug("LdapGroupProvider: Adding group \"" + name + "\" with " + members.size() + " members.");
        }
        List<JID> admins = Collections.emptyList();
        return new Group(name, description, members, admins);
    }
}

