/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.ldap;

import java.util.ArrayList;
import java.util.Collection;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.jivesoftware.openfire.auth.AuthorizationPolicy;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.jivesoftware.util.JiveGlobals;
import org.xmpp.packet.JID;

public class LdapAuthorizationPolicy
implements AuthorizationPolicy {
    private LdapManager manager;
    private String usernameField;
    private String authorizeField;

    public LdapAuthorizationPolicy() {
        JiveGlobals.migrateProperty("ldap.authorizeField");
        this.manager = LdapManager.getInstance();
        this.usernameField = this.manager.getUsernameField();
        this.authorizeField = JiveGlobals.getProperty("ldap.authorizeField", "k5login");
    }

    @Override
    public boolean authorize(String username, String principal) {
        return this.getAuthorized(username).contains(principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> getAuthorized(String username) {
        username = JID.unescapeNode((String)username);
        ArrayList<String> authorized = new ArrayList<String>();
        Context ctx = null;
        try {
            String userDN = this.manager.findUserDN(username);
            String[] attributes = new String[]{this.usernameField, this.authorizeField};
            ctx = this.manager.getContext();
            Attributes attrs = ctx.getAttributes(userDN, attributes);
            Attribute authorizeField_a = attrs.get(this.authorizeField);
            if (authorizeField_a != null) {
                NamingEnumeration<?> e = authorizeField_a.getAll();
                while (e.hasMoreElements()) {
                    authorized.add((String)e.nextElement());
                }
            }
            ArrayList<String> arrayList = authorized;
            return arrayList;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
        return authorized;
    }

    @Override
    public String name() {
        return "LDAP Authorization Policy";
    }

    @Override
    public String description() {
        return "Provider for authorization using LDAP. Checks if the authenticated principal is in the user's LDAP object using the authorizeField property.";
    }
}

