/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.ldap;

import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.jivesoftware.openfire.auth.AuthorizationMapping;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthorizationMapping
implements AuthorizationMapping {
    private static final Logger Log = LoggerFactory.getLogger(LdapAuthorizationMapping.class);
    private LdapManager manager;
    private String usernameField;
    private String princField;
    private String princSearchFilter;

    public LdapAuthorizationMapping() {
        JiveGlobals.migrateProperty("ldap.princField");
        JiveGlobals.migrateProperty("ldap.princSearchFilter");
        this.manager = LdapManager.getInstance();
        this.usernameField = this.manager.getUsernameField();
        this.princField = JiveGlobals.getProperty("ldap.princField", "k5login");
        this.princSearchFilter = JiveGlobals.getProperty("ldap.princSearchFilter");
        StringBuilder filter = new StringBuilder();
        if (this.princSearchFilter == null) {
            filter.append('(').append(this.princField).append("={0})");
        } else {
            filter.append("(&(").append(this.princField).append("={0})(");
            filter.append(this.princSearchFilter).append("))");
        }
        this.princSearchFilter = filter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String map(String principal) {
        String username = principal;
        Context ctx = null;
        try {
            Log.debug("LdapAuthorizationMapping: Starting LDAP search...");
            String usernameField = this.manager.getUsernameField();
            boolean subTreeSearch = this.manager.isSubTreeSearch();
            ctx = this.manager.getContext();
            SearchControls constraints = new SearchControls();
            if (subTreeSearch) {
                constraints.setSearchScope(2);
            } else {
                constraints.setSearchScope(1);
            }
            constraints.setReturningAttributes(new String[]{usernameField});
            NamingEnumeration<SearchResult> answer = ctx.search("", this.princSearchFilter, new String[]{LdapManager.sanitizeSearchFilter(principal)}, constraints);
            Log.debug("LdapAuthorizationMapping: ... search finished");
            if (answer == null || !answer.hasMoreElements()) {
                Log.debug("LdapAuthorizationMapping: Username based on principal '" + principal + "' not found.");
                String string = principal;
                return string;
            }
            Attributes atrs = answer.next().getAttributes();
            Attribute usernameAttribute = atrs.get(usernameField);
            username = (String)usernameAttribute.get();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
        return username;
    }

    @Override
    public String name() {
        return "LDAP Authorization Mapping";
    }

    @Override
    public String description() {
        return "Provider for authorization using LDAP. Returns the principals default username using the attribute specified in ldap.princField.";
    }
}

