/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.keystore;

import java.io.File;
import java.util.Arrays;

public class CertificateStoreConfiguration {
    protected final String type;
    protected final File file;
    protected final char[] password;

    public CertificateStoreConfiguration(String type, File file, char[] password) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Argument 'type' cannot be null or an empty string.");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 'file' cannot be null.");
        }
        this.type = type;
        this.file = file;
        this.password = password;
    }

    public String getType() {
        return this.type;
    }

    public File getFile() {
        return this.file;
    }

    public char[] getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateStoreConfiguration)) {
            return false;
        }
        CertificateStoreConfiguration that = (CertificateStoreConfiguration)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.file.equals(that.file)) {
            return false;
        }
        return Arrays.equals(this.password, that.password);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.file.hashCode();
        result = 31 * result + (this.password != null ? Arrays.hashCode(this.password) : 0);
        return result;
    }

    public String toString() {
        return "CertificateStoreConfiguration{type='" + this.type + '\'' + ", file=" + this.file + ", password hashcode=" + this.password.hashCode() + '}';
    }
}

