/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import gnu.inet.encoding.StringprepException;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.event.SessionEventDispatcher;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.StreamError;

public class IQBindHandler
extends IQHandler {
    private static final Logger Log = LoggerFactory.getLogger(IQBindHandler.class);
    private IQHandlerInfo info = new IQHandlerInfo("bind", "urn:ietf:params:xml:ns:xmpp-bind");
    private String serverName;
    private RoutingTable routingTable;

    public IQBindHandler() {
        super("Resource Binding handler");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        LocalClientSession session = (LocalClientSession)this.sessionManager.getSession(packet.getFrom());
        if (session == null) {
            Log.error("Error during resource binding. Session not found in " + this.sessionManager.getPreAuthenticatedKeys() + " for key " + packet.getFrom());
            IQ reply = IQ.createResultIQ((IQ)packet);
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.internal_server_error);
            return reply;
        }
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element child = reply.setChildElement("bind", "urn:ietf:params:xml:ns:xmpp-bind");
        String resource = packet.getChildElement().elementTextTrim("resource");
        if (resource == null || resource.length() == 0) {
            resource = session.getAddress().getResource();
        } else {
            try {
                resource = JID.resourceprep((String)resource);
            }
            catch (StringprepException e) {
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.jid_malformed);
                session.process((Packet)reply);
                return null;
            }
        }
        AuthToken authToken = session.getAuthToken();
        if (authToken == null) {
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.not_authorized);
            session.process((Packet)reply);
            return reply;
        }
        if (authToken.isAnonymous()) {
            session.setAnonymousAuth();
        } else {
            String username = authToken.getUsername().toLowerCase();
            ClientSession oldSession = this.routingTable.getClientRoute(new JID(username, this.serverName, resource, true));
            if (oldSession != null) {
                try {
                    int conflictLimit = this.sessionManager.getConflictKickLimit();
                    if (conflictLimit == -1) {
                        reply.setChildElement(packet.getChildElement().createCopy());
                        reply.setError(PacketError.Condition.conflict);
                        session.process((Packet)reply);
                        return null;
                    }
                    int conflictCount = oldSession.incrementConflictCount();
                    if (conflictCount <= conflictLimit) {
                        reply.setChildElement(packet.getChildElement().createCopy());
                        reply.setError(PacketError.Condition.conflict);
                        session.process((Packet)reply);
                        return null;
                    }
                    StreamError error = new StreamError(StreamError.Condition.conflict);
                    oldSession.deliverRawText(error.toXML());
                    oldSession.close();
                }
                catch (Exception e) {
                    Log.error("Error during login", (Throwable)e);
                }
            }
            session.setAuthToken(authToken, resource);
        }
        child.addElement("jid").setText(session.getAddress().toString());
        session.process((Packet)reply);
        SessionEventDispatcher.dispatchEvent(session, SessionEventDispatcher.EventType.resource_bound);
        return null;
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.routingTable = server.getRoutingTable();
        this.serverName = server.getServerInfo().getXMPPDomain();
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }
}

