/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.group.DefaultGroupPropertyMap;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.group.GroupProvider;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public abstract class AbstractGroupProvider
implements GroupProvider {
    private static final Logger Log = LoggerFactory.getLogger(AbstractGroupProvider.class);
    private static final String GROUPLIST_CONTAINERS = "SELECT groupName from ofGroupProp where name='sharedRoster.groupList' AND propValue LIKE ?";
    private static final String PUBLIC_GROUPS = "SELECT groupName from ofGroupProp WHERE name='sharedRoster.showInRoster' AND propValue='everybody'";
    private static final String GROUPS_FOR_PROP = "SELECT groupName from ofGroupProp WHERE name=? AND propValue=?";
    private static final String LOAD_SHARED_GROUPS = "SELECT groupName FROM ofGroupProp WHERE name='sharedRoster.showInRoster' AND propValue IS NOT NULL AND propValue <> 'nobody'";
    private static final String LOAD_PROPERTIES = "SELECT name, propValue FROM ofGroupProp WHERE groupName=?";

    @Override
    public void addMember(String groupName, JID user, boolean administrator) {
        throw new UnsupportedOperationException("Cannot add members to read-only groups");
    }

    @Override
    public void updateMember(String groupName, JID user, boolean administrator) {
        throw new UnsupportedOperationException("Cannot update members for read-only groups");
    }

    @Override
    public void deleteMember(String groupName, JID user) {
        throw new UnsupportedOperationException("Cannot remove members from read-only groups");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Group createGroup(String name) throws GroupAlreadyExistsException {
        throw new UnsupportedOperationException("Cannot create groups via read-only provider");
    }

    @Override
    public void deleteGroup(String name) {
        throw new UnsupportedOperationException("Cannot remove groups via read-only provider");
    }

    @Override
    public void setName(String oldName, String newName) throws GroupAlreadyExistsException {
        throw new UnsupportedOperationException("Cannot modify read-only groups");
    }

    @Override
    public void setDescription(String name, String description) throws GroupNotFoundException {
        throw new UnsupportedOperationException("Cannot modify read-only groups");
    }

    @Override
    public boolean isSearchSupported() {
        return false;
    }

    @Override
    public Collection<String> search(String query) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> search(String query, int startIndex, int numResults) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getSharedGroupNames() {
        HashSet<String> groupNames = new HashSet<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_SHARED_GROUPS);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupNames.add(rs.getString(1));
            }
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return groupNames;
    }

    @Override
    public Collection<String> getSharedGroupNames(JID user) {
        HashSet<String> answer = new HashSet<String>();
        Collection<String> userGroups = this.getGroupNames(user);
        answer.addAll(userGroups);
        for (String userGroup : userGroups) {
            answer.addAll(this.getVisibleGroupNames(userGroup));
        }
        answer.addAll(this.getPublicSharedGroupNames());
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getVisibleGroupNames(String userGroup) {
        HashSet<String> groupNames = new HashSet<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GROUPLIST_CONTAINERS);
            pstmt.setString(1, "%" + userGroup + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupNames.add(rs.getString(1));
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> search(String key, String value) {
        HashSet<String> groupNames = new HashSet<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(GROUPS_FOR_PROP);
            pstmt.setString(1, key);
            pstmt.setString(2, value);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupNames.add(rs.getString(1));
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPublicSharedGroupNames() {
        HashSet<String> groupNames = new HashSet<String>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(PUBLIC_GROUPS);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                groupNames.add(rs.getString(1));
            }
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return groupNames;
    }

    @Override
    public boolean isSharingSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistableMap<String, String> loadProperties(Group group) {
        String name = group.getName();
        DefaultGroupPropertyMap<String, String> result = new DefaultGroupPropertyMap<String, String>(group);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_PROPERTIES);
            pstmt.setString(1, name);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                if (key != null) {
                    if (value == null) {
                        ((HashMap)result).remove(key);
                        Log.warn("Deleted null property " + key + " for group: " + name);
                        continue;
                    }
                    ((PersistableMap)result).put(key, value, false);
                    continue;
                }
                Log.warn("Ignoring null property key for group: " + name);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return result;
    }
}

