/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.filetransfer.proxy;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutableChannelHandler;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.disco.DiscoInfoProvider;
import org.jivesoftware.openfire.disco.DiscoItem;
import org.jivesoftware.openfire.disco.DiscoItemsProvider;
import org.jivesoftware.openfire.disco.DiscoServerItem;
import org.jivesoftware.openfire.disco.ServerItemsProvider;
import org.jivesoftware.openfire.filetransfer.FileTransferManager;
import org.jivesoftware.openfire.filetransfer.proxy.ProxyConnectionManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class FileTransferProxy
extends BasicModule
implements ServerItemsProvider,
DiscoInfoProvider,
DiscoItemsProvider,
RoutableChannelHandler {
    private static final Logger Log = LoggerFactory.getLogger(FileTransferProxy.class);
    public static final String JIVEPROPERTY_PROXY_ENABLED = "xmpp.proxy.enabled";
    public static final String JIVEPROPERTY_PORT = "xmpp.proxy.port";
    public static final String PROPERTY_EXTERNALIP = "xmpp.proxy.externalip";
    public static final boolean DEFAULT_IS_PROXY_ENABLED = true;
    public static final int DEFAULT_PORT = 7777;
    private String proxyServiceName;
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://jabber.org/protocol/bytestreams");
    private RoutingTable routingTable;
    private PacketRouter router;
    private ProxyConnectionManager connectionManager;
    private InetAddress bindInterface;

    public FileTransferProxy() {
        super("SOCKS5 file transfer proxy");
        PropertyEventDispatcher.addListener(new FileTransferPropertyListener());
    }

    public boolean handleIQ(IQ packet) throws UnauthorizedException {
        Element childElement = packet.getChildElement();
        String namespace = null;
        if (packet.getType() == IQ.Type.error) {
            return true;
        }
        if (childElement != null) {
            namespace = childElement.getNamespaceURI();
        }
        if ("http://jabber.org/protocol/disco#info".equals(namespace)) {
            IQ reply = XMPPServer.getInstance().getIQDiscoInfoHandler().handleIQ(packet);
            this.router.route(reply);
            return true;
        }
        if ("http://jabber.org/protocol/disco#items".equals(namespace)) {
            IQ reply = XMPPServer.getInstance().getIQDiscoItemsHandler().handleIQ(packet);
            this.router.route(reply);
            return true;
        }
        if ("http://jabber.org/protocol/bytestreams".equals(namespace)) {
            if (packet.getType() == IQ.Type.get) {
                IQ reply = IQ.createResultIQ((IQ)packet);
                Element newChild = reply.setChildElement("query", "http://jabber.org/protocol/bytestreams");
                String externalIP = JiveGlobals.getProperty(PROPERTY_EXTERNALIP);
                if (externalIP != null && !externalIP.isEmpty()) {
                    Element response = newChild.addElement("streamhost");
                    response.addAttribute("jid", this.getServiceDomain());
                    response.addAttribute("host", externalIP);
                    response.addAttribute("port", String.valueOf(this.connectionManager.getProxyPort()));
                } else {
                    for (InetAddress address : this.getAddresses()) {
                        Element response = newChild.addElement("streamhost");
                        response.addAttribute("jid", this.getServiceDomain());
                        response.addAttribute("host", address.getHostAddress());
                        response.addAttribute("port", String.valueOf(this.connectionManager.getProxyPort()));
                    }
                }
                this.router.route(reply);
                return true;
            }
            if (packet.getType() == IQ.Type.set) {
                String sid = childElement.attributeValue("sid");
                JID from = packet.getFrom();
                JID to = new JID(childElement.elementTextTrim("activate"));
                IQ reply = IQ.createResultIQ((IQ)packet);
                try {
                    this.connectionManager.activate(from, to, sid);
                }
                catch (IllegalArgumentException ie) {
                    Log.error("Error activating connection", (Throwable)ie);
                    reply.setType(IQ.Type.error);
                    reply.setError(new PacketError(PacketError.Condition.not_allowed));
                }
                this.router.route(reply);
                return true;
            }
        }
        return false;
    }

    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.proxyServiceName = JiveGlobals.getProperty("xmpp.proxy.service", "proxy");
        this.routingTable = server.getRoutingTable();
        this.router = server.getPacketRouter();
        this.connectionManager = new ProxyConnectionManager(this.getFileTransferManager(server));
    }

    private Set<InetAddress> getAddresses() {
        String interfaceName = JiveGlobals.getXMLProperty("network.interface");
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        if (interfaceName != null && !interfaceName.trim().isEmpty()) {
            try {
                this.bindInterface = InetAddress.getByName(interfaceName.trim());
                result.add(this.bindInterface);
                return result;
            }
            catch (UnknownHostException e) {
                Log.error("Error binding to network.interface '{}'", (Object)interfaceName, (Object)e);
            }
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    result.add(inetAddresses.nextElement());
                }
            }
        }
        catch (SocketException e) {
            Log.error("Error determining all addresses for this server", (Throwable)e);
        }
        return result;
    }

    private FileTransferManager getFileTransferManager(XMPPServer server) {
        return server.getFileTransferManager();
    }

    @Override
    public void start() {
        super.start();
        if (this.isEnabled()) {
            this.startProxy();
        } else {
            XMPPServer.getInstance().getIQDiscoItemsHandler().removeServerItemsProvider(this);
        }
    }

    private void startProxy() {
        this.connectionManager.processConnections(this.bindInterface, this.getProxyPort());
        this.routingTable.addComponentRoute(this.getAddress(), this);
        XMPPServer server = XMPPServer.getInstance();
        server.getIQDiscoItemsHandler().addServerItemsProvider(this);
    }

    @Override
    public void stop() {
        super.stop();
        XMPPServer.getInstance().getIQDiscoItemsHandler().removeComponentItem(this.getAddress().toString());
        this.routingTable.removeComponentRoute(this.getAddress());
        this.connectionManager.disable();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.connectionManager.shutdown();
    }

    public void enableFileTransferProxy(boolean isEnabled) {
        JiveGlobals.setProperty(JIVEPROPERTY_PROXY_ENABLED, Boolean.toString(isEnabled));
        this.setEnabled(isEnabled);
    }

    private void setEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.startProxy();
        } else {
            this.stop();
        }
    }

    public boolean isProxyEnabled() {
        return this.connectionManager.isRunning() && JiveGlobals.getBooleanProperty(JIVEPROPERTY_PROXY_ENABLED, true);
    }

    private boolean isEnabled() {
        return JiveGlobals.getBooleanProperty(JIVEPROPERTY_PROXY_ENABLED, true);
    }

    public void setProxyPort(int port) {
        JiveGlobals.setProperty(JIVEPROPERTY_PORT, Integer.toString(port));
    }

    public int getProxyPort() {
        return JiveGlobals.getIntProperty(JIVEPROPERTY_PORT, 7777);
    }

    public String getServiceDomain() {
        return this.proxyServiceName + "." + XMPPServer.getInstance().getServerInfo().getXMPPDomain();
    }

    @Override
    public JID getAddress() {
        return new JID(null, this.getServiceDomain(), null);
    }

    @Override
    public Iterator<DiscoServerItem> getItems() {
        if (!this.isEnabled()) {
            return Collections.emptyIterator();
        }
        DiscoServerItem item = new DiscoServerItem(new JID(this.getServiceDomain()), "Socks 5 Bytestreams Proxy", null, null, this, this);
        return Collections.singleton(item).iterator();
    }

    @Override
    public Iterator<Element> getIdentities(String name, String node, JID senderJID) {
        Element identity = DocumentHelper.createElement((String)"identity");
        identity.addAttribute("category", "proxy");
        identity.addAttribute("name", "SOCKS5 Bytestreams Service");
        identity.addAttribute("type", "bytestreams");
        return Collections.singleton(identity).iterator();
    }

    @Override
    public Iterator<String> getFeatures(String name, String node, JID senderJID) {
        return Arrays.asList("http://jabber.org/protocol/bytestreams", "http://jabber.org/protocol/disco#info").iterator();
    }

    @Override
    public DataForm getExtendedInfo(String name, String node, JID senderJID) {
        return null;
    }

    @Override
    public boolean hasInfo(String name, String node, JID senderJID) {
        return true;
    }

    @Override
    public Iterator<DiscoItem> getItems(String name, String node, JID senderJID) {
        return new ArrayList().iterator();
    }

    @Override
    public void process(Packet packet) throws UnauthorizedException, PacketException {
        if (packet instanceof IQ && !this.handleIQ((IQ)packet)) {
            IQ reply = IQ.createResultIQ((IQ)((IQ)packet));
            reply.setChildElement(((IQ)packet).getChildElement().createCopy());
            reply.setError(PacketError.Condition.feature_not_implemented);
            this.router.route(reply);
        }
    }

    private class FileTransferPropertyListener
    implements PropertyEventListener {
        private FileTransferPropertyListener() {
        }

        public void propertySet(String property, Map params) {
            if (FileTransferProxy.this.isEnabled() && FileTransferProxy.JIVEPROPERTY_PORT.equalsIgnoreCase(property)) {
                FileTransferProxy.this.setEnabled(false);
                FileTransferProxy.this.setEnabled(true);
            }
            if (FileTransferProxy.JIVEPROPERTY_PROXY_ENABLED.equalsIgnoreCase(property)) {
                Object value = params.get("value");
                boolean isEnabled = value != null ? Boolean.parseBoolean(value.toString()) : true;
                FileTransferProxy.this.setEnabled(isEnabled);
            }
        }

        public void propertyDeleted(String property, Map params) {
            if (FileTransferProxy.JIVEPROPERTY_PROXY_ENABLED.equalsIgnoreCase(property)) {
                FileTransferProxy.this.setEnabled(true);
            }
            if (FileTransferProxy.this.isEnabled() && FileTransferProxy.JIVEPROPERTY_PORT.equalsIgnoreCase(property)) {
                FileTransferProxy.this.setEnabled(false);
                FileTransferProxy.this.setEnabled(true);
            }
        }

        public void xmlPropertySet(String property, Map params) {
        }

        public void xmlPropertyDeleted(String property, Map params) {
        }
    }
}

