/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.event.SessionEventListener;
import org.jivesoftware.openfire.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionEventDispatcher {
    private static final Logger Log = LoggerFactory.getLogger(SessionEventDispatcher.class);
    private static List<SessionEventListener> listeners = new CopyOnWriteArrayList<SessionEventListener>();

    private SessionEventDispatcher() {
    }

    public static void addListener(SessionEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(SessionEventListener listener) {
        listeners.remove(listener);
    }

    public static void dispatchEvent(Session session, EventType eventType) {
        for (SessionEventListener listener : listeners) {
            try {
                switch (eventType) {
                    case session_created: {
                        listener.sessionCreated(session);
                        break;
                    }
                    case session_destroyed: {
                        listener.sessionDestroyed(session);
                        break;
                    }
                    case anonymous_session_created: {
                        listener.anonymousSessionCreated(session);
                        break;
                    }
                    case anonymous_session_destroyed: {
                        listener.anonymousSessionDestroyed(session);
                        break;
                    }
                    case resource_bound: {
                        listener.resourceBound(session);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static enum EventType {
        session_created,
        session_destroyed,
        anonymous_session_created,
        anonymous_session_destroyed,
        resource_bound;

    }
}

