/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.disco;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.ClusterEventListener;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.disco.DiscoItem;
import org.jivesoftware.openfire.disco.DiscoItemsProvider;
import org.jivesoftware.openfire.disco.DiscoServerItem;
import org.jivesoftware.openfire.disco.IQDiscoInfoHandler;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.disco.ServerItemsProvider;
import org.jivesoftware.openfire.disco.UserItemsProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;
import org.xmpp.resultsetmanagement.ResultSet;
import org.xmpp.resultsetmanagement.ResultSetImpl;

public class IQDiscoItemsHandler
extends IQHandler
implements ServerFeaturesProvider,
ClusterEventListener,
UserItemsProvider {
    public static final String NAMESPACE_DISCO_ITEMS = "http://jabber.org/protocol/disco#items";
    private Map<String, DiscoItemsProvider> entities = new HashMap<String, DiscoItemsProvider>();
    private Map<String, Element> localServerItems = new HashMap<String, Element>();
    private Cache<String, ClusteredServerItem> serverItems;
    private Map<String, DiscoItemsProvider> serverNodeProviders = new ConcurrentHashMap<String, DiscoItemsProvider>();
    private IQHandlerInfo info = new IQHandlerInfo("query", "http://jabber.org/protocol/disco#items");
    private IQDiscoInfoHandler infoHandler;

    public IQDiscoItemsHandler() {
        super("XMPP Disco Items Handler");
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public IQ handleIQ(IQ packet) {
        IQ reply = IQ.createResultIQ((IQ)packet);
        if (IQ.Type.set == packet.getType()) {
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.feature_not_implemented);
            return reply;
        }
        DiscoItemsProvider itemsProvider = null;
        itemsProvider = packet.getTo() == null || packet.getTo().asBareJID().equals((Object)packet.getFrom().asBareJID()) ? this.getProvider(XMPPServer.getInstance().getServerInfo().getXMPPDomain()) : this.getProvider(packet.getTo().getDomain());
        if (itemsProvider != null) {
            Element iq;
            String node;
            Iterator<DiscoItem> itemsItr;
            String name;
            String string = name = packet.getTo() == null ? null : packet.getTo().getNode();
            if (name == null || name.trim().length() == 0) {
                name = null;
            }
            if ((itemsItr = itemsProvider.getItems(name, node = (iq = packet.getChildElement()).attributeValue("node"), packet.getFrom())) != null) {
                boolean applyRSM;
                reply.setChildElement(iq.createCopy());
                Element queryElement = reply.getChildElement();
                Element rsmElement = packet.getChildElement().element(QName.get((String)"set", (String)"http://jabber.org/protocol/rsm"));
                boolean bl = applyRSM = rsmElement != null && itemsItr.hasNext();
                if (applyRSM) {
                    List rsmResults;
                    if (!ResultSet.isValidRSMRequest((Element)rsmElement)) {
                        reply.setError(PacketError.Condition.bad_request);
                        return reply;
                    }
                    ArrayList<DiscoItem> allItems = new ArrayList<DiscoItem>();
                    while (itemsItr.hasNext()) {
                        allItems.add(itemsItr.next());
                    }
                    ResultSetImpl rs = new ResultSetImpl(allItems);
                    try {
                        rsmResults = rs.applyRSMDirectives(rsmElement);
                    }
                    catch (NullPointerException e) {
                        IQ itemNotFound = IQ.createResultIQ((IQ)packet);
                        itemNotFound.setError(PacketError.Condition.item_not_found);
                        return itemNotFound;
                    }
                    for (DiscoItem item : rsmResults) {
                        Element resultElement = item.getElement();
                        resultElement.setQName(new QName(resultElement.getName(), queryElement.getNamespace()));
                        queryElement.add(resultElement.createCopy());
                    }
                    queryElement.remove(queryElement.element(QName.get((String)"set", (String)"http://jabber.org/protocol/rsm")));
                    queryElement.add(rs.generateSetElementFromResults(rsmResults));
                } else {
                    while (itemsItr.hasNext()) {
                        Element item = itemsItr.next().getElement();
                        item.setQName(new QName(item.getName(), queryElement.getNamespace()));
                        queryElement.add(item.createCopy());
                    }
                }
            } else {
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.item_not_found);
            }
        } else {
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.item_not_found);
        }
        return reply;
    }

    private DiscoItemsProvider getProvider(String name) {
        return this.entities.get(name);
    }

    protected void setProvider(String name, DiscoItemsProvider provider) {
        this.entities.put(name, provider);
    }

    protected void removeProvider(String name) {
        this.entities.remove(name);
    }

    public void addServerItemsProvider(ServerItemsProvider provider) {
        Iterator<DiscoServerItem> items = provider.getItems();
        if (items == null) {
            return;
        }
        while (items.hasNext()) {
            DiscoServerItem discoItem = items.next();
            this.addComponentItem(discoItem.getJID().toString(), discoItem.getNode(), discoItem.getName());
            String host = discoItem.getJID().getDomain();
            this.infoHandler.setProvider(host, discoItem.getDiscoInfoProvider());
            this.setProvider(host, discoItem.getDiscoItemsProvider());
        }
    }

    public void removeServerItemsProvider(ServerItemsProvider provider) {
        Iterator<DiscoServerItem> items = provider.getItems();
        if (items == null) {
            return;
        }
        while (items.hasNext()) {
            DiscoServerItem discoItem = items.next();
            this.removeComponentItem(discoItem.getJID().toString());
            String host = discoItem.getJID().getDomain();
            this.infoHandler.removeProvider(host);
            this.removeProvider(host);
        }
    }

    public void setServerNodeInfoProvider(String node, DiscoItemsProvider provider) {
        this.serverNodeProviders.put(node, provider);
    }

    public void removeServerNodeInfoProvider(String node) {
        this.serverNodeProviders.remove(node);
    }

    public void addComponentItem(String jid, String name) {
        this.addComponentItem(jid, null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponentItem(String jid, String node, String name) {
        Lock lock = CacheFactory.getLock(jid, this.serverItems);
        try {
            lock.lock();
            ClusteredServerItem item = (ClusteredServerItem)this.serverItems.get(jid);
            if (item == null) {
                item = new ClusteredServerItem();
                Element element = DocumentHelper.createElement((String)"item");
                element.addAttribute("jid", jid);
                element.addAttribute("node", node);
                element.addAttribute("name", name);
                item.element = element;
            }
            if (item.nodes.add(XMPPServer.getInstance().getNodeID())) {
                this.serverItems.put(jid, item);
            }
            this.localServerItems.put(jid, item.element);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponentItem(String jid) {
        if (this.serverItems == null) {
            return;
        }
        Lock lock = CacheFactory.getLock(jid, this.serverItems);
        try {
            lock.lock();
            ClusteredServerItem item = (ClusteredServerItem)this.serverItems.get(jid);
            if (item != null && item.nodes.remove(XMPPServer.getInstance().getNodeID())) {
                if (item.nodes.isEmpty()) {
                    this.serverItems.remove(jid);
                } else {
                    this.serverItems.put(jid, item);
                }
            }
        }
        finally {
            lock.unlock();
        }
        this.localServerItems.remove(jid);
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.serverItems = CacheFactory.createCache("Disco Server Items");
        this.infoHandler = server.getIQDiscoInfoHandler();
        this.setProvider(server.getServerInfo().getXMPPDomain(), this.getServerItemsProvider());
        ClusterManager.addListener(this);
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        for (ServerItemsProvider provider : XMPPServer.getInstance().getServerItemsProviders()) {
            this.addServerItemsProvider(provider);
        }
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton(NAMESPACE_DISCO_ITEMS).iterator();
    }

    @Override
    public void joinedCluster() {
        this.restoreCacheContent();
    }

    @Override
    public void joinedCluster(byte[] nodeID) {
    }

    @Override
    public void leftCluster() {
        if (!XMPPServer.getInstance().isShuttingDown()) {
            this.restoreCacheContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leftCluster(byte[] nodeID) {
        if (ClusterManager.isSeniorClusterMember()) {
            NodeID leftNode = NodeID.getInstance(nodeID);
            for (Map.Entry entry : this.serverItems.entrySet()) {
                String jid = (String)entry.getKey();
                Lock lock = CacheFactory.getLock(jid, this.serverItems);
                try {
                    lock.lock();
                    ClusteredServerItem item = (ClusteredServerItem)entry.getValue();
                    if (!item.nodes.remove(leftNode)) continue;
                    if (item.nodes.isEmpty()) {
                        this.serverItems.remove(jid);
                        continue;
                    }
                    this.serverItems.put(jid, item);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @Override
    public void markedAsSeniorClusterMember() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCacheContent() {
        for (Map.Entry<String, Element> entry : this.localServerItems.entrySet()) {
            String jid = entry.getKey();
            Element element = entry.getValue();
            Lock lock = CacheFactory.getLock(jid, this.serverItems);
            try {
                lock.lock();
                ClusteredServerItem item = (ClusteredServerItem)this.serverItems.get(jid);
                if (item == null) {
                    item = new ClusteredServerItem();
                    item.element = element;
                }
                if (!item.nodes.add(XMPPServer.getInstance().getNodeID())) continue;
                this.serverItems.put(jid, item);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private DiscoItemsProvider getServerItemsProvider() {
        return new DiscoItemsProvider(){

            @Override
            public Iterator<DiscoItem> getItems(String name, String node, JID senderJID) {
                if (node != null) {
                    if (IQDiscoItemsHandler.this.serverNodeProviders.get(node) != null) {
                        return ((DiscoItemsProvider)IQDiscoItemsHandler.this.serverNodeProviders.get(node)).getItems(name, node, senderJID);
                    }
                    return null;
                }
                if (name == null) {
                    ArrayList<DiscoItem> answer = new ArrayList<DiscoItem>();
                    for (ClusteredServerItem item : IQDiscoItemsHandler.this.serverItems.values()) {
                        answer.add(new DiscoItem(item.element));
                    }
                    return answer.iterator();
                }
                List<UserItemsProvider> itemsProviders = XMPPServer.getInstance().getUserItemsProviders();
                if (itemsProviders.isEmpty()) {
                    return null;
                }
                ArrayList<DiscoItem> answer = new ArrayList<DiscoItem>();
                for (UserItemsProvider itemsProvider : itemsProviders) {
                    Iterator<Element> itemsItr = itemsProvider.getUserItems(name, senderJID);
                    if (itemsItr == null) continue;
                    while (itemsItr.hasNext()) {
                        Element item = itemsItr.next();
                        JID itemJid = new JID(item.attributeValue("jid"));
                        String itemName = item.attributeValue("name");
                        String itemNode = item.attributeValue("node");
                        String itemAction = item.attributeValue("action");
                        answer.add(new DiscoItem(itemJid, itemName, itemNode, itemAction));
                    }
                }
                return answer.iterator();
            }
        };
    }

    @Override
    public Iterator<Element> getUserItems(String name, JID senderJID) {
        ArrayList<Element> answer = new ArrayList<Element>();
        try {
            User user = UserManager.getInstance().getUser(name);
            RosterItem item = user.getRoster().getRosterItem(senderJID);
            if (item.getSubStatus() == RosterItem.SUB_FROM || item.getSubStatus() == RosterItem.SUB_BOTH) {
                for (Session session : SessionManager.getInstance().getSessions(name)) {
                    Element element = DocumentHelper.createElement((String)"item");
                    element.addAttribute("jid", session.getAddress().toString());
                    answer.add(element);
                }
            }
            return answer.iterator();
        }
        catch (UserNotFoundException e) {
            return answer.iterator();
        }
    }

    private static class ClusteredServerItem
    implements Externalizable {
        private Element element;
        private Set<NodeID> nodes = new HashSet<NodeID>();

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)((DefaultElement)this.element));
            ExternalizableUtil.getInstance().writeExternalizableCollection(out, this.nodes);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.element = (Element)ExternalizableUtil.getInstance().readSerializable(in);
            ExternalizableUtil.getInstance().readExternalizableCollection(in, this.nodes, this.getClass().getClassLoader());
        }
    }
}

