/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.crowd;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jivesoftware.openfire.crowd.CrowdGroupProvider;
import org.jivesoftware.openfire.crowd.CrowdManager;
import org.jivesoftware.openfire.crowd.jaxb.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdUserProvider
implements UserProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdUserProvider.class);
    private static final int CACHE_TTL = 3600;
    private static final String JIVE_CROWD_USERS_CACHE_TTL_SECS = "crowd.users.cache.ttl.seconds";
    private static final String SEARCH_FIELD_USERNAME = "Username";
    private static final String SEARCH_FIELD_NAME = "Name";
    private static final String SEARCH_FIELD_EMAIL = "Email";
    private static final Set<String> SEARCH_FIELDS = new TreeSet<String>(Arrays.asList("Username", "Name", "Email"));
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ScheduledExecutorService crowdUserSync = Executors.newSingleThreadScheduledExecutor();
    private Map<String, User> usersCache = new TreeMap<String, User>();
    private List<User> users = new ArrayList<User>();

    public CrowdUserProvider() {
        String propertyValue = JiveGlobals.getProperty(JIVE_CROWD_USERS_CACHE_TTL_SECS);
        int ttl = propertyValue == null || propertyValue.trim().length() == 0 ? 3600 : Integer.parseInt(propertyValue);
        this.crowdUserSync.scheduleAtFixedRate(new UserSynch(this), 0L, ttl, TimeUnit.SECONDS);
        JiveGlobals.setProperty(JIVE_CROWD_USERS_CACHE_TTL_SECS, String.valueOf(ttl));
        new CrowdGroupProvider();
    }

    @Override
    public org.jivesoftware.openfire.user.User loadUser(String username) throws UserNotFoundException {
        this.lock.readLock().lock();
        try {
            org.jivesoftware.openfire.user.User user = this.getCrowdUser(username).getOpenfireUser();
            return user;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public User getCrowdUser(String username) throws UserNotFoundException {
        this.lock.readLock().lock();
        try {
            if (this.usersCache.containsKey(username)) {
                User user = this.usersCache.get(username);
                return user;
            }
            throw new UserNotFoundException("User : '" + String.valueOf(username) + "'");
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getUserCount() {
        this.lock.readLock().lock();
        try {
            int n = this.usersCache.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<org.jivesoftware.openfire.user.User> getUsers() {
        this.lock.readLock().lock();
        try {
            ArrayList<org.jivesoftware.openfire.user.User> results = new ArrayList<org.jivesoftware.openfire.user.User>();
            for (User user : this.usersCache.values()) {
                results.add(user.getOpenfireUser());
            }
            ArrayList<org.jivesoftware.openfire.user.User> arrayList = results;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<String> getUsernames() {
        this.lock.readLock().lock();
        try {
            Set<String> set = this.usersCache.keySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<org.jivesoftware.openfire.user.User> getUsers(int startIndex, int numResults) {
        this.lock.readLock().lock();
        try {
            ArrayList<org.jivesoftware.openfire.user.User> results = new ArrayList<org.jivesoftware.openfire.user.User>(numResults);
            int i = 0;
            for (int j = startIndex; i < numResults && j < this.users.size(); ++i, ++j) {
                results.add(this.users.get(j).getOpenfireUser());
            }
            ArrayList<org.jivesoftware.openfire.user.User> arrayList = results;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<String> getSearchFields() throws UnsupportedOperationException {
        return SEARCH_FIELDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<org.jivesoftware.openfire.user.User> findUsers(Set<String> fields, String query) throws UnsupportedOperationException {
        this.lock.readLock().lock();
        try {
            ArrayList<org.jivesoftware.openfire.user.User> results = new ArrayList<org.jivesoftware.openfire.user.User>();
            if (query != null && query.trim().length() > 0) {
                if (query.endsWith("*")) {
                    query = query.substring(0, query.length() - 1);
                }
                if (query.startsWith("*")) {
                    query = query.substring(1);
                }
                query = query.toLowerCase();
                if (SEARCH_FIELDS.containsAll(fields)) {
                    if (fields.contains(SEARCH_FIELD_USERNAME)) {
                        for (User user : this.users) {
                            if (!user.name.toLowerCase().contains(query)) continue;
                            results.add(user.getOpenfireUser());
                        }
                    } else if (fields.contains(SEARCH_FIELD_NAME)) {
                        for (User user : this.users) {
                            if (!user.displayName.toLowerCase().contains(query)) continue;
                            results.add(user.getOpenfireUser());
                        }
                    } else {
                        for (User user : this.users) {
                            if (!user.email.toLowerCase().contains(query)) continue;
                            results.add(user.getOpenfireUser());
                        }
                    }
                }
            }
            Iterator<User> iterator = results;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<org.jivesoftware.openfire.user.User> findUsers(Set<String> fields, String query, int startIndex, int numResults) throws UnsupportedOperationException {
        this.lock.readLock().lock();
        try {
            ArrayList foundUsers = (ArrayList)this.findUsers(fields, query);
            ArrayList<org.jivesoftware.openfire.user.User> results = new ArrayList<org.jivesoftware.openfire.user.User>(foundUsers.size());
            int i = 0;
            for (int j = startIndex; i < numResults && j < foundUsers.size(); ++i, ++j) {
                results.add((org.jivesoftware.openfire.user.User)foundUsers.get(j));
            }
            ArrayList<org.jivesoftware.openfire.user.User> arrayList = results;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isNameRequired() {
        return false;
    }

    @Override
    public boolean isEmailRequired() {
        return false;
    }

    @Override
    public org.jivesoftware.openfire.user.User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        throw new UnsupportedOperationException("Create new user not implemented by this version of user provider");
    }

    @Override
    public void deleteUser(String username) {
        throw new UnsupportedOperationException("Delete a user not implemented by this version of user provider");
    }

    @Override
    public void setName(String username, String name) throws UserNotFoundException {
        throw new UnsupportedOperationException("Setting user name not implemented by this version of user provider");
    }

    @Override
    public void setEmail(String username, String email) throws UserNotFoundException {
        throw new UnsupportedOperationException("Setting user email not implemented by this version of user provider");
    }

    @Override
    public void setCreationDate(String username, Date creationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException("Setting user creation date unsupported by this version of user provider");
    }

    @Override
    public void setModificationDate(String username, Date modificationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException("Setting user modification date unsupported by this version of user provider");
    }

    static class UserSynch
    implements Runnable {
        CrowdUserProvider userProvider;

        public UserSynch(CrowdUserProvider userProvider) {
            this.userProvider = userProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("running synch with crowd...");
            CrowdManager manager = null;
            try {
                manager = CrowdManager.getInstance();
            }
            catch (Exception e) {
                LOG.error("Failure to load the Crowd manager", (Throwable)e);
                return;
            }
            List<User> allUsers = null;
            try {
                allUsers = manager.getAllUsers();
            }
            catch (RemoteException re) {
                LOG.error("Failure to fetch all crowd users", (Throwable)re);
                return;
            }
            if (allUsers != null && allUsers.size() > 0) {
                TreeMap<String, User> usersMap = new TreeMap<String, User>();
                for (User user : allUsers) {
                    usersMap.put(user.name, user);
                }
                this.userProvider.lock.writeLock().lock();
                try {
                    this.userProvider.users = allUsers;
                    this.userProvider.usersCache = usersMap;
                }
                finally {
                    this.userProvider.lock.writeLock().unlock();
                }
            }
            LOG.info("crowd synch done, returned " + allUsers.size() + " users");
        }
    }
}

