/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.container.PluginMetadata;
import org.jivesoftware.util.ParamUtils;

public class PluginIconServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        URL icon;
        String canonicalName = ParamUtils.getParameter(request, "plugin");
        PluginManager pluginManager = XMPPServer.getInstance().getPluginManager();
        PluginMetadata metadata = pluginManager.getMetadata(canonicalName);
        if (metadata != null && (icon = metadata.getIcon()) != null) {
            response.reset();
            if (icon.toExternalForm().toLowerCase().endsWith(".png")) {
                response.setContentType("image/png");
            } else if (icon.toExternalForm().toLowerCase().endsWith(".png")) {
                response.setContentType("image/gif");
            }
            try (InputStream in = icon.openStream();
                 ServletOutputStream ost = response.getOutputStream();){
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) >= 0) {
                    ost.write(buf, 0, len);
                }
                ost.flush();
            }
            catch (IOException ioe) {
                throw new ServletException((Throwable)ioe);
            }
        }
    }
}

