/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.AdminConsolePlugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class GetAdminConsoleInfoTask
implements ClusterTask<GetAdminConsoleInfoTask> {
    private String bindInterface;
    private int adminPort;
    private int adminSecurePort;
    private String adminSecret;

    @Override
    public GetAdminConsoleInfoTask getResult() {
        return this;
    }

    @Override
    public void run() {
        PluginManager pluginManager = XMPPServer.getInstance().getPluginManager();
        AdminConsolePlugin adminConsolePlugin = (AdminConsolePlugin)pluginManager.getPlugin("admin");
        this.bindInterface = adminConsolePlugin.getBindInterface();
        this.adminPort = adminConsolePlugin.getAdminUnsecurePort();
        this.adminSecurePort = adminConsolePlugin.getAdminSecurePort();
        this.adminSecret = AdminConsolePlugin.secret;
        if (this.bindInterface == null) {
            Enumeration<NetworkInterface> nets = null;
            try {
                nets = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException e) {
                return;
            }
            for (NetworkInterface netInterface : Collections.list(nets)) {
                boolean found = false;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                for (InetAddress address : Collections.list(addresses)) {
                    if ("127.0.0.1".equals(address.getHostAddress()) || "0:0:0:0:0:0:0:1".equals(address.getHostAddress())) continue;
                    Socket socket = new Socket();
                    InetSocketAddress remoteAddress = new InetSocketAddress(address, this.adminPort > 0 ? this.adminPort : this.adminSecurePort);
                    try {
                        socket.connect(remoteAddress);
                        this.bindInterface = address.getHostAddress();
                        found = true;
                        break;
                    }
                    catch (IOException iOException) {
                    }
                }
                if (!found) continue;
                break;
            }
        }
    }

    public String getBindInterface() {
        return this.bindInterface;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public int getAdminSecurePort() {
        return this.adminSecurePort;
    }

    public String getAdminSecret() {
        return this.adminSecret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeInt(out, this.adminPort);
        ExternalizableUtil.getInstance().writeInt(out, this.adminSecurePort);
        ExternalizableUtil.getInstance().writeBoolean(out, this.bindInterface != null);
        if (this.bindInterface != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.bindInterface);
        }
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.adminSecret);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.adminPort = ExternalizableUtil.getInstance().readInt(in);
        this.adminSecurePort = ExternalizableUtil.getInstance().readInt(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.bindInterface = ExternalizableUtil.getInstance().readSafeUTF(in);
        }
        this.adminSecret = ExternalizableUtil.getInstance().readSafeUTF(in);
    }
}

