/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin.user;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class DeleteUser
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#delete-user";
    }

    @Override
    public String getDefaultLabel() {
        return "Delete a User";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public void execute(SessionData sessionData, Element command) {
        JID account;
        Element note = command.addElement("note");
        if (UserManager.getUserProvider().isReadOnly()) {
            note.addAttribute("type", "error");
            note.setText("User provider is read only. Users cannot be deleted.");
            return;
        }
        Map<String, List<String>> data = sessionData.getData();
        try {
            account = new JID(this.get(data, "accountjid", 0));
        }
        catch (NullPointerException npe) {
            note.addAttribute("type", "error");
            note.setText("JID required parameter.");
            return;
        }
        if (!XMPPServer.getInstance().isLocal(account)) {
            note.addAttribute("type", "error");
            note.setText("Cannot delete remote user.");
            return;
        }
        try {
            User user = UserManager.getInstance().getUser(account.getNode());
            UserManager.getInstance().deleteUser(user);
        }
        catch (UserNotFoundException e) {
            note.addAttribute("type", "error");
            note.setText("User not found.");
            return;
        }
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Deleting a user");
        form.addInstruction("Fill out this form to delete a user.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.jid_single);
        field.setLabel("The Jabber ID for the account to be deleted");
        field.setVariable("accountjid");
        field.setRequired(true);
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return (super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester)) && !UserManager.getUserProvider().isReadOnly();
    }
}

