/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin.user;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.StringUtils;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class AddUser
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#add-user";
    }

    @Override
    public String getDefaultLabel() {
        return "Add a User";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public void execute(SessionData sessionData, Element command) {
        JID account;
        Element note = command.addElement("note");
        if (UserManager.getUserProvider().isReadOnly()) {
            note.addAttribute("type", "error");
            note.setText("User provider is read only. New users cannot be created.");
            return;
        }
        Map<String, List<String>> data = sessionData.getData();
        try {
            account = new JID(this.get(data, "accountjid", 0));
        }
        catch (NullPointerException npe) {
            note.addAttribute("type", "error");
            note.setText("JID required parameter.");
            return;
        }
        if (!XMPPServer.getInstance().isLocal(account)) {
            note.addAttribute("type", "error");
            note.setText("Cannot create remote user.");
            return;
        }
        String password = this.get(data, "password", 0);
        String passwordRetry = this.get(data, "password-verify", 0);
        if (password == null || "".equals(password) || !password.equals(passwordRetry)) {
            note.addAttribute("type", "error");
            note.setText("Passwords do not match.");
            return;
        }
        String email = this.get(data, "email", 0);
        String givenName = this.get(data, "given_name", 0);
        String surName = this.get(data, "surname", 0);
        String name = (givenName == null ? "" : givenName) + (surName == null ? "" : surName);
        String string = name = name.equals("") ? null : name;
        if (UserManager.getUserProvider().isEmailRequired() && !StringUtils.isValidEmailAddress(email)) {
            note.addAttribute("type", "error");
            note.setText("No email was specified.");
            return;
        }
        try {
            UserManager.getInstance().createUser(account.getNode(), password, name, email);
        }
        catch (UserAlreadyExistsException e) {
            note.addAttribute("type", "error");
            note.setText("User already exists.");
            return;
        }
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Adding a user");
        form.addInstruction("Fill out this form to add a user.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.jid_single);
        field.setLabel("The Jabber ID for the account to be added");
        field.setVariable("accountjid");
        field.setRequired(true);
        field = form.addField();
        field.setType(FormField.Type.text_private);
        field.setLabel("The password for this account");
        field.setVariable("password");
        field = form.addField();
        field.setType(FormField.Type.text_private);
        field.setLabel("Retype password");
        field.setVariable("password-verify");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Email address");
        field.setVariable("email");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Given name");
        field.setVariable("given_name");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Family name");
        field.setVariable("surname");
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return (super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester)) && !UserManager.getUserProvider().isReadOnly();
    }
}

