/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin.group;

import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;

public class DeleteGroup
extends AdHocCommand {
    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Delete group");
        form.addInstruction("Fill out this form to delete a group.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Group Name");
        field.setVariable("group");
        field.setRequired(true);
        command.add(form.getElement());
    }

    @Override
    public void execute(SessionData data, Element command) {
        Group group;
        Element note = command.addElement("note");
        if (GroupManager.getInstance().isReadOnly()) {
            note.addAttribute("type", "error");
            note.setText("Groups are read only");
            return;
        }
        try {
            group = GroupManager.getInstance().getGroup(data.getData().get("group").get(0));
        }
        catch (GroupNotFoundException e) {
            note.addAttribute("type", "error");
            note.setText("Group name does not exist");
            return;
        }
        GroupManager.getInstance().deleteGroup(group);
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#delete-group";
    }

    @Override
    public String getDefaultLabel() {
        return "Delete group";
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }
}

