/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.admin.AdminConsole;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class GetServerStats
extends AdHocCommand {
    @Override
    protected void addStageInformation(SessionData data, Element command) {
    }

    @Override
    public void execute(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.result);
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setLabel(LocaleUtils.getLocalizedString("index.server_name"));
        field.setVariable("name");
        field.addValue((Object)AdminConsole.getAppName());
        field = form.addField();
        field.setLabel(LocaleUtils.getLocalizedString("index.version"));
        field.setVariable("version");
        field.addValue((Object)AdminConsole.getVersionString());
        field = form.addField();
        field.setLabel(LocaleUtils.getLocalizedString("index.domain_name"));
        field.setVariable("domain");
        field.addValue((Object)XMPPServer.getInstance().getServerInfo().getXMPPDomain());
        field = form.addField();
        field.setLabel(LocaleUtils.getLocalizedString("index.jvm"));
        field.setVariable("os");
        String vmName = System.getProperty("java.vm.name");
        vmName = vmName == null ? "" : " -- " + vmName;
        field.addValue((Object)(System.getProperty("java.version") + " " + System.getProperty("java.vendor") + vmName));
        field = form.addField();
        field.setLabel(LocaleUtils.getLocalizedString("index.uptime"));
        field.setVariable("uptime");
        field.addValue((Object)XMPPDateTimeFormat.format(XMPPServer.getInstance().getServerInfo().getLastStarted()));
        DecimalFormat mbFormat = new DecimalFormat("#0.00");
        DecimalFormat percentFormat = new DecimalFormat("#0.0");
        Runtime runtime = Runtime.getRuntime();
        double freeMemory = (double)runtime.freeMemory() / 1048576.0;
        double maxMemory = (double)runtime.maxMemory() / 1048576.0;
        double totalMemory = (double)runtime.totalMemory() / 1048576.0;
        double usedMemory = totalMemory - freeMemory;
        double percentFree = (maxMemory - usedMemory) / maxMemory * 100.0;
        double percentUsed = 100.0 - percentFree;
        field = form.addField();
        field.setLabel(LocaleUtils.getLocalizedString("index.memory"));
        field.setVariable("memory");
        field.addValue((Object)(mbFormat.format(usedMemory) + " MB of " + mbFormat.format(maxMemory) + " MB (" + percentFormat.format(percentUsed) + "%) used"));
        Collection<ClientSession> sessions = SessionManager.getInstance().getSessions();
        HashSet<String> users = new HashSet<String>(sessions.size());
        int availableSessions = 0;
        for (ClientSession session : sessions) {
            if (!session.getPresence().isAvailable()) continue;
            users.add(session.getAddress().toBareJID());
            ++availableSessions;
        }
        field = form.addField();
        field.setLabel("Available Users");
        field.setVariable("activeusersnum");
        field.addValue((Object)users.size());
        field = form.addField();
        field.setLabel("Available Users Sessions");
        field.setVariable("sessionsnum");
        field.addValue((Object)availableSessions);
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return null;
    }

    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#get-server-stats";
    }

    @Override
    public String getDefaultLabel() {
        return "Get basic statistics of the server.";
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return null;
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 0;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester);
    }
}

